;spi_ee.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*March 16, 2000         1.00            Spi eeprom
*Author: Exequiel Rarama
*******************************************************************************
;
;setup PORTS for SPI
;
;
init_spi
        movb    #spi_mask2,DDRS
        movb    #spi_mask2,PORTS
        movb    #%100,PURDS
        
;       movb    #spi_mask3,SP0CR1       ;SPE=1, MSTR=1, CPOL,CPHA=0, SWOM=1
        movb    #spi_mask1,SP0CR1       ;SPE=1, MSTR=1, CPOL,CPHA,SWOM=0

        movb    #8,SP0CR2

;       bclr    SP0CR2,%01              ;SPC0=0, Normal mode
        movb    #spi_baud4,SP0BR        ;set clock to 1 Mhz

        ldaa    SP0SR                   ;clear flag and buffer
        ldaa    SP0DR

        movw    #us8,u_delay_var

        bset    PORTP,slave_select      ;slave select for spi eeprom
        bset    DDRP,slave_select       ;slave select for spi eeprom

        jsr     small_delay

        bclr    PORTP,slave_select      ;enable cs
        ldaa    #%110                   ;set WREN
        jsr     dump_spi_data

        bset    PORTP,slave_select      ;disable cs
        clr     ee_rd_wr_flag
        rts

;-----------------------------------------------------------------------------
go_read                         ;get address to read
        jsr     GetChar
        jsr     SendByte        ;echo the character

        ldab    sci_flag        ;check for character
        beq     go_read10
        clr     sci_flag        ;check for character

        jsr     Hex2Bin         ;convert char to hex
        psha                    ;store temp.

        ldd     eeprom_address  ;get data and shift 4 times
        lsld
        lsld
        lsld
        lsld
        xgdx                    ;exchange d to x
        pulb                    ;get save date

        abx                     ;add to eeprom_address data
        stx     eeprom_address  ; and save it

        dec     char_counter
        bne     go_read10

        clr     ee_rd_wr_flag
        jsr     PutNewLine
        jsr     read_spi
        jsr     PutNewLine

        ldx     #wait_here      ;go back to wait loop
        stx     states

go_read10
        rts

;-----------------------------------------------------------------------------
go_write                        ;get address to write to and data to save
        jsr     GetChar
        jsr     SendByte        ;echo the character

        ldab    sci_flag        ;check for character
        beq     go_write20
        clr     sci_flag        ;check for character

        jsr     Hex2Bin         ;convert char to hex
        psha                    ;store temp.

        ldaa    char_counter
        cmpa    #2
        bls     go_write10

        ldd     eeprom_address  ;get data and shift 4 times
        lsld
        lsld
        lsld
        lsld
        xgdx                    ;exchange
        pulb                    ;get save date

        abx                     ;add to eeprom_address data
        stx     eeprom_address  ; and save it

        dec     char_counter
        bne     go_write20

go_write10
        ldaa    char_counter
        cmpa    #2
        beq     shift10

        pulb
        ldaa    eeprom_data
        aba
        staa    eeprom_data
        bra     shift20

shift10
        pula
        lsla
        lsla
        lsla
        lsla
        staa    eeprom_data
        dec     char_counter
        bra     go_write20

shift20
        clr     ee_rd_wr_flag
        jsr     PutNewLine
        jsr     write_spi
        jsr     PutNewLine

        ldx     #wait_here      ;go back to wait loop
        stx     states

go_write20
        rts

;-----------------------------------------------------------------------------
write_spi
        bclr    PORTP,slave_select      ;enable cs
        ldaa    #%110                   ;set WREN (make sure to enable write)
        jsr     dump_spi_data
        nop
        nop
        bset    PORTP,slave_select      ;disable cs

        jsr     small_delay

        bclr    PORTP,slave_select      ;enable cs
        ldaa    #%010                   ;write to data array
        jsr     dump_spi_data

        ldaa    eeprom_address          ;dump msb address 
        jsr     dump_spi_data

        ldaa    eeprom_address+1        ;dump lsb address 
        jsr     dump_spi_data

        ldaa    eeprom_data             ;write data to eeprom
        jsr     dump_spi_data

        bset    PORTP,slave_select      ;disable cs
        rts        

;-----------------------------------------------------------------------------
read_spi
        bclr    PORTP,slave_select      ;enable cs

        ldaa    #%011                   ;read data array
        jsr     dump_spi_data

        ldaa    eeprom_address          ;dump msb address           
        jsr     dump_spi_data

        ldaa    eeprom_address+1        ;dump lsb address          
        jsr     dump_spi_data

        ldaa    #0                      ;dummy write to get data from eeprom
        jsr     dump_spi_data

        bset    PORTP,slave_select      ;disable cs
        pshb
        pula
        jsr     SendASCIIHex

        rts        

;-----------------------------------------------------------------------------
us_delay
        bclr    TSCR,TEN        ;stop the timer so we can produce accurate time
                                ;delays

        ldd     u_delay_var     ;get constant for 2us delay
        addd    TCNT
        std     TC0
        bset    TSCR,TEN        ;turn on the timer
        brclr   TFLG1,$01,*     ;wait here for 8us

        bclr    TSCR,TEN        ;turn off the timer
        rts

dump_spi_data
        ldab    SP0SR           ;clear flag and buffer
        ldab    SP0DR

        clr     spi_int_flag    ;clear for next spi dump

        bset    SP0CR1,SPIE     ;Enable spi interrupt

        staa    SP0DR                   ;dump to spi to start playback

        brclr   spi_int_flag,$01,*    ;wait here for spi int
        bclr    SP0CR1,SPIE     ;Disable spi interrutp

        ldab    SP0SR           ;clear flag and buffer
        ldab    SP0DR

        clr     spi_int_flag    ;clear for next spi dump

        rts

spi_int
        bset    spi_int_flag,%00000001

        ldaa    SP0SR
        ldaa    SP0DR

        rti
