;
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*990320                   V1.00         
*Author: Exequiel Rarama
********************************************************************************


#include REGS912A.INC

;Spi initialization variables
spi_mask1       equ     %01010000       ;SPE,MSTR=1, SWOM,CPOL,CPHA=0
spi_mask2       equ     %11100000       ;Bit 7,6,5=1 the rest=0

spi_baud1       equ     %00000000       ;4.0 Mhz
spi_baud2       equ     %00000001       ;2.0 Mhz
spi_baud3       equ     %00000010       ;1.0 Mhz
spi_baud4       equ     %00000011       ;0.5 Mhz
spi_baud5       equ     %00000100       ;250 kHz
spi_baud6       equ     %00000101       ;125 kHz
spi_baud7       equ     %00000110       ;62.5 kHz
spi_baud8       equ     %00000111       ;31.3 kHz

SPIF            equ     %10000000       ;flag after the 8th clock
SPIE            equ     %10000000       ;Spi interrupt enable    
LSBF            equ     %00000001       ;SPI LSB First enable
SSPIN           equ     %10000000       ;max3100 chip select

max_config1     equ     %11001111       ;Send these to configure the MAX3100
max_config2     equ     %00001011       ;9600 baud

max_config3     equ     %01000000       ;Send these to read MAX3100 configuration
max_config4     equ     %00000000

max_wr1         equ     %10000000       ;write data to MAX3100
max_rd          equ     %00000000       ;read data from MAX3100

TEN             equ     $80
us2             equ     8

;-----------------------------------------------------------------------------
RAM             equ     $0800
STACK           equ     $0BFF

;SCI Variables
scimask         equ     %00001100       ;TE - Transmit Enable
                                        ;RE - Receiver Enable
RDRFflag        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
;MCLK=8Mzh
BAUD110         equ     4545    ;(baud) 110 baud with 16 Mhz crystal
BAUD300         equ     1667    ;(baud) 300 baud with 16 Mhz crystal
BAUD600         equ     833     ;(baud) 600 baud with 16 Mhz crystal
BAUD1200        equ     417     ;(baud) 1200 baud with 16 Mhz crystal
BAUD2400        equ     208     ;(baud) 2400 baud with 16 Mhz crystal
BAUD4800        equ     104     ;(baud) 4800 baud with 16 Mhz crystal
BAUD9600        equ     52      ;(baud) 9600 baud with 16 Mhz crystal
BAUD14400       equ     35      ;(baud) 14400 baud with 16 Mhz crystal
BAUD19200       equ     26      ;(baud) 19200 baud with 16 Mhz crystal
BAUD38400       equ     13      ;(baud) 19200 baud with 16 Mhz crystal


        org     RAM

max_wr_data1    ds      2
max_rd_data1    ds      2
comm1_data_flag ds      1
spi_flag        ds      1
spi_int_flag    ds      1


        org     $8000

; Start of Program
; ----------------
Init
        sei
        lds     #STACK                  ;initialize stack to top of ram
        
;Initialize PORTP
        movb    #%10000000,DDRP         ;Bit 7 PORTP as Output
        movb    #%10000000,PORTP        ;PORTP clear

;Initialize SCI
        movb    #scimask,SC0CR2         ;enable SCI 0 rcvr. & xmtr.
        movb    #0,SC0CR1
        movw    #BAUD9600,SC0BDH
 
        ldaa    SC0SR1                  ;read register to clear flag RDRF
        ldaa    SC0DRL                  ;dummy read to flush receive buffer

        jsr     init_SPI                ;Initialize SPI
        cli
        jsr     init_MAX                ;Initialize MAX3100

        ldx     #BLPrompt
        jsr     OutStr

main                                    ;Main loop

        movb    #%10000000,PORTP        ;PORTP clear
        bsr     delay
        movb    #%00000000,PORTP        ;PORTP clear
        bsr     delay

        movb    #$55,COPRST
        movb    #$AA,COPRST

        jsr     max_out
        bra     main


delay
        ldy     #0
dly
        dey
        bne     dly
        rts


init_SPI                                ;Initialize SPI
        bset    PORTS,SSPIN             ;inititalize port to 1
        movb    #spi_mask2,DDRS
        movb    #spi_mask1,SP0CR1       ;SPE,MSTR=1, CPOL,SWOM,CPHA=0
        bclr    SP0CR2,%01              ;SPC0=0, Normal mode
        movb    #spi_baud3,SP0BR        ;set clock to 1 Mhz

        ldaa    SP0SR                   ;clear flag and buffer
        ldaa    SP0DR

        clr     spi_int_flag
        rts

init_MAX
        bclr    PORTS,SSPIN          ;Select MAX3100

        movb    #max_config1,max_wr_data1
        movb    #max_config2,max_wr_data1+1

        ldaa    max_wr_data1
        jsr     dump_spi_data

        ldaa    max_wr_data1+1
        jsr     dump_spi_data

        bset    PORTS,SSPIN          ;de-Select MAX3100
        rts

dump_spi_data
        ldab    SP0SR                   ;clear flag and buffer
        ldab    SP0DR

        clr     spi_int_flag            ;clear for next spi dump
        bset    SP0CR1,SPIE             ;Enable spi interrupt
        staa    SP0DR                   ;dump to spi to start playback

        brclr   spi_int_flag,$01,*      ;wait here for spi int
        bclr    SP0CR1,SPIE             ;Disable spi interrutp
        clr     spi_int_flag            ;clear for next spi dump

        rts

max_out
        ldaa    #%10000000              ;write data
        bclr    PORTS,SSPIN             ;Select MAX3100
        jsr     dump_spi_data

        ldaa    #$55                    ;dump data to be transmitted
        jsr     dump_spi_data
        bset    PORTS,SSPIN             ;de-Select MAX3100

        rts
        
spi_int
        bset    spi_int_flag,%00000001
        ldaa    SP0SR
        ldaa    SP0DR
        rti



OutStr:                         ; send a null terminated string to the display.
        ldaa    1,x+            ; get a character, advance pointer, null?
        beq     OutStrDone      ; yes. return.
        jsr     SerOutput       ; no. send it out the SCI.
        bra     OutStr          ; go get the next character.
;
OutStrDone:
        rts

SerOutput
        brclr   SC0SR1,TDREflag,SerOutput      ;check if buffer is empty
        staa    SC0DRL
        rts

;Table of Messages
;
BLPrompt        fcb     $0d,$0a
                fcc     "testing"
                fcb     0
LFeed:          fcb     $0c,0
CrLfStr:        fcb     $0d,$0a,0
OK              fcc     "Upload file NOW"
                fcb     0
EXE             fcc     "Executing Program NOW"
                fcb     0


	org	$FFCE

        FDB     Init           ;KEY WAKEUP H
        FDB     Init           ;KEY WAKEUP J
        FDB     Init           ;ANALOG TO DIGITAL
        FDB     Init           ;SERIAL COMMUNICATION 1
        FDB     Init	       ;SERIAL COMMUNICATION 0
        FDB     spi_int        ;SPI SERIAL TRANSFER COMPLETE
        FDB     Init           ;PULSE ACCUMULATOR INPUT EDGE
        FDB     Init           ;PULSE ACCUMULATOR OVERFLOW
        FDB     Init           ;TIMER OVERFLOW
        FDB     Init           ;TIMER CHANNEL 7
        FDB     Init           ;TIMER CHANNEL 6
        FDB     Init           ;TIMER CHANNEL 5
        FDB     Init           ;TIMER CHANNEL 4
        FDB     Init           ;TIMER CHANNEL 3
        FDB     Init           ;TIMER CHANNEL 2
        FDB     Init           ;TIMER CHANNEL 1
        FDB     Init           ;TIMER CHANNEL 0
        FDB     Init	       ;REAL TIME INTERRUPT
        FDB     Init           ;IRQ OR KEY WAKE UP D
        FDB     Init           ;XIRQ
        FDB     Init           ;SWI
        FDB     Init           ;RESERVED
        FDB     Init           ;COP FAILURE RESET
        FDB     Init           ;COP CLOCK MONITOR FAIL RESET
        FDB     Init           ;RESET
