;Bootloader
;
;Author: Exequiel Rarama

program_code
        ldx     #OK
        jsr     OutStr

pr10
        brclr   SC0SR1,RDRFflag,*
        ldab    SC0SR1          ;read register to clear flag RDRF
        ldab    SC0DRL          ;read receive buffer
        cmpb    #'S'            ;Wait until S received
        bne     pr10

        ldaa    #%00001100
        staa    PEAR
        ldaa    #%11110001
        staa    MODE
        ldaa    #%00001100
        staa    MISC

        bset    PORTT,%01000000         ;Test led 'ON' at start of burn
        bra     got_S

prg_ram                                 ;program a byte
        stab    0,y                     ;store data to be burn
        rts

load_s19

        bsr     readc
        cmpb    #'S'            ;Wait until S1 or S9 received,
        bne     load_s19        ; discarding checksum of previous S1 record
got_S
        bsr     readc
        cmpb    #'1'
        beq     load1           ;load1

        cmpb    #'9'
        bne     load_s19        ;Check for termination signal
        bra     led_off         ;Go signal the end of eeprom burn

load1
        bsr     rdbyte          ;Complete reading S9 record before terminating
        tba
        suba    #3              ;# of bytes, subtract address (2 byte) and checksum (1 byte)
        staa    byte_count      ;store it into byte counter

        bsr     getadr          ;Get the address of where to burn the data into eeprom
                                ;The address in contained in y reg
go_next_byte
        bsr     rdbyte          ;Get data to burn into the RAM
                                ;Reg b contains the data to be written
        jsr     prg_ram         ;Go burn ram
        iny                     ;increment address

        dec     byte_count      ;Decrement byte counter
        bne     go_next_byte    ;Go get next byte to burn
        bra     load_s19        ;End of S19 message, go get another one

led_off                                 
        bclr    PORTT,%01000000
        jmp     run_code

rdbyte
        bsr     readc           ;first read MS nibble
        bsr     hexbin          ;convert to binary
        lslb                    ;and move to upper nibble
        lslb
        lslb
        lslb
        stab    temp
        bsr     readc           ;Get ASCII char in ACCB
        bsr     hexbin
        orab    temp
        rts

getadr
        psha                    ;save byte counter
        bsr     rdbyte          ;Read MS byte of address
        tba                     ;and put it in MS byte of ACCD
        bsr     rdbyte          ;Now read LS byte of address into Ls byte of ACCD
        xgdy                    ;Put load address in Y
        pula                    ;Restore byte counter
        rts                     ;and return

hexbin
        cmpb    #'9'            ;if ACCB>9 then assume its A-F
        bls     hexnum
        addb    #9

hexnum
        andb    #$0f
        rts

;--------------------------------
readc
        brclr   SC0SR1,RDRFflag,readc
        ldab    SC0SR1          ;read register to clear flag RDRF
        ldab    SC0DRL          ;read receive buffer
        rts

