;AUDIO.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*Dec 24, 2000           1.00            Initial release
*Feb 27, 2001		1.01		For 8Mhz cyrstal, Pll enabled
*
*Revised by Exequiel Rarama for the ADAPT 912D60
********************************************************************************
;
;Port T, bit 6 is use to drive the speaker.
;The port pin will toggle on compare.
;
; ---------------------------
; Demo - Audio Routine
; ---------------------------

TONE_2K         equ     500     ;frequencies in Hertz for tone generation
TONE_1K         equ     1000
TONE_440        equ     2272
TONE_220        equ     4545
TONE_180        equ     3000
TONE_110        equ     9090
TONE_60         equ     16666

OC6mask1        equ     %01000000       ;IOS6 = 1, Bit 6 as output compare
OC6mask2        equ     %01000000       ;C6I = 1, Enable Interrupt
OC6mask3        equ     %00010000       ;OM6 = 0, OL6 = 1, toggel OC output line
OC6flag         equ     %01000000       ;C6F = 1 to clear Interrupt flag

;Audio variables are define in "MAIN.ASM"
;DURATION        rmb     2       ;used for tone generation
;HALF_PERIOD     rmb     2


;Initialize PORTT bit 6 as output compare
audio_init
        bset    TSCR,%10000000        ;TEN=1 - Enable timer
        bset    TIOS,%01000000        ;Bit 7 of PORTG use as Audio timer
        rts
 
PulseXToneB

* b contains number of beeps desired
* x contains tone frequency
* y contains tone duration (eg. if y=1  => duration=4.1 ms; y=255 => 1 sec)

        sty     DURATION
rpt
        jsr     EnableToneX     ;tone generated via OutputCompare feature
        movw    DURATION,TIMER
d2_1
        ldy     TIMER
        bne     d2_1

        ldaa    #%00000000      ;toggle oc
        staa    TMSK1           ;turn off tone
        staa    TCTL1

        movw    DURATION,TIMER
d2_2
        ldy     TIMER
        bne     d2_2
        dbne    b,rpt
        rts

EnableToneX:
        sei                     ;tone generation done via OutputCompare
        stx     HALF_PERIOD

        ldaa    PORTG
        coma
        staa    PORTG

;       movb    #%00010000,TCTL1     ;toggle oc

        ldaa    #%01000000
        staa    TMSK1           ;enable OC6 interrupt
        staa    TFLG1           ;clear flag
        cli
        rts

*  Output Compare Interrupt Handler
;------------------------
; Audio Interrupt Routine
; -----------------------
;OC6Int
;audio_int
;        ldd     HALF_PERIOD
;        addd    TC6
;        std     TC6
;        movb    #%01000000,TFLG1                   ;clear flag
;        rti
