;MAIN.ASM
;MC68HC912DG128 MAIN ROUTINE
;REGD128.INC CONTAINS ALL REGISTERS
;Flash-resident Flash loader for ADAPT912DG128
*******************************************************************************
*REVISION HISTORY:
*
*DATE				REV. NO.	DESCRIPTION
*
*March 8, 2000		V1.00		- Boot Flash
*
*Nov 30, 2000			V1.01		- Fix bugs
*
*Dec 8, 2000			V1.02		- Fix vector table (by CB)
*
*Apr 3, 2001			V1.03		- 
*
*Oct 16, 2001			V1.04		- 
*
*November 24, 2001		V1.05		- External Ram support in Non-Page mode (page mode not supported)
*						- Command to Execute Internal/External Program
*						- Led will toggle if Pseudo Vector $DFFE:DFFF are $FFFF
*						- During Ram Load, LED will come ON if faulty write to RAM
*
*
*Author: Exequiel Rarama
********************************************************************************
;Assembled with MiniIDE
;Flash-resident Flash loader for the 912DG128
;Resides in 8K protected block from $e000 to $ffff
;Pseudo vector table is below protected block, begins at $dfce
;Bootload Mode when PORTA6 is pulled low
;Runs user program when PORTA6 is left open (pulled high internally)
;
; -----------------------
;Main Routine
; -----------------------

#INCLUDE "REGD128.INC"                ;register block addresses

RAM     equ     $2000           ;68HC912D128 internal RAM
STACK   equ     $4000           ;Stack at top of internal ram

EEPROM  equ     $0800           ;68HC912D128 internal EEPROM
FLASH   equ     $8000           ;68HC912D128 internal FLASH memory

FlashStart      equ     $8000
BootFlash       equ     $e000
FlashSize       equ     32768
BootBlkSize     equ     8192

mode0           equ     %00
mode1           equ     %01
mode2           equ     %10
mode3           equ     %11

;CodeStart       equ     $8000   ;Start of Code

;SCI Variables
scimask         equ     %00101100       ;RIE - SCI Interrupt enable
scimask1        equ     $0c             ;TE - Transmit Enable, RE - Receiver Enable
RDRFflag        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
;MCLK=8Mhz
BAUD110         equ     4545*2    ;(baud) 110 baud with 8 Mhz crystal
BAUD300         equ     1667*2    ;(baud) 300 baud with 8 Mhz crystal
BAUD600         equ     833*2     ;(baud) 600 baud with 8 Mhz crystal
BAUD1200        equ     417*2     ;(baud) 1200 baud with 8 Mhz crystal
BAUD2400        equ     208*2     ;(baud) 2400 baud with 8 Mhz crystal
BAUD4800        equ     104*2     ;(baud) 4800 baud with 8 Mhz crystal
BAUD9600        equ     52*2      ;(baud) 9600 baud with 8 Mhz crystal
BAUD14400       equ     35*2      ;(baud) 14400 baud with 8 Mhz crystal
BAUD19200       equ     26*2      ;(baud) 19200 baud with 8 Mhz crystal
BAUD38400       equ     13*2      ;(baud) 19200 baud with 8 Mhz crystal
;
;Boot Flash Variables
S0REcType       equ     '0'     ;ASCII '0' used as S0 record type indicator
S1REcType       equ     '1'     ;ASCII '1' used as S1 record type indicator
S9REcType       equ     '9'     ;ASCII '9' used as S9 record type indicator

us22            equ     175/2
us11            equ     88/2
ms100           equ     $30d4/2   ;$61a8
ms1             equ     $9c3/2
TEN             equ     $80

ENPE            equ     %0001
LAT             equ     %0010
ERAS            equ     %0100
SVFP            equ     %1000
MaxProgPulses   equ     50      ;maximum number of programming pulses.
MaxErasePulses  equ     5       ;maximum number of erase pulses

;ByteWord        equ     (FlashSize-BootBlkSize)/2
;ByteWord        equ     $3c00
ByteWord        equ     $1fff

;Pll variables
LOCK		equ	%01000000
BCSP		equ	%01000000

NECLK		equ	%00010000
ESTR		equ	%00010000
LED		equ	%10000000

;-----------------------------------------------------------------------------
        org     RAM

;Ram Variables
RecType         ds      1
DataBytes       ds      1
LoadAddr        ds      2
SRecData        ds      65

ProgPulses      ds      1
PMarginFlag     ds      1
EMarginFlag     ds      1
NumPulses       ds      1
NotErasedFlag   ds      1
SRecBytes       ds      1
CheckSum        ds      1
temp            ds      1
temp1           ds      1
CURPAGE         ds      1
Ramcode         equ     CURPAGE+1

        org     BootFlash
;
BootStart                       ;This is where the RESET vector points to
        sei                     ;Disable Any interrupts

;Initialize Stack
        lds     #STACK          ;initialize stack pointer
        bset    PUCR,$1                 ;turn on PORTA pullups (for Mode Sel)

        brclr   PORTA,$40,BootCopy      ;if port bit 6 is low then
                                        ;  do boot sequence
execute_code
	ldx	PowerOn-$2000              ; else execute user program
	cpx	#$FFFF			;Check if Blank
	beq	Program_Trap

	jmp	0,x

Program_Trap
	clr	COPCTL                  ;Disable watchdog timer
	bset	DDRJ,LED
	clr	PORTJ

Trap10
	com	PORTJ
	bsr	delay
	bra	Trap10

delay
	ldx	#$FFFF

dly	
	dbne	x,dly
	rts

;----------------------------------
;Start of boot programming sequence. Copies bootstrap routines to RAM then
; jumps to RAM to execute.

BootCopy
        clr     COPCTL                  ;Disable watchdog timer
        ldx     #BootLoad               ;Point to the start of the Flash bootloader
        ldy     #Ramcode                ;memory ram location to save boot.
        ldd     #code_len               ;End of boot code

MoveMore
        movb    1,x+,1,y+               ;move byte to ram
        dbne    d,MoveMore              ; until done

;Initialize Serial Communication Interface
        movb    #scimask1,SC0CR2        ;enable SCI 0 rcvr. & xmtr.
        movb    #0,SC0CR1
;
        movw    #BAUD9600,SC0BDH        ;Set baud rate to 9600
        ldab    SC0SR1                  ;read register to clear flag RDRF
        ldab    SC0DRL                  ;read receive buffer

	jmp	Ramcode                 ;execute code

;-----------------------------------------------------------------------------
;Psuedo Vector Interrupts

JMSCAN1TX
        ldx     MSCAN1TX-$2000          ;MSCAN1 TRANSMIT
        jmp     0,x

JMSCAN1RX
        ldx     MSCAN1RX-$2000          ;MSCAN1 RECEIVE
        jmp     0,x

JMSCAN1ERR
        ldx     MSCAN1ERR               ;MSCAN1 ERRORS
        jmp     0,x

JMSCAN1WU
        ldx     MSCAN1WU-$2000          ;MSCAN1 WAKEUP
        jmp     0,x

JIIC
        ldx     IIC-$2000               ;IIC BUS
        jmp     0,x

JCGMLL
        ldx     CGMLL-$2000             ;CGM LOCK AND LIMP HOME
        jmp     0,x

JMSCAN0TX
        ldx     MSCAN0TX-$2000          ;MSCAN0 TRANSMIT
        jmp     0,x

JMSCAN0RX
        ldx     MSCAN0RX-$2000          ;MSACN0 RECEIVE
        jmp     0,x

JMSCAN0ERR
        ldx     MSCAN0ERR-$2000         ;MSCAN ERRORS
        jmp     0,x

JPBCTRL
        ldx     PBCTRL-$2000            ;PULSE ACCUMULATOR B OVERFLOW
        jmp     0,x

JMCCTRL
        ldx     MCCTRL-$2000            ;MODULUS DOWN COUNTER UNDERFLOW
        jmp     0,x

JKWJH
        ldx     KWJH-$2000       ;KEY WAKEUP J OR H
        jmp     0,x

JMSCAN0WU
        ldx     MSCAN0WU-$2000       ;MSCAN0 WAKEUP
        jmp     0,x

JATD
        ldx     ATD-$2000      ;ANALOG TO DIGITAL
        jmp     0,x

JSCI1
        ldx     SCI1-$2000     ;SERIAL COMMUNICATION 0
        jmp     0,x

JSCI0
        ldx     SCI0-$2000     ;SERIAL COMMUNICATION 0
        jmp     0,x

JSPI
        ldx     SPI-$2000      ;SPI SERIAL TRANSFER COMPLETE
        jmp     0,x

JPACCIE
        ldx     PACCIE-$2000   ;PULSE ACCUMULATOR INPUT EDGE
        jmp     0,x

JPACCOv
        ldx     PACCOv-$2000   ;PULSE ACCUMULATOR OVERFLOW
        jmp     0,x

JTimerOv
        ldx     TimerOv-$2000  ;TIMER OVERFLOW
        jmp     0,x

JTimerCh7
        ldx     TimerCh7-$2000 ;TIMER CHANNEL 7
        jmp     0,x

JTimerCh6
       ldx      TimerCh6-$2000 ;TIMER CHANNEL 6
       jmp      0,x

JTimerCh5
        ldx     TimerCh5-$2000 ;TIMER CHANNEL 5
        jmp     0,x

JTimerCh4
        ldx     TimerCh4-$2000  ;TIMER CHANNEL 4
        jmp     0,x

JTimerCh3
        ldx     TimerCh3-$2000  ;TIMER CHANNEL 3
        jmp     0,x

JTimerCh2
        ldx     TimerCh2-$2000  ;TIMER CHANNEL 2
        jmp     0,x

JTimerCh1
        ldx     TimerCh1-$2000  ;TIMER CHANNEL 1
        jmp     0,x

JTimerCh0
        ldx     TimerCh0-$2000  ;TIMER CHANNEL 0
        jmp     0,x

JRTI
        ldx     RTI-$2000       ;REAL TIME INTERRUPT
        jmp     0,x

JIRQ
        ldx     IRQ-$2000       ;IRQ OR KEY WAKE UP D
        jmp     0,x

JXIRQ
        ldx     XIRQ-$2000      ;XIRQ
        jmp     0,x

JSWI
        ldx     SWI-$2000       ;SWI
        jmp     0,x

JIllop
        ldx     Illop-$2000     ;RESERVED
        jmp     0,x

JCOPFail
        ldx     COPFail-$2000   ;COP FAILURE RESET
        jmp     0,x

JClockFail
        ldx     ClockFail-$2000 ;COP CLOCK MONITOR FAIL RESET
        jmp     0,x

Reset
        ldx     PowerOn-$2000   ;Pseudo reset
        jmp     0,x

;=============================================================================

#INCLUDE "EEFLASH.ASM"

;-----------------------------------------------------------------------------
;MC68HC912D128 INTERRUPT VECTORS

        ORG     $FFB8

MSCAN1TX        dc.w     JMSCAN1TX       ;MSCAN1 TRANSMIT
MSCAN1RX        dc.w     JMSCAN1RX       ;MSCAN1 RECEIVE
MSCAN1ERR       dc.w     JMSCAN1ERR      ;MSCAN1 ERRORS
MSCAN1WU        dc.w     JMSCAN1WU       ;MSCAN1 WAKEUP
IIC             dc.w     JIIC            ;IIC BUS
CGMLL           dc.w     JCGMLL          ;CGM LOCK AND LIMP HOME
MSCAN0TX        dc.w     JMSCAN0TX       ;MSCAN0 TRANSMIT
MSCAN0RX        dc.w     JMSCAN0RX       ;MSACN0 RECEIVE
MSCAN0ERR       dc.w     JMSCAN0ERR      ;MSCAN ERRORS
PBCTRL          dc.w     JPBCTRL         ;PULSE ACCUMULATOR B OVERFLOW
MCCTRL          dc.w     JMCCTRL         ;MODULUS DOWN COUNTER UNDERFLOW
KWJH            dc.w     JKWJH           ;KEY WAKEUP J OR H
MSCAN0WU        dc.w     JMSCAN0WU       ;MSCAN0 WAKEUP
ATD             dc.w     JATD            ;ANALOG TO DIGITAL

SCI1            dc.w     JSCI1           ;SERIAL COMMUNICATION 1
SCI0            dc.w     JSCI0           ;SERIAL COMMUNICATION 0
SPI             dc.w     JSPI            ;SPI SERIAL TRANSFER COMPLETE
PACCIE          dc.w     JPACCIE         ;PULSE ACCUMULATOR INPUT EDGE
PACCOv          dc.w     JPACCOv         ;PULSE ACCUMULATOR OVERFLOW
TimerOv         dc.w     JTimerOv        ;TIMER OVERFLOW

TimerCh7        dc.w     JTimerCh7       ;TIMER CHANNEL 7
TimerCh6        dc.w     JTimerCh6       ;TIMER CHANNEL 6
TimerCh5        dc.w     JTimerCh5       ;TIMER CHANNEL 5
TimerCh4        dc.w     JTimerCh4       ;TIMER CHANNEL 4
TimerCh3        dc.w     JTimerCh3       ;TIMER CHANNEL 3
TimerCh2        dc.w     JTimerCh2       ;TIMER CHANNEL 2
TimerCh1        dc.w     JTimerCh1       ;TIMER CHANNEL 1
TimerCh0        dc.w     JTimerCh0       ;TIMER CHANNEL 0

RTI             dc.w     JRTI            ;REAL TIME INTERRUPT

IRQ             dc.w     JIRQ            ;IRQ OR KEY WAKE UP D
XIRQ            dc.w     JXIRQ           ;XIRQ
SWI             dc.w     JSWI            ;SWI
Illop           dc.w     JIllop          ;RESERVED
COPFail         dc.w     JCOPFail        ;COP FAILURE RESET
ClockFail       dc.w     JClockFail      ;COP CLOCK MONITOR FAIL RESET
PowerOn         dc.w     BootStart       ;RESET
