;MC68HC912DA128 REGISTER MAP
;MEMORY BLOCK BEGINS AT 0000H AND ENDS AT 37FH

REG     EQU     $0000

PORTA   EQU     $0000           ;PORTA
PORTB   EQU     $0001           ;PORTB
DDRA    EQU     $0002           ;PORTA - DATA DIRECTION REGISTER
DDRB    EQU     $0003           ;PORTB - DATA DIRECTION REGISTER

PORTE   EQU     $0008           ;PORTE
DDRE    EQU     $0009           ;PORTE - DATA DIRECTION REGISTER
PEAR    EQU     $000A           ;PEAR - PORTE ASSIGNMENT REGISTER
MODE    EQU     $000B           ;MODE - MODE REGISTER
PUCR    EQU     $000C           ;PUCR - PULL UP CONTROL REGISTER
RDRIV   EQU     $000D           ;RDRIV - REDUCED DRIVE OF I/O LINES

INITRM  EQU     $0010           ;INITRM - INITIALIZATION OF INTERNAL RAM POSITION REGISTER
INITRG  EQU     $0011           ;INITRG - INITIALIZATION OF INTERNAL REGISTER POSITION REGISTER
INITEE  EQU     $0012           ;INITEE - INITIALIZATION OF INTERNAL EEPROM POSITION REGISTER
MISC    EQU     $0013           ;MISC - MISCELLANEOUS MAPPING CONTROL REGISTER
RTICTL  EQU     $0014           ;RTICTL - REAL TIME INTERRUPT CONTROL REGISTER
RTIFLG  EQU     $0015           ;RTIFLG - REAL TIME INTERRUPT FLAG REGISTER
COPCTL  EQU     $0016           ;COPCTL - COP CONTROL REGISTER
COPRST  EQU     $0017           ;COPRST - ARM/RESET COP TIMER REGISTER

ITST0   EQU     $0018           ;ITST0
ITST1   EQU     $0019           ;ITST1
ITST2   EQU     $001A           ;ITST2
ITST3   EQU     $001B           ;ITST3

INTCR   EQU     $001E           ;INTCR - INTERRUPT CONTROL REGISTER
HPRIO   EQU     $001F           ;HPRIO - HIGHEST PRIORITY I INTERRRUPT

BRKCT0  EQU     $0020           ;BRKCT0
BRKCT1  EQU     $0021           ;BRKCT1
BRKAH   EQU     $0022           ;BRKAH
BRKAL   EQU     $0023           ;BRKAL
BRKDH   EQU     $0024           ;BRKDH
BRKDL   EQU     $0025           ;BRKDL
 
PORTJ   EQU     $0028           ;PORTJ
PORTH   EQU     $0029           ;PORTH
DDRJ    EQU     $002A           ;DDRJ - PORTJ DATA DIRECTION
DDRH    EQU     $002B           ;DDRH - PORTH DATA DIRECTION
KWIEJ   EQU     $002C           ;KWIEJ - KEY WAKEUP PORTJ INTERRUPT ENABLE REGISTER
KWIEH   EQU     $002D           ;KWIEH - KEY WAKEUP PORTH INTERRUPT ENABLE REGISTER
KWIFJ   EQU     $002E           ;KWIFJ - KEY WAKEUP PORTJ FLAG REGISTER
KWIFH   EQU     $002F           ;KWIFH - KEY WAKEUP PORTH FLAG REGISTER
KWPJ    EQU     $0030           ;KWPJ -
KWPH    EQU     $0031           ;KWPH -

SYNR    EQU     $0038           ;SYNR -
REFDV   EQU     $0039           ;REFDV -
CGTFLG  EQU     $003A           ;CGTFLG -
PLLFLG  EQU     $003B           ;PLLFLG -
PLLCR   EQU     $003C           ;PLLCR -
CLKSEL  EQU     $003D           ;CLKSEL -
SLOW    EQU     $003E           ;SLOW -
CGTCTL  EQU     $003F           ;CGTCTL -

PWCLK   EQU     $0040           ;PWCLK -
PWPOL   EQU     $0041           ;PWPOL - 
PWEN    EQU     $0042           ;PWEN - 
PWPRES  EQU     $0043           ;PWPRES - 
PWSCAL0 EQU     $0044           ;PWSCAL0
PWSCNT0 EQU     $0045           ;PWSCNT0
PWSCAL1 EQU     $0046           ;PWSCAL1
PWSCNT1 EQU     $0047           ;PWSCNT1
PWCNT0  EQU     $0048           ;PWCNT0
PWCNT1  EQU     $0049           ;PWCNT1
PWCNT2  EQU     $004A           ;PWCNT2
PWCNT3  EQU     $004B           ;PWCNT3
PWPER0  EQU     $004C           ;PWPER0
PWPER1  EQU     $004D           ;PWPER1
PWPER2  EQU     $004E           ;PWPER2
PWPER3  EQU     $004F           ;PWPER3
PWDTY0  EQU     $0050           ;PWDTY0
PWDTY1  EQU     $0051           ;PWDTY1
PWDTY2  EQU     $0052           ;PWDTY2
PWDTY3  EQU     $0053           ;PWDTY3
PWCTL   EQU     $0054           ;PWCTL
PWTST   EQU     $0055           ;PWTST

PORTP   EQU     $0056           ;PORTP - PORTP REGISTER
DDRP    EQU     $0057           ;DDRP - DATA DIRECTION REGISTER

ATD0CTL0        EQU     $0060   ;ATDCTL0 - RESERVED
ATD0CTL1        EQU     $0061   ;ATDCTL1 - RESERVED
ATD0CTL2        EQU     $0062   ;ATDCTL2 - ATD CONTROL REGISTER
ATD0CTL3        EQU     $0063   ;ATDCTL3 - ATD CONTROL REGISTER
ATD0CTL4        EQU     $0064   ;ATDCTL4 - ATD CONTROL REGISTER
ATD0CTL5        EQU     $0065   ;ATDCTL5 - ATD CONTROL REGISTER

ATD0STAT0       EQU     $0066   ;ATDSTAT - ATD STATUS HIGH REGISTER
ATD0STAT1       EQU     $0067   ;ATDSTAT - LOW REGISTER
ATD0TESTH       EQU     $0068   ;ATDTEST - ATD TEST HIGH REGISTER
ATD0TESTL       EQU     $0069   ;ATDTEST - LOW REGISTER

PORTAD0 EQU     $006F           ;PORTAD - PORT AD DATA INPUT REGISTER
ADR00H  EQU     $0070           ;ADR00H
ADR00L  EQU     $0071           ;ADR00L
ADR01H  EQU     $0072           ;ADR01H
ADR01L  EQU     $0073           ;ADR01L
ADR02H  EQU     $0074           ;ADR02H
ADR02L  EQU     $0075           ;ADR02L
ADR03H  EQU     $0076           ;ADR03H
ADR03L  EQU     $0077           ;ADR03L
ADR04H  EQU     $0078           ;ADR04H
ADR04L  EQU     $0079           ;ADR04L
ADR05H  EQU     $007A           ;ADR05H
ADR05L  EQU     $007B           ;ADR05L
ADR06H  EQU     $007C           ;ADR06H
ADR06L  EQU     $007D           ;ADR06L
ADR07H  EQU     $007E           ;ADR07H
ADR07L  EQU     $007F           ;ADR07L

TIOS    EQU     $0080           ;TIOS - TIMER INPUT CAPTURE/OUTPUT COMPARE SELECT
CFORC   EQU     $0081           ;CFORC - TIMER COMPARE FORCE REGISTER
OC7M    EQU     $0082           ;OC7M - OUTPUT COMPARE 7 MASK REGISTER
OC7D    EQU     $0083           ;OC7D - OUTPUT COMPARE 7 DATA REGISTER

TCNT    EQU     $0084

TSCR    EQU     $0086           ;TSCR - TIMER SYSTEM CONTROL REGISTER
TQCR    EQU     $0087           ;TQCR - RESERVED
TCTL1   EQU     $0088           ;TCTL1 - TIMER CONTROL REGISTER 1
TCTL2   EQU     $0089           ;TCTL2 - TIMER CONTROL REGISTER 2
TCTL3   EQU     $008A           ;TCTL3 - TIMER CONTROL REGISTER 3
TCTL4   EQU     $008B           ;TCTL4 - TIMER CONTROL REGISTER 4

TMSK1   EQU     $008C           ;TMSK1 - TIMER INTERRUPT MASK 1
TMSK2   EQU     $008D           ;TMSK2 - TIMER INTERRUPT MASK 2

TFLG1   EQU     $008E           ;TFLG1 - TIMER INTERRUPT FLAG 1
TFLG2   EQU     $008F           ;TFLG2 - TIMER INTERRUPT FLAG2

TC0     EQU     $0090           ;TC0 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC1     EQU     $0092           ;TC1 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC2     EQU     $0094           ;TC2 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC3     EQU     $0096           ;TC3 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC4     EQU     $0098           ;TC4 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC5     EQU     $009A           ;TC5 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC6     EQU     $009C           ;TC6 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC7     EQU     $009E           ;TC7 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0

PACTL   EQU     $00A0           ;PATCL - PULSE ACCUMULATOR CONTROL REGISTER
PAFLG   EQU     $00A1           ;PAFLG - PULSE ACCUMULATOR FLAG REGISTER

PACN3   EQU     $00A2           ;PACN3
PACN2   EQU     $00A3           ;PACN2
PACN1   EQU     $00A4           ;PACN1
PACN0   EQU     $00A5           ;PACN0

MCCTL   EQU     $00A6           ;MCCTL
MCFLG   EQU     $00A7           ;MCFLG
ICPAR   EQU     $00A8           ;ICPAR
DLYCT   EQU     $00A9           ;DLYCT
ICOVW   EQU     $00AA           ;ICOVW
ICSYS   EQU     $00AB           ;ICSYS

TIMTST  EQU     $00AD           ;TIMTST - TIMER TEST REGISTER
PORTT   EQU     $00AE           ;PORTT
DDRT    EQU     $00AF           ;DDRT - DATA DIRECTION REGISTER

PBCTL   EQU     $00B0           ;PBCTL
PBFLG   EQU     $00B1           ;PBFLG
PA3H    EQU     $00B2           ;PA3H
PA2H    EQU     $00B3           ;PA2H
PA1H    EQU     $00B4           ;PA1H
PA0H    EQU     $00B5           ;PA0H
MCCNTH  EQU     $00B6           ;MCCNTH
MCCNTL  EQU     $00B7           ;MCCNTL

TC0H    EQU     $00B8           ;TC0H
TC0L    EQU     $00B9           ;TC0L
TC1H    EQU     $00BA           ;TC1H
TC1L    EQU     $00BB           ;TC1L
TC2H    EQU     $00BC           ;TC2H
TC2L    EQU     $00BD           ;TC2L
TC3H    EQU     $00BE           ;TC3H
TC3L    EQU     $00BF           ;TC3L

SC0BDH  EQU     $00C0           ;SC0BDH - SCI BAUD RATE CONTROL REGISTER
SC0BDL  EQU     $00C1           ;SC0BDL - SCI BAUD RATE CONTROL REGISTER
SC0CR1  EQU     $00C2           ;SC0CR1 - SCI CONTROL REGISTER
SC0CR2  EQU     $00C3           ;SC0CR2 - SCI CONTROL REGISTER
SC0SR1  EQU     $00C4           ;SC0SR1 - SCI STATUS REGISTER
SC0SR2  EQU     $00C5           ;SC0SR2 - SCI STATUS REGISTER
SC0DRH  EQU     $00C6           ;SC0DRH - SCI DATA REGISTER
SC0DRL  EQU     $00C7           ;SC0DRL - SCI DATA REGISTER
SC1BDH  EQU     $00C8           ;SC1BDH -
SC1BDL  EQU     $00C9           ;SC1BDL -
SC1CR1  EQU     $00CA           ;SC1CR1 -
SC1CR2  EQU     $00CB           ;SC1CR2 -
SC1SR1  EQU     $00CC           ;SC1SR1 -
SC1SR2  EQU     $00CD           ;SC1SR2 -
SC1DRH  EQU     $00CE           ;SC1DRH -
SC1DRL  EQU     $00CF           ;SC1DRL -

SP0CR1  EQU     $00D0           ;SP0CR1 - SPI CONTROL REGISTER
SP0CR2  EQU     $00D1           ;SP0CR2 - SPI CONTROL REGISTER
SP0BR   EQU     $00D2           ;SP0BR - SPI BAUD RATE REGISTER
SP0SR   EQU     $00D3           ;SP0SR - SPI STATUS REGISTER

SP0DR   EQU     $00D5           ;SP0DR - SPI DATA REGISTER
PORTS   EQU     $00D6           ;PORTS
DDRS    EQU     $00D7           ;PORTS - DATA DIRECTION REGISTER

IBAD    EQU     $00E0           ;IBAD -
IBFD    EQU     $00E1           ;IFBD -
IBCR    EQU     $00E2           ;IBCR -
IBSR    EQU     $00E3           ;IBSR -
IBDR    EQU     $00E4           ;IBDR -
IBPURD  EQU     $00E5           ;IBPURD -
PORTIB  EQU     $00E6           ;PORTIB -
DDRIB   EQU     $00E7           ;DDRIB -

EEMCR   EQU     $00F0           ;EEMCR - EEPROM MODULE CONFIGURATION
EEPROT  EQU     $00F1           ;EEPROT - EEPROM BLOCK PROTECT
EETST   EQU     $00F2           ;EETST - EEPROM TEST
EEPROG  EQU     $00F3           ;EEPROG - EEPROM CONTROL

FEELCK  EQU     $00F4           ;FEELCK - 
FEEMCR  EQU     $00F5           ;FEEMCR -
FEETST  EQU     $00F6           ;FEETST - 
FEECTL  EQU     $00F7           ;FEECTL - 

MTST0   EQU     $00F8           ;MTST0 - 
MTST1   EQU     $00F9           ;MTST1 - 
MTST2   EQU     $00FA           ;MTST2 -
MTST3   EQU     $00FB           ;MTST3 -
PORTK   EQU     $00FC           ;PORTK -
DDRK    EQU     $00FD           ;DDRK -

PPAGE   EQU     $00FF           ;PAGE -

C0MCR0  EQU     $0100           ;C0MCR0 -
C0MCR1  EQU     $0101           ;C0MCR1 -
C0BTR0  EQU     $0102           ;C0BTR0 -
C0BTR1  EQU     $0103           ;C0BTR1 -
C0RFLG  EQU     $0104           ;C0RFLG -
C0RIER  EQU     $0105           ;C0RIER -
C0TFLG  EQU     $0106           ;C0TFLG -
C0TCR   EQU     $0107           ;C0TCR -
C0IDAC  EQU     $0108           ;C0IDAC -

C0RXERR EQU     $010E           ;C0RXERR -
C0TXERR EQU     $010F           ;C0TXERR -
C0IDAR0 EQU     $0110           ;C0IDAR0 -
C0IDAR1 EQU     $0111           ;C0IDAR1 -
C0IDAR2 EQU     $0112           ;C0IDAR2 -
C0IDAR3 EQU     $0113           ;C0IDAR3 -
C0IDMR0 EQU     $0114           ;C0IDMR0 -
C0IDMR1 EQU     $0115           ;C0IDMR1 -
C0IDMR2 EQU     $0116           ;C0IDMR2 -
C0IDMR3 EQU     $0117           ;C0IDMR3 -
C0IDAR4 EQU     $0118           ;C0IDAR4 -
C0IDAR5 EQU     $0119           ;C0IDAR5 -
C0IDAR6 EQU     $011A           ;C0IDAR6 -
C0IDAR7 EQU     $011B           ;C0IDAR7 -
C0IDMR4 EQU     $011C           ;C0IDMR4 -
C0IDMR5 EQU     $011D           ;C0IDMR5 -
C0IDMR6 EQU     $011E           ;C0IDMR6 -
C0IDMR7 EQU     $011F           ;C0IDMR7 -

PCTLCAN0        EQU     $013D   ;PCTLCAN0 -
PORTCAN0        EQU     $013E   ;PORTCAN0 -
DDRCAN0         EQU     $013F   ;DDRCAN0 -

RXFG0   EQU     $0140   ;RXFG0 -
TX00    EQU     $0150   ;TX00 -
TX01    EQU     $0160   ;TX01 -
TX02    EQU     $0170   ;TX01 -

ATD1CTL0        EQU     $01E0   ;ATD1CTL0 -
ATD1CTL1        EQU     $01E1   ;ATD1CTL1 -
ATD1CTL2        EQU     $01E2   ;ATD1CTL2 -
ATD1CTL3        EQU     $01E3   ;ATD1CTL3 -
ATD1CTL4        EQU     $01E4   ;ATD1CTL4 -
ATD1CTL5        EQU     $01E5   ;ATD1CTL5 -
ATD1STAT0       EQU     $01E6   ;ATD1STAT0 -
ATD1STAT1       EQU     $01E7   ;ATD1STAT1 -
ATD1TESTH       EQU     $01E8   ;ATD1TESTH -
ATD1TESTL       EQU     $01E9   ;ATD1TESTL -

PORTAD1 EQU     $01EF   ;PORTAD1 -
ADR10H  EQU     $01F0   ;ADR10H -
ADR10L  EQU     $01F1   ;ADR10L -
ADR11H  EQU     $01F2   ;ADR11H -
ADR11L  EQU     $01F3   ;ADR11L -
ADR12H  EQU     $01F4   ;ADR12H -
ADR12L  EQU     $01F5   ;ADR12L -
ADR13H  EQU     $01F6   ;ADR13H -
ADR13L  EQU     $01F7   ;ADR13L -
ADR14H  EQU     $01F8   ;ADR14H -
ADR14L  EQU     $01F9   ;ADR14L -
ADR15H  EQU     $01FA   ;ADR15H -
ADR15L  EQU     $01FB   ;ADR15L -
ADR16H  EQU     $01FC   ;ADR16H -
ADR16L  EQU     $01FD   ;ADR16L -
ADR17H  EQU     $01FE   ;ADR17H -
ADR17L  EQU     $01FF   ;ADR17L -

C1MCR0  EQU     $0300   ;C1MCR0 -
C1MCR1  EQU     $0301   ;C1MCR1 -
C1BTR0  EQU     $0302   ;C1BTR0 -
C1BTR1  EQU     $0303   ;C1BTR1 -
C1RFLG  EQU     $0304   ;C1RFLG -
C1TFLG  EQU     $0305   ;C1TFLG -
C1TFCR  EQU     $0306   ;C1TCR -
C1IDAC  EQU     $0307   ;C1IDAC -

C1RXERR EQU     $030E   ;C1RXERR -
C1TXERR EQU     $030F   ;C1TXERR -

C1IDAR0 EQU     $0310   ;C1IDAR0 -
C1IDAR1 EQU     $0311   ;C1IDAR1 -
C1IDAR2 EQU     $0312   ;C1IDAR2 -
C1IDAR3 EQU     $0313   ;C1IDAR3 -
C1IDMR0 EQU     $0314   ;C1IDMR0 -
C1IDMR1 EQU     $0315   ;C1IDMR1 -
C1IDMR2 EQU     $0316   ;C1IDMR2 -
C1IDMR3 EQU     $0317   ;C1IDMR3 -
C1IDAR4 EQU     $0318   ;C1IDAR4 -
C1IDAR5 EQU     $0319   ;C1IDAR5 -
C1IDAR6 EQU     $031A   ;C1IDAR6 -
C1IDAR7 EQU     $031B   ;C1IDAR7 -
C1IDMR4 EQU     $031C   ;C1IDMR4 -
C1IDMR5 EQU     $031D   ;C1IDMR5 -
C1IDMR6 EQU     $031E   ;C1IDMR6 -
C1IDMR7 EQU     $031F   ;C1IDMR7 -

PCTLCAN1        EQU     $033D   ;PCTLCAN1 -
PORTCAN1        EQU     $033E   ;PORTCAN1 -
DDRCAN1         EQU     $033F   ;DDRCAN1 -

RXFG1           EQU     $0340   ;RXFG1 -
TX10            EQU     $0350   ;TX10 -
TX11            EQU     $0360   ;TX11 -
TX12            EQU     $0370   ;TX12 -






