;EEFLASH.ASM
;MC68HC912D128 PROGRAMMING ROUTINE
;REGD128.INC CONTAINS ALL REGISTERS
;
*******************************************************************************
*REVISION HISTORY:
*
*DATE				REV. NO.	DESCRIPTION
*
*March 8, 2000		V1.00		- Boot Flash
*
*Nov 30, 2000			V1.01		- Fix bugs
*
*Dec 8, 2000			V1.02		- Fix vector table (by CB)
*
*Apr 3, 2001			V1.03		- Crystal=8Mhz, PLL enabled with Fbus=16Mhz, BOOT=PORTA6 low
*
*Oct 16, 2001			V1.04		- Fix PLL setup
*
*November 24, 2001		V1.05		- External Ram support in Non-Page mode (page mode not supported)
*						- Command to Execute Internal/External Program
*						- Led will toggle if Pseudo Vector $DFFE:DFFF are $FFFF
*						- During Ram Load, LED will come ON if faulty write to RAM
*
*
*Author: Exequiel Rarama
********************************************************************************
;
; -----------------------
; Boot Flash - EEFLASH Routine
; -----------------------
;Bootloader
;
;Ram Variables
;RecType         ds      1
;DataBytes       ds      1
;LoadAddr        ds      2
;SRecData        ds      65
;
;ProgPulses      ds      1
;PMarginFlag     ds      1
;EMarginFlag     ds      1
;NumPulses       ds      1
;NotErasedFlag   ds      1
;SRecBytes       ds      1
;CheckSum        ds      1
;temp            ds      1
;
;Ramcode         equ     temp+1

;-------------------------------------------------------------------------------
BootLoad
	bset	DDRJ,LED
        movb    #6,PPAGE
        movb    #1,FEEMCR       ;Disable the erasure or programming of the bootblock
        movb    #1,FEELCK       ;Disable the erasure or programming of the bootblock
        dec     PPAGE

clear_boot
        clr     FEELCK          ;Enable the erasure or programming of the bootblock
        clr     FEEMCR          ;Enable the programming bootblock

        dec     PPAGE
        bne     clear_boot

;page 0 boot
        clr     FEELCK          ;Enable the erasure or programming of the bootblock
        clr     FEEMCR          ;Enable the programming bootblock

        movb    #$B0,TSCR       ;enable the timer sysem. set for fast flag clears
        movb    #1,TIOS         ;enable timer channel 0 as an output compare.
	bra	BLLoop

;------------------------------------------------------------------------------
Set_ExPanded_Mode
	leax	RAM_msg-4-*,pc	;Send Caution message
	jsr	OutStr-4-*,pc		;display it.

	leax	Page_Msg-4-*,pc	;Send Choose a Page  message
	jsr	OutStr-4-*,pc		;display it.

	jsr	getchar-4-*,pc

	bset 	DDRK,%10000111	;Set PORTK as output
	bset	PORTK,%10000111	;Set Port bits high

	movw	#$2CFB,PEAR		;16 bit Write to PEAR and MODE
	movb	#$3e,MISC		;Disable Flash
	stab	PPAGE			;Set PPAGE

	bclr	MODE,ESTR		;enable E clock
	bclr	PEAR,NECLK

	rts

;------------------------------------------------------------------------------
BLLoop
        leax    BLPrompt-4-*,pc ;point to the bootload prompt.
        jsr     OutStr-4-*,pc   ; display it.

        jsr     getchar-4-*,pc          ;get the command from the user
        jsr     putchar-4-*,pc          ; and echo it.
        pshb                            ;save char temporarily

        leax    CrlfStr-4-*,pc          ;go to next line
        jsr     OutStr-4-*,pc           ;display it.

        pulb                    ;restore the entered char
        andb    #$df            ;simple convert to upper case (only works for alpha char)

CheckFErase
	cmpb	#'H'            ;erase command entered?
	beq	ErasePage0      ;no, go check next command

	cmpb	#'I'            ;erase command entered?
	beq	ErasePage1      ;no, go check next command

	cmpb	#'J'            ;erase command entered?
	beq	ErasePage2      ;no, go check next command

	cmpb	#'K'            ;erase command entered?
	beq	ErasePage3      ;no, go check next command

	cmpb	#'G'            ;Execute Program?
	beq	Go_Run_Flash	;no, go check next command

	cmpb	#'X'            ;Execute Program?
	beq	Go_Run_RAM		;no, go check next command

	lbra	ChkProg		;Check if programming

Go_Run_Flash
	ldx	$DFFE
	jmp	0,x			;Execute Program

Go_Run_RAM
	bsr	Set_ExPanded_Mode
	ldx	$FFFE
	jmp	0,x			;Execute Program

;------------------------------------------------------------------------------
ErasePage0
        ldaa    #0
        staa    PPAGE           ;erase Page 0
        staa    temp1

        leax    EraseMsg0-4-*,pc
        jsr     OutStr-4-*,pc          ;display it.
        bra     EraseP

ErasePage1
        ldaa    #%0010
        staa    PPAGE           ;erase Page 1
        staa    temp1

        leax    EraseMsg1-4-*,pc
        jsr     OutStr-4-*,pc          ;display it.
        bra     EraseP

ErasePage2
        ldaa    #%0100
        staa    PPAGE           ;erase Page 2
        staa    temp1

        leax    EraseMsg2-4-*,pc
        jsr     OutStr-4-*,pc          ;display it.
        bra     EraseP

ErasePage3
        ldaa    #%0110
        staa    PPAGE           ;erase Page 3
        staa    temp1

        leax    EraseMsg3-4-*,pc
        jsr     OutStr-4-*,pc          ;display it.

EraseP
        clr     NotErasedFlag   ;init erase result
        bsr     CheckVfp        ;yes, check for Vfp present
        bne     BadErase        ; go print prompt, if not present
        jsr     FErase-4-*,pc          ;yes, go erase the Flash
        leax    ENot-4-*,pc           ;point to the 'not erase' message

        ldab    NotErasedFlag   ;get the erase result
        bne     BadE            ;branch if it did not erase properly
        leax    Erased-4-*,pc         ;if it did, point to the 'erased' message

BadE
        movb    #7,PPAGE

BadErase
        jsr     OutStr-4-*,pc          ;
        lbra    BLLoop          ;go back & print the prompt again

ChkProg
	cmpb	#'R'            ;program command entered?
	beq	Ram_Prog

	cmpb	#'P'            ;program command entered?
	lbne	BLLoop          ;no, go display command prompt

	bsr	CheckVfp        ;yes, check Vfp
	bne	BadErase        ;go print prompt if not present
	bsr	FProg           ;yes, go program the flash

EEProgStart
;       pshc                    ;save the returned succes/fail condition

        leax    CrlfStr-4-*,pc         ;go to next line
        jsr     OutStr-4-*,pc          ;display it.

;       pulc                    ;restore the returned succes/fail condition
;       beq

;       leax    PNot-4-*,pc           ;point to the 'not programmed' message
;       bne     BadErase        ;go display the string if the programming failed
        leax    Programmed-4-*,pc     ;otherwise, point to the 'programmed' message

BadProg
        bra     BadErase         ;go display the prompt again

;-------------------------------------------------------------------------------
CheckVfp
        clra                            ;assume that Vfp is present (set z==1)
        brset   FEECTL,SVFP,VFpOK       ;programming voltage present?
        leax    NoVfpError-4-*,pc             ;no, inform the usere
        jsr     OutStr-4-*,pc
        inca

VfpOK
        rts                             ;return Z==0 (not zero condition)

;-----------------------------------------------------------------------------
FProg
	leax	Send_msg-4-*,pc	;Send File message
	jsr	OutStr-4-*,pc		;display it.

        movb    #$00,TMSK2      ;set the prescaler to /1
        bra     FSkipFirst      ;do not send the 'pace' char the 1st time

FSendPace
        ldab    #'*'            ;the ascii asterisk is the pace char
        jsr     putchar-4-*,pc         ;tell the host it is ok to send the nex S-record

FSkipFirst
        jsr     GetSRecord-4-*,pc      ;go get the S-record
        bne     ProgDone        ;non-zero condition means there was an error

        ldab    RecType         ;check the record type
        cmpb    #S9RecType      ;was it an S9 Record?
        beq     ProgDone        ;yes, we are done

        cmpb    #S0RecType      ;no, was it an S0 Record?
        beq     FSendPace       ;yes, just ignore it

        bsr     ProgFBlock      ;no, that means it was an S1 record. go program the
                                ;data into flash
        beq     FsendPace       ;zero condition means all went ok

ProgDone
        ldab    #'*'            ;the ascii asterisk is the pace char
        jsr     putchar-4-*,pc         ;tell the host it is ok to send the nex S-record
        rts                     ;if we fall through, we automatically return a
                                ;non-zero condition. If we get here after detecting
                                ; an S9 record, we'll return a zero condition

;-----------------------------------------------------------------------------
Ram_Prog
	jsr	Set_ExPanded_Mode-4-*,pc

	leax	Send_msg-4-*,pc	;Send File message
	jsr	OutStr-4-*,pc		;display it.

	bra	RSkipFirst      ;do not send the 'pace' char the 1st time

RSendPace
	ldab	#'*'            ;the ascii asterisk is the pace char
	jsr	putchar-4-*,pc         ;tell the host it is ok to send the nex S-record

RSkipFirst
	jsr	GetSRecord-4-*,pc       ;go get the S-record
	bne	RProgDone        ;non-zero condition means there was an error

	ldab	RecType         ;check the record type
	cmpb	#S9RecType      ;was it an S9 Record?
	beq	RProgDone        ;yes, we are done

	cmpb	#S0RecType      ;no, was it an S0 Record?
	beq	RSendPace       ;yes, just ignore it

	bsr	ProgRBlock      ;no, that means it was an S1 record. go program the
                                ;data into flash
	bra	RsendPace       ;next byte block to write to RAM

RProgDone
	ldab	#'*'			;the ascii asterisk is the pace char
	jsr	putchar-4-*,pc	;tell the host it is ok to send the nex S-record

	leax	Send_Done_msg-4-*,pc	;Send File message
	jsr	OutStr-4-*,pc		;display it.

	lbra	BLLoop			;command prompt
					;if we fall through, we automatically return a
					;non-zero condition. If we get here after detecting
					; an S9 record, we'll return a zero condition
ProgRBlock
	ldx	LoadAddr        ;get the S-record (Flash) load address
	ldy	#SRecData       ;point to the received S-record data

RProgLoop
	movb	0,y,0,x         ;put the data into RAM

	ldab	0,x
	cmpb	0,y
	bne	RProgLoop

	ldab	1,x+            ;get the data from the Flash memory
	cmpb	1,y+            ;same as the S-record data?
	bne	RPDoneErr		;no, bad flash memory (or Vfp not applied)

	dec	DataBytes       ;done with all the S-record bytes?
	bne	RProgLoop        ;no, program the next location
	bra	RPDone

RPDoneErr
	bset	PORTJ,LED

RPDone
	rts

;-----------------------------------------------------------------------------
ProgFBlock
        ldx     LoadAddr        ;get the S-record (Flash) load address
        ldy     #SRecData       ;point to the received S-record data

ProgLoop
        clr     ProgPulses      ;initialize the ProgPulses var
        clr     PMarginFlag     ;initialize the PMarginFlag var
        bset    FEECTL,LAT      ;turn on the Flash address/data latches
        movb    0,y,0,x         ;put the data into the latches

PPulseLoop
        bclr    TSCR,TEN        ;stop the timer so we can produce accurate time
                                ;delays
        inc     ProgPulses      ;add 1 to the number of programming pulses we've applied
        ldab    ProgPulses      ;get the new value
        cmpb    #MaxProgPulses  ;have we applied the max allowable prog pulses?
        bls     PMarginLoop     ;no, go apply a programming pulse
        movb    #1,PMarginFlag  ;yes, now try applying 'MaxProgPulses' of margin

PMarginLoop
        ldd     #us22           ;get the constant for 22us delay
        addd    TCNT            ;add it to the current value of the timer counter reg
        std     TC0             ;initialize the output compare reg with the delay value
        bset    FEECTL,ENPE     ;turn on Vfp
        bset    TSCR,TEN        ;turn on the timer
        brclr   TFLG1,$01,*     ;wait here until Vfp has been applied for 22us
        bclr    FEECTL,ENPE     ;turn off Vfp

        ldd     #us11           ;get constant for 11us delay
        addd    TCNT
        std     TC0
        brclr   TFLG1,$01,*     ;wait here until Vfp has been removed for 11us
        tst     PMarginFlag     ;are we appling the programming margin pulses?
        beq     CmpData         ;no, go see if the data programmed properly
        dec     ProgPulses      ;yes, have we applied margin pulses equal to the number

        bne     PMarginLoop     ;no, go apply more margin pulses
        bra     PMarginDone     ;yes, go check the data again

CmpData
        ldab    0,x             ;get the data from the Flash memory
        cmpb    0,y             ;same as the S-record data?
        bne     PPulseLoop      ;no, go apply some more programming pulses
        movb    #1,PMarginFlag  ;yes, set the programming margin flag
        bra     PMarginLoop     ;go apply the margin programming pulses

PMarginDone
        bclr    FEECTL,LAT      ;turn off the flash address/data latches to prepare for
                                ;programming the next location
        ldab    1,x+            ;get the data from the Flash memory
        cmpb    1,y+            ;same as the S-record data?
        bne     PDone           ;no, bad flash memory (or Vfp not applied)
        dec     DataBytes       ;done with all the S-record bytes?
        bne     ProgLoop        ;no, program the next location

PDone
;        jmp     BLLoop
	rts

;-----------------------------------------------------------------------------
FErase
        movb    #$5,TMSK2        ;set the prescaler to /32
        clr     EMarginFlag     ;clear the margin pulses flag
        clr     NumPulses       ;clear the erase pulse count

        bset    FEECTL,LAT+ERAS ;turn on the address/data latches & erase bit
        std     FlashStart      ;write to any Flash address (data do not matter)

EraseLoop
        ldab    NumPulses       ;get the 'pulse' count
        cmpb    #MaxErasePulses ;applied the maximum number of erase pulses?
        beq     DoEMargin       ;yes, go apply the erase margin pulse
        inc     NumPulses       ;add 1 to the number of 100ms 'pulses' to apply

PulseLoop
        bset    FEECTL,ENPE     ;turn on Vfp

        ldd     #ms100          ;timer constant to produce 100ms delay
        addd    TCNT
        std     TC0

        brclr   TFLG1,$01,*
        bclr    FEECTL,ENPE     ;turn off Vfp

        ldd     #ms1
        addd    TCNT
        std     TC0
        brclr   TFLG1,$01,*

        tst     EMarginFlag     ;are we applying margin erase pulses?
        beq     CheckErase      ;no, go check to see if the last pulse erase the array
        dec     NumPulses       ;yes, have we applied enough margin pulses?
        bne     PulseLoop       ;no, go apply some more

CheckErase
        clr     NotErasedFlag   ;clear the erased flag
        ldx     #FlashStart     ;point to the start of the flash block
        ldy     #ByteWord       ;get a count of the number of words
                                ;we are going to check
        ldd     #$FFFF          ;the value of an erased word

EraseChkLoop
        cpd     2,x+            ;this word erase?
        bne     NotErased       ;no, go set flag & apply another erase pulse
        dbne    y,EraseChkLoop  ;yes, decrement word count & go check the next word

DoEMargin
        tst     EMarginFlag     ;have we already applied the margin pulse?
        bne     EraseDone       ;yes, we are done. the result of the erase funtion is
                                ;in the NotEraseFlag
        inc     EMarginFlag     ;no, set the 'margin pulse applied' flag
        bra     PulseLoop       ;go apply the margin erase pulse

NotErased
        inc     NotErasedFlag   ;array was not erased. flag the condition
        tst     EMarginFlag     ;have we already applied the margin pulse?
        bne     EraseDone       ;yes, we are done. the Flash is bad
        bra     EraseLoop       ;have not yet applied the margin pulse. go apply another erase pulse

EraseDone
        clr     FEECTL          ;make sure that the LAT & ERAS bit is clear
;       ldab    NotErasedFlag   ;get the erase result

        inc     temp1
        movb    temp1,PPAGE

        ldx     #FlashStart     ;point to the start of the flash block
        ldy     #ByteWord       ;get a count of the number of words
                                ;we are going to check
        ldd     #$FFFF          ;the value of an erased word

EraseChkLoop1
        cpd     2,x+            ;this word erase?
        bne     NotErased       ;no, go set flag & apply another erase pulse
        dbne    y,EraseChkLoop1  ;yes, decrement word count & go check the next word
        bra     EraseDone1

NotErased1
        inc     NotErasedFlag   ;array was not erased. flag the condition

EraseDone1
        ldab    NotErasedFlag   ;get the erase result
        rts

;-----------------------------------------------------------------------------
GetSRecord
        bsr     getchar         ;get a char
        cmpb    #'S'            ;start of record char?
        bne     GetSRecord

        bsr     getchar		;Use to pause program before setting to expandede mode

        cmpb    #S0RecType      ;found an S0 record?
        beq     SaveRecType     ;no, go check for S9 record

CheckForS9
        cmpb    #S9RecType      ;found and S9 record?
        beq     SaveRecType     ;no, go check for S1 record

CheckForS1
        cmpb    #S1RecType      ;found an S1 record?
        bne     GetSRecord      ;no, false start

SaveRecType
        stab    RecType         ;yes, set the record type to '1'

        bsr     GetHexByte      ;get the S-record length byte
        bne     BadSRec         ;return if there was an error

        stab    SRecBytes       ;save the total number of s-record bytes we are to receive
        stab    CheckSum        ;initialize the checksum calculation with data byte count
        subb    #3              ;subtract the load address & checksum field from the
                                ;data field count
        stab    DataBytes       ;save the code/data field size
        ldx     #LoadAddr       ;point to the load address/code/data/checksume buffer

RcvData
        bsr     GetHexByte      ;get an S-record data byte
        bne     BadSRec         ;return if there was an error

        ldab    temp
        stab    1,x+            ;save the byte in the data buffer
        addb    CheckSum        ;add the byte into the checksum
        stab    CheckSum        ;save the result

        dec     SRecBytes       ;received all S-record bytes?
        bne     RcvData         ;no, go get some more

        inc     CheckSum        ;if checksum was ok, the result will be zero

BadSRec
        rts

;-----------------------------------------------------------------------------
GetHexByte
        bsr     getchar         ;get the upper nibble from the SCI

        bsr     IsHex           ;valid hex Char?
        beq     OK1             ;yes, go convert to bin
        rts                     ;no, return with a non zero ccr indication

OK1
        bsr     CvtHex          ;convert the ascii hex to bin
        aslb
        aslb
        aslb
        aslb
        andb    #$f0
        stab    temp

        bsr     getchar         ;get lower nibble from the SCI
        bsr     IsHex           ;valid hex char?
        beq     OK2             ;yes, go convert to bin
        rts                     ;no, return with a non zero ccr indication

OK2
        bsr     CvtHex          ;convert to bin
        addb    temp            ;add it to upper nibble
        stab    temp

        clra                    ;simple way to set the z ccr bit
        rts

CvtHex
        subb    #'0'            ;subtract ascii '0' from hex char
        cmpb    #$9             ;was it a decimal digit?
        bls     CvtHexRtn       ;yes, ok as is
        subb    #$7             ;no, it was an ascii hex letter ('A'-'F')

CvtHexRtn
        rts

IsHex
        cmpb    #'0'            ;less than ascii hex zero?
        blo     NotHex          ;yes, char is not hex, return a non zero ccr indication
        cmpb    #'9'            ;less than or equal to ascii 9?
        bls     IsHex1          ;yes, char is hex, return a zero ccr indication
        cmpb    #'A'            ;less than an ascii hex 'A'?
        blo     NotHex          ;yes, char is not hex
        cmpb    #'F'            ;less than or equal to ascii hex 'F'?
        bhi     NotHex          ;yes, char is hex

IsHex1
        orcc    #%0100          ;no, return a zero ccr conditon

NotHex
        rts

;-----------------------------------------------------------------------------
getchar
	brclr	SC0SR1,RDRFflag,*         ;loop waiting for the RDRF bit to be set
	ldab	SC0SR1          ;read register to clear flag RDRF
	ldab	SC0DRL          ;read receive buffer
	rts

OutStr
	ldab	1,x+            ;get a char, advance pointer, null?
	beq	OutStrDone      ;yes, return
	bsr	putchar         ;no, sent it out
	bra	OutStr          ;go send next char

OutStrDone
	rts

putchar
	brclr	SC0SR1,TDREflag,*  ;loop waitin for the TDRE bit to be set
	stab	SC0DRL             ;send char
	rts

;-----------------------------------------------------------------------------
CrlfStr	dc.b	$0a,$0d,$0

BLPrompt	dc.b	$0a,$0d,"Technological Arts D128 Flash Util. V1.06"
		dc.b	$0a,$0d,"H -> Erase Block 0"
		dc.b	$0a,$0d,"I -> Erase Block 1"
		dc.b	$0a,$0d,"J -> Erase Block 2"
		dc.b	$0a,$0d,"K -> Erase Block 3"
		dc.b	$0a,$0d,"P -> Program Flash"
		dc.b	$0a,$0d,"G -> Execute Program in Flash (Pseudo Vector)"
		dc.b	$0a,$0d,"R -> Program External Ram"
		dc.b	$0a,$0d,"X -> Execute Program in External RAM"
		dc.b	$0a,$0d,"?",0

Send_msg	dc.b	$0a,$0d,"Send File Now",$0a,$0d,0
Send_Done_msg	dc.b	$0a,$0d,"Done",$0a,$0d,0

RAM_msg	dc.b	$0a,$0d,"Internal Flash Disabled"
		dc.b	$0a,$0d,"CAUTION! Address, Data BUS enabled"
		dc.b	$0a,$0d,"Slide Program Switch to Run"
		dc.b	$0a,$0d,"Press any key when Ready",0

ENot		dc.b	"Not "
Erased		dc.b	"Erased",0

Pnot		dc.b	"Not "
Programmed	dc.b	"Programmed",0

NoVfpError	dc.b	$0a,$0d,"Vfp Not Present",0

EraseMsg0	dc.b	$0a,$0d,"Erasing Blocks 0",$0a,$0d,0
EraseMsg1	dc.b	$0a,$0d,"Erasing Blocks 1",$0a,$0d,0
EraseMsg2	dc.b	$0a,$0d,"Erasing Blocks 2",$0a,$0d,0
EraseMsg3	dc.b	$0a,$0d,"Erasing Blocks 3",$0a,$0d,0

Page_Msg	dc.b	$0a,$0d,"Choose a Page - (0), (1), (2), (3), (4), (5), (6), (7)",$0a,$0d,0


code_len	equ	($-BootLoad)
