;AUDIO.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*Nov 30, 2000		1.00		Initial release
*Dec 24, 2000		1.01		Fix Bugs 
*April 21, 2001		1.02		Fix audio
*Oct 17, 2001		1.03		Fix PLL problem
*
*Revised by Exequiel Rarama for the ADAPT 912d128
*******************************************************************************
;
;Port J, bit 7 is use to drive the speaker.
;The port pin will toggle on compare.
;
; ---------------------------
; Demo - Audio Routine
; ---------------------------

TONE_2K         equ     500     ;frequencies in Hertz for tone generation
TONE_1K         equ     1000
TONE_440        equ     2272
TONE_220        equ     4545
TONE_180        equ     3000
TONE_110        equ     9090
TONE_60         equ     16666

OC6mask1        equ     %01000000       ;IOS6 = 1, Bit 6 as output compare
OC6mask2        equ     %01000000       ;C6I = 1, Enable Interrupt
OC6mask3        equ     %00010000       ;OM6 = 0, OL6 = 1, toggel OC output line
OC6flag         equ     %01000000       ;C6F = 1 to clear Interrupt flag

Audio           equ     %10000000       ;Port J bit 7

;Audio variables are define in "MAIN.ASM"
;DURATION        rmb     2       ;used for tone generation
;HALF_PERIOD     rmb     2


;Initialize PORTT bit 6 as output compare
audio_init
        bset    TSCR,%10000000        ;TEN=1 - Enable timer
        bset    TIOS,%01000000        ;Bit 7 of PORTJ use as Audio timer
        rts
 
PulseXToneB

* b contains number of beeps desired
* x contains tone frequency
* y contains tone duration (eg. if y=1  => duration=4.1 ms; y=255 => 1 sec)

        sty     DURATION
rpt
        jsr     EnableToneX     ;tone generated via OutputCompare feature
        movw    DURATION,TIMER
d2_1
        ldy     TIMER
        bne     d2_1

        bclr    PORTJ,Audio     ;Disable audio
        bclr    TMSK1,%01000000 ;turn off tone
        bclr    TCTL1,%01000000

        movw    DURATION,TIMER
d2_2
        ldy     TIMER
        bne     d2_2
        dbne    b,rpt
        rts

EnableToneX:
        sei                     ;tone generation done via OutputCompare
        stx     HALF_PERIOD

        bset    PORTJ,Audio     ;Enable
        bset    TMSK1,%01000000 ;enable OC6 interrupt
        bset    TFLG1,%01000000 ;clear flag
        cli
        rts


;=============================================================================
*  Output Compare Interrupt Handler
;------------------------
; Audio Interrupt Routine
; -----------------------
OC6Int
audio_int
        ldd     HALF_PERIOD
        addd    TC6
        std     TC6

        brclr   PORTJ,Audio,audio10
        bclr    PORTJ,Audio
        bra     audio20

audio10
        bset    PORTJ,Audio             ;Enable audio

audio20
        bset    TFLG1,%01000000         ;clear flag
        rti

