;MC68HC912B32 REGISTER MAP
;MEMORY BLOCK BEGINS AT 0000H AND ENDS AT  00FFH

REG     EQU     $0000

PORTA   EQU     $0000           ;PORTA
PORTB   EQU     $0001           ;PORTB
DDRA    EQU     $0002           ;PORTA - DATA DIRECTION REGISTER
DDRB    EQU     $0003           ;PORTB - DATA DIRECTION REGISTER

PORTE   EQU     $0008           ;PORTE
DDRE    EQU     $0009           ;PORTE - DATA DIRECTION REGISTER
PEAR    EQU     $000A           ;PEAR - PORTE ASSIGNMENT REGISTER
MODE    EQU     $000B           ;MODE - MODE REGISTER
PUCR    EQU     $000C           ;PUCR - PULL UP CONTROL REGISTER
RDRIV   EQU     $000D           ;RDRIV - REDUCED DRIVE OF I/O LINES

INITRM  EQU     $0010           ;INITRM - INITIALIZATION OF INTERNAL RAM POSITION REGISTER
INITRG  EQU     $0011           ;INITRG - INITIALIZATION OF INTERNAL REGISTER POSITION REGISTER
INITEE  EQU     $0012           ;INITEE - INITIALIZATION OF INTERNAL EEPROM POSITION REGISTER
MISC    EQU     $0013           ;MISC - MISCELLANEOUS MAPPING CONTROL REGISTER
RTICTL  EQU     $0014           ;RTICTL - REAL TIME INTERRUPT CONTROL REGISTER
RTIFLG  EQU     $0015           ;RTIFLG - REAL TIME INTERRUPT FLAG REGISTER
COPCTL  EQU     $0016           ;COPCTL - COP CONTROL REGISTER
COPRST  EQU     $0017           ;COPRST - ARM/RESET COP TIMER REGISTER

ITST0   EQU     $0018           ;ITST0
ITST1   EQU     $0019           ;ITST1
ITST2   EQU     $001A           ;ITST2
ITST3   EQU     $001B           ;ITST3

INTCR   EQU     $001E           ;INTCR - INTERRUPT CONTROL REGISTER
HPRIO   EQU     $001F           ;HPRIO - HIGHEST PRIORITY I INTERRRUPT

BRKCT0  EQU     $0020           ;BRKCT0
BRKCT1  EQU     $0021           ;BRKCT1
BRKAH   EQU     $0022           ;BRKAH
BRKAL   EQU     $0023           ;BRKAL
BRKDH   EQU     $0024           ;BRKDH
BRKDL   EQU     $0025           ;BRKDL
 
PWCLK   EQU     $0040           ;PWCLK -
PWPOL   EQU     $0041           ;PWPOL - 
PWEN    EQU     $0042           ;PWEN - 
PWPRES  EQU     $0043           ;PWPRES - 
PWSCAL0 EQU     $0044           ;PWSCAL0
PWSCNT0 EQU     $0045           ;PWSCNT0
PWSCAL1 EQU     $0046           ;PWSCAL1
PWSCNT1 EQU     $0047           ;PWSCNT1
PWCNT0  EQU     $0048           ;PWCNT0
PWCNT1  EQU     $0049           ;PWCNT1
PWCNT2  EQU     $004A           ;PWCNT2
PWCNT3  EQU     $004B           ;PWCNT3
PWPER0  EQU     $004C           ;PWPER0
PWPER1  EQU     $004D           ;PWPER1
PWPER2  EQU     $004E           ;PWPER2
PWPER3  EQU     $004F           ;PWPER3
PWDTY0  EQU     $0050           ;PWDTY0
PWDTY1  EQU     $0051           ;PWDTY1
PWDTY2  EQU     $0052           ;PWDTY2
PWDTY3  EQU     $0053           ;PWDTY3
PWCTL   EQU     $0054           ;PWCTL
PWTST   EQU     $0055           ;PWTST

PORTP   EQU     $0056           ;PORTP - PORTP REGISTER
DDRP    EQU     $0057           ;DDRP - DATA DIRECTION REGISTER


ATDCTL0 EQU     $0060           ;ATDCTL0 - RESERVED
ATDCTL1 EQU     $0061           ;ATDCTL1 - RESERVED
ATDCTL2 EQU     $0062           ;ATDCTL2 - ATD CONTROL REGISTER
ATDCTL3 EQU     $0063           ;ATDCTL3 - ATD CONTROL REGISTER
ATDCTL4 EQU     $0064           ;ATDCTL4 - ATD CONTROL REGISTER
ATDCTL5 EQU     $0065           ;ATDCTL5 - ATD CONTROL REGISTER

ATDSTAT         EQU     $0066
ATDSTATH        EQU     $0066   ;ATDSTAT - ATD STATUS HIGH REGISTER
ATDSTATL        EQU     $0067   ;ATDSTAT - LOW REGISTER

STDTEST         EQU     $0068
ATDTESTH        EQU     $0068   ;ATDTEST - ATD TEST HIGH REGISTER
ATDTESTL        EQU     $0069   ;ATDTEST - LOW REGISTER

PORTAD  EQU     $006F           ;PORTAD - PORT AD DATA INPUT REGISTER
ADR0H   EQU     $0070           ;ADR0H
ADR1H   EQU     $0072           ;ADR1H
ADR2H   EQU     $0074           ;ADR2H
ADR3H   EQU     $0076           ;ADR3H
ADR4H   EQU     $0078           ;ADR4H
ADR5H   EQU     $007A           ;ADR5H
ADR6H   EQU     $007C           ;ADR6H
ADR7H   EQU     $007E           ;ADR7H

TIOS    EQU     $0080           ;TIOS - TIMER INPUT CAPTURE/OUTPUT COMPARE SELECT
CFORC   EQU     $0081           ;CFORC - TIMER COMPARE FORCE REGISTER
OC7M    EQU     $0082           ;OC7M - OUTPUT COMPARE 7 MASK REGISTER
OC7D    EQU     $0083           ;OC7D - OUTPUT COMPARE 7 DATA REGISTER

TCNT    EQU     $0084
TCNTH   EQU     $0084           ;TCNT - TIMER COUNT HIGH REGISTER
TCNTL   EQU     $0085           ;TCNT - HIGH REGISTER

TSCR    EQU     $0086           ;TSCR - TIMER SYSTEM CONTROL REGISTER
TQCR    EQU     $0087           ;TQCR - RESERVED
TCTL1   EQU     $0088           ;TCTL1 - TIMER CONTROL REGISTER 1
TCTL2   EQU     $0089           ;TCTL2 - TIMER CONTROL REGISTER 2
TCTL3   EQU     $008A           ;TCTL3 - TIMER CONTROL REGISTER 3
TCTL4   EQU     $008B           ;TCTL4 - TIMER CONTROL REGISTER 4

TMSK1   EQU     $008C           ;TMSK1 - TIMER INTERRUPT MASK 1
TMSK2   EQU     $008D           ;TMSK2 - TIMER INTERRUPT MASK 2

TFLG1   EQU     $008E           ;TFLG1 - TIMER INTERRUPT FLAG 1
TFLG2   EQU     $008F           ;TFLG2 - TIMER INTERRUPT FLAG2

TC0     EQU     $0090
TC0H    EQU     $0090           ;TC0 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC0L    EQU     $0091           ;TC0 - LOW REGISTER

TC1     EQU     $0092
TC1H    EQU     $0092           ;TC1 - HIGH REGISTER
TC1L    EQU     $0093           ;TC1 - LOW REGISTER

TC2     EQU     $0094
TC2H    EQU     $0094           ;TC2 - HIGH REGISTER
TC2L    EQU     $0095           ;TC2 - LOW REGISTER

TC3     EQU     $0096
TC3H    EQU     $0096           ;TC3 - HIGH REGISTER
TC3L    EQU     $0097           ;TC3 - LOW REGISTER

TC4     EQU     $0098 
TC4H    EQU     $0098           ;TC4 - HIGH REGISTER
TC4L    EQU     $0099           ;TC4 - LOW REGISTER

TC5     EQU     $009A
TC5H    EQU     $009A           ;TC5 - HIGH REGISTER
TC5L    EQU     $009B           ;TC5 - LOW REGISTER

TC6     EQU     $009C
TC6H    EQU     $009C           ;TC6 - HIGH REGISTER
TC6L    EQU     $009D           ;TC6 - LOW REGISTER

TC7     EQU     $009E
TC7H    EQU     $009E           ;TC7 - HIGH REGISTER
TC7L    EQU     $009F           ;TC7 - LOW REGISTER

PACTL   EQU     $00A0           ;PATCL - PULSE ACCUMULATOR CONTROL REGISTER
PAFLG   EQU     $00A1           ;PAFLG - PULSE ACCUMULATOR FLAG REGISTER

PACNT   EQU     $00A2
PACNTH  EQU     $00A2           ;PACNT - 16 BIT PULSE ACCUMULATOR COUNT HIGH REGISTER
PACNTL  EQU     $00A3           ;PACNT - LOW REGISTER

TIMTST  EQU     $00AD           ;TIMTST - TIMER TEST REGISTER
PORTT   EQU     $00AE           ;PORTT
DDRT    EQU     $00AF           ;PORTT - DATA DIRECTION REGISTER

SC0BDH  EQU     $00C0           ;SC0BDH - SCI BAUD RATE CONTROL REGISTER
SC0BDL  EQU     $00C1           ;SC0BDL - SCI BAUD RATE CONTROL REGISTER
SC0CR1  EQU     $00C2           ;SC0CR1 - SCI CONTROL REGISTER
SC0CR2  EQU     $00C3           ;SC0CR2 - SCI CONTROL REGISTER
SC0SR1  EQU     $00C4           ;SC0SR1 - SCI STATUS REGISTER
SC0SR2  EQU     $00C5           ;SC0SR2 - SCI STATUS REGISTER
SC0DRH  EQU     $00C6           ;SC0DRH - SCI DATA REGISTER
SC0DRL  EQU     $00C7           ;SC0DRL - SCI DATA REGISTER

SP0CR1  EQU     $00D0           ;SP0CR1 - SPI CONTROL REGISTER
SP0CR2  EQU     $00D1           ;SP0CR2 - SPI CONTROL REGISTER
SP0BR   EQU     $00D2           ;SP0BR - SPI BAUD RATE REGISTER
SP0SR   EQU     $00D3           ;SP0SR - SPI STATUS REGISTER

SP0DR   EQU     $00D5           ;SP0DR - SPI DATA REGISTER
PORTS   EQU     $00D6           ;PORTS
DDRS    EQU     $00D7           ;PORTS - DATA DIRECTION REGISTER

PURDS   EQU     $00DB           ;PURDS - 

EEMCR   EQU     $00F0           ;EEMCR - EEPROM MODULE CONFIGURATION
EEPROT  EQU     $00F1           ;EEPROT - EEPROM BLOCK PROTECT
EETST   EQU     $00F2           ;EETST - EEPROM TEST
EEPROG  EQU     $00F3           ;EEPROG - EEPROM CONTROL

FEELCK  EQU     $00F4           ;FEELCK - 
FEEMCR  EQU     $00F5           ;FEEMCR -
FEETST  EQU     $00F6           ;FEETST - 
FEECTL  EQU     $00F7           ;FEECTL - 

BCR1    EQU     $00F8           ;BCR1 - 
BSVR    EQU     $00F9           ;BSVR - 
BCR2    EQU     $00FA           ;BCR2 -
BDR     EQU     $00FB           ;BDR - 
BARD    EQU     $00FC           ;BARD - 

DLCSCR  EQU     $00FD           ;DLCSCR - 
PORTDLC EQU     $00FE           ;PORTDLC 
DDRDLC  EQU     $00FF           ;DDRDLC - DATA DIRECTION REGISTER FOR PORT DLC



