;main.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE				REV. NO.	DESCRIPTION
*
*November 22, 2001		V1.00		LCD/Keyboard Demo
*
*Written by Exequiel Rarama for the Adapt912D60 Running at 8Mhz Oscillator
********************************************************************************
;Compiled with MiniIDE
;
; ---------------------------
; Demo - Main Routine
; ---------------------------

#include REGD60.INC

*  Operational Parameters

RAM     equ     $200                   ;internal RAM
STACK   equ     $800                   ;Stack at top of internal ram

* Operational Constants

TRUE            equ     $FF
FALSE           equ     $00
LF              equ     $A
SPACE           equ     $20

* Masks

;ATD Variables
admask2         equ     %11000000       ;AFFC,ADPU=1 - Enable Analog to Digital
admask3         equ     %00000000       ;FRZ1,FRZ0=0
admask4         equ     %00000001       ;SMP1,SMP0 = 0, PRS0=1 - Select Sample time
admask5         equ     %01110000       ;S8CM = 1, SCAN = 1, MULT = 1
SCFflag         equ     %10000000       ;SCF - Sequence Complete flag

;RTI Variables
clrmask         equ     %11000000       ;mask for clearing timer flags
rtimask1        equ     %10000001       ;M=8Mhz, 1.024 msec interrupt with 16 MHz xtal
rtimask2        equ     %10000010       ;M=8Mhz, 2.048 msec interrupt with 16 MHz xtal
rtimask3        equ     %10000011       ;M=8Mhz, 4.096 msec interrupt with 16 MHz xtal
rtimask4        equ     %10000100       ;M=8Mhz, 8.196 msec interrupt with 16 MHz xtal
rtimask5        equ     %10000101       ;M=8Mhz, 16.384 msec interrupt with 16 MHz xtal
rtimask6        equ     %10000110       ;M=8Mhz, 32.768 msec interrupt with 16 MHz xtal
rtimask7        equ     %10000111       ;M=8Mhz, 65.536 msec interrupt with 16 MHz xtal
rtiflag         equ     %10000000

;SCI Variables
scimask         equ     %00101100       ;RIE - SCI Interrupt enable
                                        ;RE - Receiver Enable
RDRFflag        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
;MCLK=8Mzh
BAUD110         equ     4545            ;(baud) 110 baud with 16 Mhz crystal
BAUD300         equ     1667            ;(baud) 300 baud with 16 Mhz crystal
BAUD600         equ     833             ;(baud) 600 baud with 16 Mhz crystal
BAUD1200        equ     417             ;(baud) 1200 baud with 16 Mhz crystal
BAUD2400        equ     208             ;(baud) 2400 baud with 16 Mhz crystal
BAUD4800        equ     104             ;(baud) 4800 baud with 16 Mhz crystal
BAUD9600        equ     52              ;(baud) 9600 baud with 16 Mhz crystal
BAUD14400       equ     35              ;(baud) 14400 baud with 16 Mhz crystal
BAUD19200       equ     26              ;(baud) 19200 baud with 16 Mhz crystal
BAUD38400       equ     13              ;(baud) 19200 baud with 16 Mhz crystal

        org     RAM

* System Variables
COMMAND         ds.b     1               ;used by ProcessCommand

H               ds.b     1               ;used in binary to decimal conversion
TO              ds.b     1

DURATION        ds.b     2               ;used for tone generation
HALF_PERIOD     ds.b     2

TIMER           ds.b     2               ;software timers using RTI
TIMER1          ds.b     2
COUNTER         ds.b     1
dummy           ds.b     1

;-------------------
* Boolean Variables

COMMAND_PENDING ds.b     1               ;used by ProcessCommand
CONTINUOUS      ds.b     1               ;flag for real-time a/d screen update

;Keyboard
keybd_char      ds.b      1
keybd_value     ds.b      6
keybd_count     ds.b      1
keybd_flag      ds.b      1
keybd_timer     ds.b      1
release_flag    ds.b      1
keybd_state     ds.b      1
key_ptr         ds.b      2
keyp_timer      ds.b      2
keyp_flag       ds.b      1
clr_flag        ds.b      1

;timers
state_timer     ds.b     2
wait_timer      ds.b     2

; Memory Allocation for LC Display routine
disp_ptr        ds.b     2               ;pointer to display buffer
disp_flag       ds.b     1               ;1 = update; 0 = home; -1 = done
drow_var        ds.b     1
temp            ds.b     1
lcd_state       ds.b     2
temp_h          ds.b     1
TEMP1           ds.b     1
TEMP2           ds.b     1
lcd_timer       ds.b     2
dcol_var        ds.b     1
dig_lenght      ds.b     1
l_flag          ds.b     1
spi_int_flag    ds.b     1
u_delay_var     ds.b     2
disp_buffer     ds.b     80              ;display buffer (4 lines of 20 chars)

***************************** Program *******************************

        org     $C000

RESET1                                  ;This is where the RESET vector points to
;Initialize COP
        movb    #%10000111,COPCTL       ;COP is enabled and is armed to
                                        ; reset in 1 second.
;Initialize Stack
        lds     #STACK                  ;initialize stack pointer

;Initialize Real Time Interrupt
        movb    #rtimask4,RTICTL        ;Enable RTI and initialize RTI rate
        movb    #rtiflag,RTIFLG

;Initialize Serial Communication Interface
        movb    #scimask,SC0CR2         ;enable SCI 0 rcvr. & xmtr. & rx int
        movb    #0,SC0CR1    
        movb    #BAUD14400,SC0BDL       ;Set baud rate to 9600    
        ldaa    SC0SR1                  ;read register to clear flag RDRF
        ldaa    SC0DRL                  ;dummy read to flush receive buffer

;Initialize PORTT
        movb    #%01100000,DDRT         ;Bit 6,5 of PORTT are Output
        bclr    PORTT,%01100000

        jsr     keybd_init              ;Initialize keyboard

        cli                             ;unmask interrupts
	jsr	disp_delay			;Set 32ms Delay before initializing display

;-----------------------------------------------------------------------------
;Main loops
;
Main
        movb    #$55,COPRST             ;Reset COP
        movb    #$AA,COPRST

        ldy     lcd_state               ;execute current state
        jsr     0,y
        jsr     disp_update

        jsr     key_char_disp           ;check for keypress

        bra     Main

;-----------------------------------------------------------------------------
;Interrupt test traps
RESET

;Bit 5 of PORTT is toggled
        jsr     delay
        jsr     delay
        bclr    PORTT,%00100000
        jsr     delay
        jsr     delay
        bset    PORTT,%00100000

        bra     RESET

;-----------------------------------------------------------------------------
delay
        pshy
        ldy     #0
        bra     dly

small_delay
        pshy
        ldy     #333

dly
        dbne    y,dly
        puly
        rts


HexByte2Dec

*               Supply hex value to be converted in B register
        clra
        ldx     #100    ;numerator in D, denominator in X
        idiv
*               remainder in D, quotient in X
*               B is lo-order byte
        xgdx
        stab    H       ;8 bit quotient in B
        xgdx
        ldx     #10     ;H=0X  TO=packed BCD
        idiv
        stab    TO
        xgdx
        aslb
        aslb
        aslb
        aslb
        orab    TO
        stab    TO
        rts

SendDecByte

* value is in B

        clra
        jsr     HexByte2Dec
        ldaa    H
        adda    #'0'
        jsr     SendByte
        ldaa    TO
        jsr     SendASCIIHex
        rts

SendASCIIHex
*       value in A

        psha
        anda    #$F0
        lsra
        lsra
        lsra
        lsra
        cmpa    #$A
        blt     SAH1
        suba    #$A
        adda    #'A'
        bra     SAH2
SAH1
        adda    #'0'
SAH2
        jsr     SendByte
        pula
        psha
        anda    #$0F
        cmpa    #$A
        blt     SAH3
        suba    #$A
        adda    #'A'
        bra     SAH4
SAH3
        adda    #'0'
SAH4
        jsr     SendByte
        pula
        rts


SendByte:

*  Transmits a byte, contained in register A, to the serial device via the SCI.

SB1
        ldab    SC0SR1                  ;wait for transmit data register empty (TDRE)
        bpl     SB1
        staa    SC0DRL                  ;send byte
        rts

PutNewLine
        ldaa    #CR
        jsr     SendByte
        ldaa    #LF
        jsr     SendByte
        rts

PutDblLine
        ldaa    #CR
        jsr     SendByte
        ldaa    #LF
        jsr     SendByte
        ldaa    #LF
        jsr     SendByte
        rts

SendString

*       x contains starting address of string
RV1
        ldaa    0,X                     ;$FF denotes end of string
        cmpa    #$FF
        beq     RVX
        jsr     SendByte
        inx
        bra     RV1
RVX
        rts

GetChar:

*  Fetches one character from SCI0, 
*  and returns it in register A.  

GC1:
        ldaa    SC0SR1                  ;get sci flags
        anda    #RDRFflag               ;mask off irrelevant bits
        beq     GC1                     ;loop until character found
        ldaa    SC0DRL                  ;get character
	rts

;
;-----------------------------------------------------------------------------
;These sub-routines are external to this main routine and are link during the
; assembling stage.

#include LCD.ASM                        ;Liquid Crystal Display routine
#include KEYBRD.ASM                     ;Keyboard routine                 
#include INT.ASM                        ;Interrupts routine

;MC68HC812A4 VECTOR INTERRUPTS

	org	$DFCE

	dc.w	RESET			;KEY WAKEUP H
	dc.w	RESET			;KEY WAKEUP J
	dc.w	RESET			;ANALOG TO DIGITAL
	dc.w	RESET			;SERIAL COMMUNICATION 1
	dc.w	SerInputInt		;SERIAL COMMUNICATION 0
	dc.w	spi_int		;SPI SERIAL TRANSFER COMPLETE
	dc.w	RESET			;PULSE ACCUMULATOR INPUT EDGE
	dc.w	RESET			;PULSE ACCUMULATOR OVERFLOW
	dc.w	RESET			;TIMER OVERFLOW
	dc.w	RESET			;TIMER CHANNEL 7
	dc.w	RESET			;TIMER CHANNEL 6
	dc.w	RESET			;TIMER CHANNEL 5
	dc.w	RESET			;TIMER CHANNEL 4
	dc.w	keybrd_int		;TIMER CHANNEL 3
	dc.w	RESET			;TIMER CHANNEL 2
	dc.w	RESET			;TIMER CHANNEL 1
	dc.w	RESET			;TIMER CHANNEL 0
	dc.w	RealTimeInt		;REAL TIME INTERRUPT
	dc.w	RESET			;IRQ OR KEY WAKE UP D
	dc.w	RESET			;XIRQ
	dc.w	dummy_int		;SWI
	dc.w	RESET			;RESERVED
	dc.w	RESET			;COP FAILURE RESET
	dc.w	RESET			;COP CLOCK MONITOR FAIL RESET
	dc.w	RESET1			;Power On Reset
