;MAIN.ASM
;Bootloader for the 912b32processor
;
;Author: Exequiel Rarama
;
#include REGS912A.INC

RAM             equ     $0800
STACK           equ     $0BFF
EEPROM          equ     $0d00
EEPROM_BOOT     equ     $0d00

;SCI Variables
scimask         equ     %00001100       ;TE - Transmit Enable
                                        ;RE - Receiver Enable
RDRFflag        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
;MCLK=8Mzh
BAUD110         equ     4545    ;(baud) 110 baud with 16 Mhz crystal
BAUD300         equ     1667    ;(baud) 300 baud with 16 Mhz crystal
BAUD600         equ     833     ;(baud) 600 baud with 16 Mhz crystal
BAUD1200        equ     417     ;(baud) 1200 baud with 16 Mhz crystal
BAUD2400        equ     208     ;(baud) 2400 baud with 16 Mhz crystal
BAUD4800        equ     104     ;(baud) 4800 baud with 16 Mhz crystal
BAUD9600        equ     52      ;(baud) 9600 baud with 16 Mhz crystal
BAUD14400       equ     35      ;(baud) 14400 baud with 16 Mhz crystal
BAUD19200       equ     26      ;(baud) 19200 baud with 16 Mhz crystal
BAUD38400       equ     13      ;(baud) 19200 baud with 16 Mhz crystal


        org     RAM

temp            ds      1
byte_count      ds      1
ee_adr          ds      2
temp1           ds      1
temp2           ds      1
sci_flag        ds      1
code_mem        ds      2
code_adr        equ     $

        org     EEPROM_BOOT

; Start of Program
; ----------------
reset
        sei
        lds     #STACK                  ;initialize stack to top of ram
        clr     COPCTL                

;Initialize PORTP
        movb    #%10000000,DDRP         ;Bit 6 PORTP as Output
        movb    #%00000000,PORTP        ;PORTP clear

;Initialize Serial Communication Interface
        movb    #scimask,SC0CR2         ;enable SCI 0 rcvr. & xmtr.
        movb    #0,SC0CR1
        movw    #BAUD9600,SC0BDH
 
        ldaa    SC0SR1                  ;read register to clear flag RDRF
        ldaa    SC0DRL                  ;dummy read to flush receive buffer

        ldx     #BLPrompt
        jsr     OutStr

look_for_command
        brclr   SC0SR1,RDRFflag,*
        ldab    SC0SR1                  ;read register to clear flag RDRF
        ldab    SC0DRL                  ;read receive buffer
        cmpb    #'R'                    ;Wait until Command received
        beq     run_code
        cmpb    #'L'                    ;Wait until Command received
        beq     program_code
        bne     look_for_command

run_code
        ldx     #EXE
        jsr     OutStr

        ldx     #$8000

;        ldx     #$fffe
        jmp     0,x                     ;go program

;comes here if vector address is undefine
go_error
        bclr    PORTP,%10000000
        bsr     delay
        bset    PORTP,%10000000
        bsr     delay
        bra     go_error

delay
        ldab    #4
dly1
        ldy     #0
dly2
        dey
        bne     dly2
        decb
        bne     dly1
        rts

SerOutput
        brclr   SC0SR1,TDREflag,SerOutput      ;check if buffer is empty
        staa    SC0DRL
        rts

OutStr:                         ; send a null terminated string to the display.
        ldaa    1,x+            ; get a character, advance pointer, null?
        beq     OutStrDone      ; yes. return.
        jsr     SerOutput       ; no. send it out the SCI.
        bra     OutStr          ; go get the next character.
;
OutStrDone:
        rts
;
;-----------------------------------------------------------------------------
;Table of Messages
;
BLPrompt        fcb     $0d,$0a
                fcc     "(R)un or (L)oad:"
                fcb     0
LFeed:          fcb     $0c,0
CrLfStr:        fcb     $0d,$0a,0
OK              fcc     "Upload file NOW"
                fcb     0
EXE             fcc     "Executing Program NOW"
                fcb     0


#include pram.asm

