;EEFLASH.ASM
;MC68HC912D60 PROGRAMMING ROUTINE
;
*******************************************************************************
*REVISION HISTORY:
*
*DATE				REV. NO.	DESCRIPTION
*
*June 13, 2000			V1.00		- Flash Loader
*
*Dec 24, 2000			V1.01		- Fix Bugs
*
*September 9, 2001		V1.02		- Fix PLL Bugs - will loop until PLL lock in
*
*November 24, 2001		V1.03		- External Ram support
*						- Command to Execute Internal/External Program
*						- Led will toggle if Pseudo Vector $DFFE:DFFF are $FFFF
*						- During Ram Load, LED will come ON if faulty write to RAM
*
*December 7, 2001		V1.04		- Revamped External RAM Program
*						- Allow independent programming of different Banks
*						- Ability for 2 independent program in 2 Banks
*
*Author: Exequiel Rarama
********************************************************************************
;
;Compiled using MiniIDE

PAGE		equ	%1000	;Port S bit 3

; -----------------------
; Boot Flash - EEFLASH Routine
; -----------------------
;
BootLoad
	bset	DDRG,LED
	bset	DDRS,PAGE

        movb    #0,FEE28LCK     ;Enable the erasure or programming of the 2k bootblock
        movb    #0,FEE28MCR     ;Enable the programming of the 2k bootblock

        movb    #$B0,TSCR       ;enable the timer sysem. set for fast flag clears
        movb    #1,TIOS         ;enable timer channel 0 as an output compare.

BLLoop
        leax    BLPrompt-4-*,pc ;point to the bootload prompt.
        jsr     OutStr-4-*,pc   ; display it.

        jsr     getchar-4-*,pc  ;get the command from the user
        jsr     putchar-4-*,pc  ; and echo it.
        pshb                    ;save char temporarily

        leax    CrlfStr-4-*,pc  ;go to next line
        jsr     OutStr-4-*,pc   ;display it.

        pulb                    ;restore the entered char
        andb    #$df            ;simple convert to upper case (only works for alpha char)

CheckFErase
        cmpb    #'U'            ;erase command entered?
        beq     Erase32K         ;no, go check next command

        cmpb    #'L'            ;erase command entered?
        beq     Erase28K        ;no, go check next command

        cmpb    #'G'            ;Execute Program?
        beq     Go_Run_Flash	;no, go check next command

        cmpb    #'X'            ;Execute Program?
        beq     Go_Run_RAM		;no, go check next command

        bra     ChkProg		;Check if programming

Go_Run_Flash
	ldx	$DFFE
	jmp	0,x			;Execute Program

Go_Run_RAM
	bsr	Set_ExPanded_Mode	;Set mode before running external Ram
	ldx	$FFFE
	jmp	0,x			;Execute Program

Erase28K
        clr     NotErasedFlag   ;init erase result
        bsr     CheckVfp        ;yes, check for Vfp present
        bne     BadErase        ; go print prompt, if not present
        jsr     FErase28-4-*,pc        ;yes, go erase the Flash
        bra     Err_msg         ;

Erase32K
        clr     NotErasedFlag   ;init erase result
        bsr     CheckVfp        ;yes, check for Vfp present
        bne     BadErase        ; go print prompt, if not present
        jsr     FErase32-4-*,pc        ;yes, go erase the Flash

Err_msg
        ldab    NotErasedFlag   ;get the erase result
        bne     Not_Erase       ;branch if it did not erase properly
        leax    Erased-4-*,pc         ;if it did, point to the 'erased' message
        bra     BadErase

Not_Erase
        leax    ENot-4-*,pc           ;point to the 'not erase' message

BadErase
        jsr     Outstr-4-*,pc          ;

BadErase10
        bra     BLLoop          ;go back & print the prompt again

ChkProg
	cmpb	#'R'            ;program command entered?
	lbeq	Ram_Prog

        cmpb    #'P'            ;program command entered?
        bne     BLLoop          ;no, go display command prompt

        bsr     CheckVfp        ;yes, check Vfp
        bne     BadErase10        ;go print prompt if not present
        bsr     FProg           ;yes, go program the flash

EEProgStart
;       pshc                    ;save the returned succes/fail condition

        leax    CrlfStr-4-*,pc         ;go to next line
        jsr     Outstr-4-*,pc          ;display it.

;       pulc                    ;restore the returned succes/fail condition
;       beq

;       leax    PNot-4-*,pc           ;point to the 'not programmed' message
;       bne     BadErase        ;go display the string if the programming failed
        leax    Programmed-4-*,pc     ;otherwise, point to the 'programmed' message

BadProg
        bra     BadErase         ;go display the prompt again

;-------------------------------------------------------------------------------
CheckVfp
        clra                            ;assume that Vfp is present (set z==1)
        brset   FEE32CTL,SVFP,VFpOK     ;programming voltage present?
        leax    NoVfpError-4-*,pc          ;no, inform the user
        jsr     Outstr-4-*,pc
        inca

VfpOK
        rts                             ;return Z==0 (not zero condition)

;-----------------------------------------------------------------------------
Set_ExPanded_Mode
	leax	RAM_msg-4-*,pc		;Send Caution message
	jsr	OutStr-4-*,pc		;display it.

	leax	Page_Msg-4-*,pc		;Send Choose a Bank message
	jsr	OutStr-4-*,pc		;display it.

	jsr	getchar-4-*,pc
	cmpb	#$30
	beq	Set_Ex10

	bset	PORTS,PAGE		;Execute Higher Bank
	bra	Set_Ex20
	
Set_Ex10
	bclr	PORTS,PAGE		;Execute Lower Bank

Set_Ex20
	movw	#$2CF9,PEAR		;16 bit Write to PEAR and MODE
	movb	#$3c,MISC		;Disable Flash and max the E stretch clock

	bclr	MODE,ESTR		;enable E clock
	bclr	PEAR,NECLK

	rts

;------------------------------------------------------------------------------
FProg
	leax	Send_msg-4-*,pc	;Send Caution message
	jsr	OutStr-4-*,pc		;display it.

        movb    #$00,TMSK2      ;set the prescaler to /1
        bra     FSkipFirst      ;do not send the 'pace' char the 1st time

FSendPace
        ldab    #'*'            ;the ascii asterisk is the pace char
        jsr     putchar-4-*,pc         ;tell the host it is ok to send the nex S-record

FSkipFirst
        jsr     GetSRecord-4-*,pc      ;go get the S-record
        bne     ProgDone        ;non-zero condition means there was an error

        ldab    RecType         ;check the record type
        cmpb    #S9RecType      ;was it an S9 Record?
        beq     ProgDone        ;yes, we are done

        cmpb    #S0RecType      ;no, was it an S0 Record?
        beq     FSendPace       ;yes, just ignore it

        bsr     ProgFBlock      ;no, that means it was an S1 record. go program the
                                ;data into flash
        beq     FsendPace       ;zero condition means all went ok

ProgDone
        rts                     ;if we fall through, we automatically return a
                                ;non-zero condition. If we get here after detecting
                                ; an S9 record, we'll return a zero condition


;-----------------------------------------------------------------------------
Ram_Prog
	bsr	Set_ExPanded_Mode	;Set mode

	leax	Send_msg-4-*,pc	;Send File message
	jsr	OutStr-4-*,pc		;display it.

	bra	RSkipFirst      ;do not send the 'pace' char the 1st time

RSendPace
	ldab	#'*'            ;the ascii asterisk is the pace char
	jsr	putchar-4-*,pc         ;tell the host it is ok to send the nex S-record

RSkipFirst
	jsr	GetSRecord-4-*,pc       ;go get the S-record

	bne	RProgDone        ;non-zero condition means there was an error

	ldab	RecType         ;check the record type
	cmpb	#S9RecType      ;was it an S9 Record?
	beq	RProgDone        ;yes, we are done

	cmpb	#S0RecType      ;no, was it an S0 Record?
	beq	RSendPace       ;yes, just ignore it

	bsr	ProgRBlock      ;no, that means it was an S1 record. go program the
                                ;data into flash

	bra	RsendPace       ;next byte block to write to RAM

RProgDone
	ldab	#'*'			;the ascii asterisk is the pace char
	jsr	putchar-4-*,pc	;tell the host it is ok to send the nex S-record

	leax	Send_Done_msg-4-*,pc	;Send File message
	jsr	OutStr-4-*,pc		;display it.

	lbra	BLLoop			;command prompt
					;if we fall through, we automatically return a
					;non-zero condition. If we get here after detecting
					; an S9 record, we'll return a zero condition

ProgRBlock
	ldx	LoadAddr        ;get the S-record (Flash) load address
	ldy	#SRecData       ;point to the received S-record data

RProgLoop
	movb	0,y,0,x         ;put the data into RAM

	ldab	0,x
	cmpb	0,y
	bne	RProgLoop	;It could be here forever

	ldab	1,x+            ;get the data from the Flash memory
	cmpb	1,y+            ;same as the S-record data?
	bne	RPDoneErr       ;no, bad flash memory (or Vfp not applied)

	dec	DataBytes       ;done with all the S-record bytes?
	bne	RProgLoop        ;no, program the next location

	bra	RPDone

RPDoneErr
	bset	PORTG,LED

RPDone
	rts



;-----------------------------------------------------------------------------
ProgFBlock
        ldx     LoadAddr        ;get the S-record (Flash) load address
        ldy     #SRecData       ;point to the received S-record data

ProgLoop
        clr     ProgPulses      ;initialize the ProgPulses var
        clr     PMarginFlag     ;initialize the PMarginFlag var

        cpx     #$8000          ;go program below $8000
        blo     prog_lo

        bset    FEE32CTL,LAT    ;turn on the Flash address/data latches
        bra     prog_hi

prog_lo
        bset    FEE28CTL,LAT    ;turn on the Flash address/data latches

prog_hi
        movb    0,y,0,x         ;put the data into the latches

PPulseLoop
        bclr    TSCR,TEN        ;stop the timer so we can produce accurate time
                                ;delays
        inc     ProgPulses      ;add 1 to the number of programming pulses we've applied
        ldab    ProgPulses      ;get the new value
        cmpb    #MaxProgPulses  ;have we applied the max allowable prog pulses?
        bls     PMarginLoop     ;no, go apply a programming pulse
        movb    #1,PMarginFlag  ;yes, now try applying 'MaxProgPulses' of margin

PMarginLoop
        ldd     #us22           ;get the constant for 22us delay
        addd    TCNT            ;add it to the current value of the timer counter reg
        std     TC0             ;initialize the output compare reg with the delay value

        cpx     #$8000          ;check if program below $8000
        blo     prog_lo10

        bset    FEE32CTL,ENPE   ;turn on Vfp
        bra     prog_hi10

prog_lo10
        bset    FEE28CTL,ENPE   ;turn on Vfp

prog_hi10
        bset    TSCR,TEN        ;turn on the timer
        brclr   TFLG1,$01,*     ;wait here until Vfp has been applied for 22us

        cpx     #$8000          ;check if program below $8000
        blo     prog_lo20

        bclr    FEE32CTL,ENPE   ;turn off Vfp
        bra     prog_hi20

prog_lo20
        bclr    FEE28CTL,ENPE   ;turn off Vfp

prog_hi20
        ldd     #us11           ;get constant for 11us delay
        addd    TCNT
        std     TC0
        brclr   TFLG1,$01,*     ;wait here until Vfp has been removed for 11us
        tst     PMarginFlag     ;are we appling the programming margin pulses?
        beq     CmpData         ;no, go see if the data programmed properly
        dec     ProgPulses      ;yes, have we applied margin pulses equal to the number

        bne     PMarginLoop     ;no, go apply more margin pulses
        bra     PMarginDone     ;yes, go check the data again

CmpData
        ldab    0,x             ;get the data from the Flash memory
        cmpb    0,y             ;same as the S-record data?
        bne     PPulseLoop      ;no, go apply some more programming pulses
        movb    #1,PMarginFlag  ;yes, set the programming margin flag
        bra     PMarginLoop     ;go apply the margin programming pulses

PMarginDone
        cpx     #$8000          ;check if program below $8000
        blo     PMargin10

        bclr    FEE32CTL,LAT    ;turn off the flash address/data latches to prepare for
        bra     PMargin20

PMargin10
        bclr    FEE28CTL,LAT    ;turn off the flash address/data latches to prepare for

PMargin20                       ;programming the next location
        ldab    1,x+            ;get the data from the Flash memory
        cmpb    1,y+            ;same as the S-record data?
        bne     PDone           ;no, bad flash memory (or Vfp not applied)
        dec     DataBytes       ;done with all the S-record bytes?
        lbne    ProgLoop        ;no, program the next location

PDone
        rts

;-----------------------------------------------------------------------------
FErase32
        leax    EraseMsg0-4-*,pc      ;no, inform the user
        jsr     Outstr-4-*,pc

        movb    #$5,TMSK2       ;set the prescaler to /32
        clr     EMarginFlag     ;clear the margin pulses flag
        clr     NumPulses       ;clear the erase pulse count

        bset    FEE32CTL,LAT+ERAS ;turn on the address/data latches & erase bit
        std     FlashStart32    ;write to any Flash address (data do not matter)

EraseLoop32
        ldab    NumPulses       ;get the 'pulse' count
        cmpb    #MaxErasePulses ;applied the maximum number of erase pulses?
        beq     DoEMargin32     ;yes, go apply the erase margin pulse
        inc     NumPulses       ;add 1 to the number of 100ms 'pulses' to apply

PulseLoop32
        bset    FEE32CTL,ENPE     ;turn on Vfp

        ldd     #ms100          ;timer constant to produce 100ms delay
        addd    TCNT
        std     TC0

        brclr   TFLG1,$01,*
        bclr    FEE32CTL,ENPE     ;turn off Vfp

        ldd     #ms1
        addd    TCNT
        std     TC0
        brclr   TFLG1,$01,*

        tst     EMarginFlag     ;are we applying margin erase pulses?
        beq     CheckErase32    ;no, go check to see if the last pulse erase the array
        dec     NumPulses       ;yes, have we applied enough margin pulses?
        bne     PulseLoop32     ;no, go apply some more

CheckErase32
        clr     NotErasedFlag   ;clear the erased flag
        ldx     #FlashStart32   ;point to the start of the flash block
        ldy     #ByteWord32     ;get a count of the number of words
                                ;we are going to check
        ldd     #$FFFF          ;the value of an erased word

EraseChkLoop32
        cpd     2,x+            ;this word erase?
        bne     NotErased32     ;no, go set flag & apply another erase pulse
        dbne    y,EraseChkLoop32;yes, decrement word count & go check the next word

DoEMargin32
        tst     EMarginFlag     ;have we already applied the margin pulse?
        bne     EraseDone32     ;yes, we are done. the result of the erase funtion is
                                ;in the NotEraseFlag
        inc     EMarginFlag     ;no, set the 'margin pulse applied' flag
        bra     PulseLoop32     ;go apply the margin erase pulse

NotErased32
        inc     NotErasedFlag   ;array was not erased. flag the condition
        tst     EMarginFlag     ;have we already applied the margin pulse?
        bne     EraseDone32     ;yes, we are done. the Flash is bad
        bra     EraseLoop32     ;have not yet applied the margin pulse. go apply another erase pulse

EraseDone32
        clr     FEE32CTL        ;make sure that the LAT & ERAS bit is clear
        ldab    NotErasedFlag   ;get the erase result
        rts

;-----------------------------------------------------------------------------
FErase28
        leax    EraseMsg1-4-*,pc      ;no, inform the user
        jsr     Outstr-4-*,pc

        movb    #$5,TMSK2        ;set the prescaler to /32
        clr     EMarginFlag     ;clear the margin pulses flag
        clr     NumPulses       ;clear the erase pulse count

        bset    FEE28CTL,LAT+ERAS ;turn on the address/data latches & erase bit
        std     FlashStart28    ;write to any Flash address (data do not matter)

EraseLoop28
        ldab    NumPulses       ;get the 'pulse' count
        cmpb    #MaxErasePulses ;applied the maximum number of erase pulses?
        beq     DoEMargin28     ;yes, go apply the erase margin pulse
        inc     NumPulses       ;add 1 to the number of 100ms 'pulses' to apply

PulseLoop28
        bset    FEE28CTL,ENPE     ;turn on Vfp

        ldd     #ms100          ;timer constant to produce 100ms delay
        addd    TCNT
        std     TC0

        brclr   TFLG1,$01,*
        bclr    FEE28CTL,ENPE     ;turn off Vfp

        ldd     #ms1
        addd    TCNT
        std     TC0
        brclr   TFLG1,$01,*

        tst     EMarginFlag     ;are we applying margin erase pulses?
        beq     CheckErase28    ;no, go check to see if the last pulse erase the array
        dec     NumPulses       ;yes, have we applied enough margin pulses?
        bne     PulseLoop28     ;no, go apply some more

CheckErase28
        clr     NotErasedFlag   ;clear the erased flag
        ldx     #FlashStart28   ;point to the start of the flash block
        ldy     #ByteWord28     ;get a count of the number of words
                                ;we are going to check
        ldd     #$FFFF          ;the value of an erased word

EraseChkLoop28
        cpd     2,x+            ;this word erase?
        bne     NotErased28     ;no, go set flag & apply another erase pulse
        dbne    y,EraseChkLoop28;yes, decrement word count & go check the next word

DoEMargin28
        tst     EMarginFlag     ;have we already applied the margin pulse?
        bne     EraseDone28     ;yes, we are done. the result of the erase funtion is
                                ;in the NotEraseFlag
        inc     EMarginFlag     ;no, set the 'margin pulse applied' flag
        bra     PulseLoop28     ;go apply the margin erase pulse

NotErased28
        inc     NotErasedFlag   ;array was not erased. flag the condition
        tst     EMarginFlag     ;have we already applied the margin pulse?
        bne     EraseDone28     ;yes, we are done. the Flash is bad
        bra     EraseLoop28     ;have not yet applied the margin pulse. go apply another erase pulse

EraseDone28
        clr     FEE28CTL        ;make sure that the LAT & ERAS bit is clear
        ldab    NotErasedFlag   ;get the erase result
        rts

;-----------------------------------------------------------------------------
GetSRecord
        bsr     getchar         ;get a char
        cmpb    #'S'            ;start of record char?
        bne     GetSRecord

        bsr     getchar

        cmpb    #S0RecType      ;found an S0 record?
        beq     SaveRecType     ;no, go check for S9 record

CheckForS9
        cmpb    #S9RecType      ;found and S9 record?
        beq     SaveRecType     ;no, go check for S1 record

CheckForS1
        cmpb    #S1RecType      ;found an S1 record?
        bne     GetSRecord      ;no, false start

SaveRecType
        stab    RecType         ;yes, set the record type to '1'

        bsr     GetHexByte      ;get the S-record length byte
        bne     BadSRec         ;return if there was an error

        stab    SRecBytes       ;save the total number of s-record bytes we are to receive
        stab    CheckSum        ;initialize the checksum calculation with data byte count
        subb    #3              ;subtract the load address & checksum field from the
                                ;data field count
        stab    DataBytes       ;save the code/data field size

        ldx     #LoadAddr       ;point to the load address/code/data/checksume buffer

RcvData
        bsr     GetHexByte      ;get an S-record data byte
        bne     BadSRec         ;return if there was an error

        ldab    temp
        stab    1,x+            ;save the byte in the data buffer
        addb    CheckSum        ;add the byte into the checksum
        stab    CheckSum        ;save the result

        dec     SRecBytes       ;received all S-record bytes?
        bne     RcvData         ;no, go get some more

        inc     CheckSum        ;if checksum was ok, the result will be zero

BadSRec
        rts

;-----------------------------------------------------------------------------
GetHexByte
        bsr     getchar         ;get the upper nibble from the SCI

        bsr     IsHex           ;valid hex Char?
        beq     OK1             ;yes, go convert to bin
        rts                     ;no, return with a non zero ccr indication

OK1
        bsr     CvtHex          ;convert the ascii hex to bin
        aslb
        aslb
        aslb
        aslb
        andb    #$f0
        stab    temp

        bsr     getchar         ;get lower nibble from the SCI
        bsr     IsHex           ;valid hex char?
        beq     OK2             ;yes, go convert to bin
        rts                     ;no, return with a non zero ccr indication

OK2
        bsr     CvtHex          ;convert to bin
        addb    temp            ;add it to upper nibble
        stab    temp

        clra                    ;simple way to set the z ccr bit
        rts

CvtHex
        subb    #'0'            ;subtract ascii '0' from hex char
        cmpb    #$9             ;was it a decimal digit?
        bls     CvtHexRtn       ;yes, ok as is
        subb    #$7             ;no, it was an ascii hex letter ('A'-'F')

CvtHexRtn
        rts

IsHex
        cmpb    #'0'            ;less than ascii hex zero?
        blo     NotHex          ;yes, char is not hex, return a non zero ccr indication
        cmpb    #'9'            ;less than or equal to ascii 9?
        bls     IsHex1          ;yes, char is hex, return a zero ccr indication
        cmpb    #'A'            ;less than an ascii hex 'A'?
        blo     NotHex          ;yes, char is not hex
        cmpb    #'F'            ;less than or equal to ascii hex 'F'?
        bhi     NotHex          ;yes, char is hex

IsHex1
        orcc    #%0100          ;no, return a zero ccr conditon

NotHex
        rts

;-----------------------------------------------------------------------------
getchar
        brclr   SC0SR1,RDRFflag,*         ;loop waiting for the RDRF bit to be set
        ldab    SC0SR1          ;read register to clear flag RDRF
        ldab    SC0DRL          ;read receive buffer
        rts

OutStr
        ldab    1,x+            ;get a char, advance pointer, null?
        beq     OutStrDone      ;yes, return
        bsr     putchar         ;no, sent it out
        bra     OutStr          ;go send next char

OutStrDone
        rts

putchar
        brclr   SC0SR1,TDREflag,*  ;loop waitin for the TDRE bit to be set
        stab    SC0DRL             ;send char
        rts

;-----------------------------------------------------------------------------
CrlfStr	dc.b	$0a,$0d,$0
BLPrompt	dc.b	$0a,$0d,"Technological Arts D60 Flash Util. V1.04"	
		dc.b	$0a,$0d,"U -> Erase Upper block"
		dc.b	$0a,$0d,"L -> Erase Lower block"
		dc.b	$0a,$0d,"G -> Execute Program (Pseudo Vector)"
		dc.b	$0a,$0d,"P -> Program Flash"
		dc.b	$0a,$0d,"R -> Program External Ram"
		dc.b	$0a,$0d,"X -> Execute Program in External Ram"
		dc.b	$0a,$0d,"? ",0

Send_msg	dc.b	$0a,$0d,"Send File Now",$0a,$0d,0
Send_Done_msg	dc.b	$0a,$0d,"Done",$0a,$0d,0

RAM_msg	dc.b	$0a,$0d,"Internal Flash Disabled"
		dc.b	$0a,$0d,"CAUTION! Address, Data BUS enabled"
		dc.b	$0a,$0d,"Slide Program Switch to Run",0
		dc.b	$0a,$0d,"Press any key when Ready",0

ENot		dc.b	"Not "
Erased		dc.b	"Erased",0
Pnot		dc.b	"Not "
Programmed	dc.b	"Programmed",0

NoVfpError	dc.b	$0a,$0d,"Vfp Not Present",0
EraseMsg0	dc.b	$0a,$0d,"Erasing 32K Flash",$0a,$0d,0
EraseMsg1	dc.b	$0a,$0d,"Erasing 28K Flash",$0a,$0d,0

Page_Msg	dc.b	$0a,$0d,"Choose a Bank - (0), (1)",0
;-----------------------------------------------------------------------------


code_len equ    ($-BootLoad)
