;MAIN.ASM
;MC68HC912d60 MAIN ROUTINE
;REGD60.INC CONTAINS ALL REGISTERS
;
*******************************************************************************
*REVISION HISTORY:
*
*DATE				REV. NO.	DESCRIPTION
*
*June 13, 2000			V1.00		- Flash Loader
*
*Dec 24, 2000			V1.01		- Fix Bugs
*
*September 9, 2001		V1.02		- Fix PLL Bugs - will loop until PLL lock in
*
*November 24, 2001		V1.03		- External Ram support
*						- Command to Execute Internal/External Program
*						- Led will toggle if Pseudo Vector $DFFE:DFFF are $FFFF
*						- During Ram Load, LED will come ON if faulty write to RAM
*
*December 7, 2001		V1.04		- Revamped External RAM Program
*						- Allow independent programming of different Banks
*						- Ability for 2 independent program in 2 Banks
*
*Author: Exequiel Rarama
********************************************************************************
;Compiled using MiniIDE
;Program resident flash loader to the 912D60.  It resides at e000 to ffff
;Pseudo vector is below e000 and begins at dfce.
;
; -----------------------
;  Main Routine
; -----------------------

#INCLUDE "REGD60.INC"                ;register block addresses

RAM     equ     $200            ;68HCD60  internal RAM
STACK   equ     $0800           ;Stack at top of internal ram
EEPROM  equ     $0c00           ;68HC912D60  internal EEPROM
FLASH   equ     $8000           ;68HC912D60  internal FLASH memory
rbase   equ     $0000           ;68HC912D60 register block
CODE    equ     $8000           ;Start of Flash

FlashStart32    equ     $8000
FlashStart28    equ     $1000
BootFlash       equ     $e000
FlashSize32     equ     32768
FlashSize28     equ     28672
BootBlkSize     equ     8192

;CodeStart       equ     $8000   ;Start of Code

;SCI Variables
scimask         equ     %00101100       ;RIE - SCI Interrupt enable
scimask1        equ     $0c             ;TE - Transmit Enable, RE - Receiver Enable
RDRFflag        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
;MCLK=8Mzh
BAUD110         equ     4545    ;(baud) 110 baud with 16 Mhz crystal
BAUD300         equ     1667    ;(baud) 300 baud with 16 Mhz crystal
BAUD600         equ     833     ;(baud) 600 baud with 16 Mhz crystal
BAUD1200        equ     417     ;(baud) 1200 baud with 16 Mhz crystal
BAUD2400        equ     208     ;(baud) 2400 baud with 16 Mhz crystal
BAUD4800        equ     104     ;(baud) 4800 baud with 16 Mhz crystal
BAUD9600        equ     52      ;(baud) 9600 baud with 16 Mhz crystal
BAUD14400       equ     35      ;(baud) 14400 baud with 16 Mhz crystal
BAUD19200       equ     26      ;(baud) 19200 baud with 16 Mhz crystal
BAUD38400       equ     13      ;(baud) 19200 baud with 16 Mhz crystal
;
;Boot Flash Variables
S0REcType       equ     '0'     ;ASCII '0' used as S0 record type indicator
S1REcType       equ     '1'     ;ASCII '1' used as S1 record type indicator
S9REcType       equ     '9'     ;ASCII '9' used as S9 record type indicator

us22            equ     175
us11            equ     88
ms100           equ     $30d4
ms1             equ     $9c3
TEN             equ     $80

ENPE            equ     %0001
LAT             equ     %0010
ERAS            equ     %0100
SVFP            equ     %1000
MaxProgPulses   equ     50      ;maximum number of programming pulses.
MaxErasePulses  equ     5       ;maximum number of erase pulses

ByteWord32      equ     12288   ;FlashSize32/2 - Note: from 8000 to E000
ByteWord28      equ     14336   ;FlashSize28/2

;Pll variables
LOCK		equ	%01000000	;Lock bit in PLLFLG register
BCSP		equ	%01000000
NECLK		equ	%00010000
ESTR		equ	%00010000
LED		equ	%10000000	;Port J led control

;-----------------------------------------------------------------------------
        org     RAM

;Ram Variables
RecType         ds      1
DataBytes       ds      1
LoadAddr        ds      2
SRecData        ds      65

ProgPulses      ds      1
PMarginFlag     ds      1
EMarginFlag     ds      1
NumPulses       ds      1
NotErasedFlag   ds      1
SRecBytes       ds      1
CheckSum        ds      1
temp            ds      1

Ramcode         equ     temp+1

;-----------------------------------------------------------------------------
        org     BootFlash
;
BootStart                       ;This is where the RESET vector points to
	sei                     ;Disable Any interrupts

;Initialize Stack
	lds	#STACK          ;initialize stack pointer
	bset	PUCR,$1                 ;turn on PORTA pullups (for Mode Sel)

	brclr	PORTA,$40,BootCopy      ;if port bit 6 is low then
                                        ;  do boot sequence
execute_code
	ldx	PowerOn-$2000              ; else execute user program
	cpx	#$FFFF			;Check if Blank
	beq	Program_Trap
	jmp	0,x

Program_Trap
	clr	COPCTL                  ;Disable watchdog timer
	bset	DDRG,LED
	clr	PORTG

Trap10
	com	PORTG
	bsr	delay
	bra	Trap10

delay
	ldx	#$FFFF

dly	
	dbne	x,dly
	rts

;----------------------------------
;Start of boot programming sequence. Copies bootstrap routines to RAM then
; jumps to RAM to execute.

BootCopy
        bclr    PUCR,$1                 ;turn off PORTA pullups (for Mode Sel)
        clr     COPCTL                  ;Disable watchdog timer

        ldx     #BootLoad               ;Point to the start of the Flash bootloader
        ldy     #Ramcode                ;memory ram location to save boot.
        ldd     #code_len               ;End of boot code

MoveMore
        movb    1,x+,1,y+               ;move byte to ram
        dbne    d,MoveMore              ; until done

;Initialize Serial Communication Interface
        movb    #scimask1,SC0CR2        ;enable SCI 0 rcvr. & xmtr.
        movb    #0,SC0CR1
;
        movw    #BAUD9600,SC0BDH        ;Set baud rate to 9600
        ldab    SC0SR1                  ;read register to clear flag RDRF
        ldab    SC0DRL                  ;read receive buffer

;Setup PLL
	movb	#$00,SYNR
	movb	#$00,REFDV
		
	brclr	PLLFLG,LOCK,*		;Loop here until PLL locks
	bset	CLKSEL,BCSP	

	jmp	Ramcode                 ;execute code

;-----------------------------------------------------------------------------
;Psuedo Vector Interrupts


JCGM_LOCK
        ldx     CGM_LOCK-$2000
        jmp     0,x

JMSCAN0_TXD
        ldx     MSCAN0_TXD-$2000
        jmp     0,x

JMSCAN0_RXD
        ldx     MSCAN0_RXD-$2000
        jmp     0,x

JMSCAN0_ERR
        ldx     MSCAN0_ERR-$2000
        jmp     0,x

JPULSEB
        ldx     PULSEB-$2000     	;Pulse Accumulator B overflow
        jmp     0,x

JMOD_DOWN
        ldx     MOD_DOWN-$2000     	;Modulus Down Counter Underflow
        jmp     0,x

JKWJ_H
        ldx     KWJ_H-$2000     	;KEY WAKEUP FOR J or H
        jmp     0,x

JMSCAN0_WAKE
        ldx     MSCAN0_WAKE-$2000	;MSCAN0 WAKEUP 
        jmp     0,x

JATD
        ldx     ATD-$2000      ;ANALOG TO DIGITAL
        jmp     0,x

JSCI1
        ldx     SCI1-$2000     ;SERIAL COMMUNICATION 0
        jmp     0,x

JSCI0
        ldx     SCI0-$2000     ;SERIAL COMMUNICATION 0
        jmp     0,x

JSPI
        ldx     SPI-$2000      ;SPI SERIAL TRANSFER COMPLETE
        jmp     0,x

JPACCIE
        ldx     PACCIE-$2000   ;PULSE ACCUMULATOR INPUT EDGE
        jmp     0,x

JPACCOv
        ldx     PACCOv-$2000   ;PULSE ACCUMULATOR OVERFLOW
        jmp     0,x

JTimerOv
        ldx     TimerOv-$2000  ;TIMER OVERFLOW
        jmp     0,x

JTimerCh7
        ldx     TimerCh7-$2000 ;TIMER CHANNEL 7
        jmp     0,x

JTimerCh6
       ldx      TimerCh6-$2000 ;TIMER CHANNEL 6
       jmp      0,x

JTimerCh5
        ldx     TimerCh5-$2000 ;TIMER CHANNEL 5
        jmp     0,x

JTimerCh4
        ldx     TimerCh4-$2000  ;TIMER CHANNEL 4
        jmp     0,x

JTimerCh3
        ldx     TimerCh3-$2000  ;TIMER CHANNEL 3
        jmp     0,x

JTimerCh2
        ldx     TimerCh2-$2000  ;TIMER CHANNEL 2
        jmp     0,x

JTimerCh1
        ldx     TimerCh1-$2000  ;TIMER CHANNEL 1
        jmp     0,x

JTimerCh0
        ldx     TimerCh0-$2000  ;TIMER CHANNEL 0
        jmp     0,x

JRTI
        ldx     RTI-$2000       ;REAL TIME INTERRUPT
        jmp     0,x

JIRQ
        ldx     IRQ-$2000       ;IRQ OR KEY WAKE UP D
        jmp     0,x

JXIRQ
        ldx     XIRQ-$2000      ;XIRQ
        jmp     0,x

JSWI
        ldx     SWI-$2000       ;SWI
        jmp     0,x

JIllop
        ldx     Illop-$2000     ;RESERVED
        jmp     0,x

JCOPFail
        ldx     COPFail-$2000   ;COP FAILURE RESET
        jmp     0,x

JClockFail
        ldx     ClockFail-$2000 ;COP CLOCK MONITOR FAIL RESET
        jmp     0,x

Reset
        ldx     PowerOn-$2000   ;Pseudo reset
        jmp     0,x

;=============================================================================

#include "EEFLASH.ASM"

;-----------------------------------------------------------------------------
;MC68HC912d60 VECTOR INTERRUPTS

        ORG     $FFC2

CGM_LOCK	dc.w	JCGM_LOCK
MSCAN0_TXD	dc.w	JMSCAN0_TXD	
MSCAN0_RXD	dc.w	JMSCAN0_RXD	
MSCAN0_ERR	dc.w	JMSCAN0_ERR	;MSCAN0 ERROR

PULSEB		dc.w	JPULSEB		;Pulse Accumulator B overflow

MOD_DOWN	dc.w	JMOD_DOWN       ;Modulus Down Counter Underflow
KWJ_H		dc.w	JKWJ_H          ;KEY WAKEUP for J of H
MSCAN0_WAKE	dc.w	JMSCAN0_WAKE	;MSCAN0 Wake Up
ATD		dc.w	JATD            ;ANALOG TO DIGITAL

SCI1		dc.w	JSCI1           ;SERIAL COMMUNICATION 1
SCI0		dc.w	JSCI0           ;SERIAL COMMUNICATION 0
SPI		dc.w	JSPI            ;SPI SERIAL TRANSFER COMPLETE
PACCIE		dc.w	JPACCIE         ;PULSE ACCUMULATOR INPUT EDGE
PACCOv		dc.w	JPACCOv         ;PULSE ACCUMULATOR OVERFLOW
TimerOv		dc.w	JTimerOv        ;TIMER OVERFLOW

TimerCh7	dc.w	JTimerCh7       ;TIMER CHANNEL 7
TimerCh6	dc.w	JTimerCh6       ;TIMER CHANNEL 6
TimerCh5	dc.w	JTimerCh5       ;TIMER CHANNEL 5
TimerCh4	dc.w	JTimerCh4       ;TIMER CHANNEL 4
TimerCh3	dc.w	JTimerCh3       ;TIMER CHANNEL 3
TimerCh2	dc.w	JTimerCh2       ;TIMER CHANNEL 2
TimerCh1	dc.w	JTimerCh1       ;TIMER CHANNEL 1
TimerCh0	dc.w	JTimerCh0       ;TIMER CHANNEL 0

RTI		dc.w	JRTI            ;REAL TIME INTERRUPT

IRQ		dc.w	JIRQ            ;IRQ OR KEY WAKE UP D
XIRQ		dc.w	JXIRQ           ;XIRQ
SWI		dc.w	JSWI            ;SWI
Illop		dc.w	JIllop          ;RESERVED
COPFail		dc.w	JCOPFail        ;COP FAILURE RESET
ClockFail	dc.w	JClockFail      ;COP CLOCK MONITOR FAIL RESET
PowerOn		dc.w	BootStart       ;RESET





