;AUDIO.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*June 7, 2000           V3.02           Single Turret Safe
*
*Processor: MC68HC912D60
*
*Author: Exequiel Rarama
********************************************************************************
;
; AUDIO ROUTINES
; ==============
;
;OC Variables are define in "AUDIO.ASM" file
OC7mask1        equ     %10000000       ;IOS7 = 1, Bit 7 as output compare
OC7mask2        equ     %10000000       ;C7I = 1, Enable Interrupt
OC7mask3        equ     %01000000       ;OM7 = 0, OL7 = 1, toggel OC output line
OC7flag         equ     %10000000       ;C7F = 1 to clear Interrupt flag

OC6mask1        equ     %01000000       ;IOS6 = 1, Bit 6 as output compare
OC6mask2        equ     %01000000       ;C6I = 1, Enable Interrupt
OC6mask3        equ     %00010000       ;OM6 = 0, OL6 = 1, toggel OC output line
OC6flag         equ     %01000000       ;C6F = 1 to clear Interrupt flag

;
OM7             equ     %10000000
OL7             equ     %01000000

Audio_ctrl	equ	%10000000	

;Audio Variables
;audio_timer     ds      1               ;audio tone duration timer
;audio_ptr       ds      2               ;pointer to audio tone table
;audio_period    ds      2               ;audio tone period
;
;rep_addr        ds      2               ;repetition address
;rep_count       ds      1               ;repetition counter
;
;
; Initialization
; --------------
;
audio_init
        movw    #$1ff,audio_period
        movb    #$ff,audio_timer

        ldx     #pwr_on_tone            ;power-on tone
        jsr     set_audio

;
        rts
;
;----------
;
set_audio
        sei
        stx     audio_ptr
        clr     audio_timer
        cli
        rts
;
;------------
; Check Audio
;------------
check_audio
        ldaa    audio_timer             ;decrement audio duration timer
        beq     aud05                   ;  unless already timed out (0)
        inca                            ;  OR infinite duration (FF)
        beq     audex
        dec     audio_timer
        bne     audex

aud05
        ldx     audio_ptr               ;get pointer to audio table
        ldaa    0,x                     ;get next tone duration time & skip
        staa    audio_timer             ;  if not a repetition indicator
        bne     aud20                   ;  (0 = repetition indicator)
;
        ldaa    1,x                     ;skip if end of repetition (2nd byte
        beq     aud10                   ;  = 0)
        staa    rep_count               ;else, start of repetition:  store
        inx                             ;  number of repetitions & starting
        inx                             ;  address
        stx     rep_addr
        stx     audio_ptr
        bra     audex
;
aud10
        ldaa    rep_count
        inca
        beq     aud15
        dec     rep_count               ;end of repetition: skip if repetition
        beq     aud50                   ;  counter has counted down
;
aud15
        ldx     rep_addr                ;else, restore 'start of repetition'
        stx     audio_ptr               ;  address
        bra     audex
;
aud20
        ldd     1,x                     ;set new audio tone period & duration
        std     audio_period            ;  audio is off (=0)
        beq     aud30
;
        sei
        addd    TC6
        std     TC6
        cli

	bset	PORTG,audio_ctrl	;Toggel Audio signal on

;        bclr    TCTL1,OM7               ;OM7=0
;        nop
;        nop
;        bset    TCTL1,OL7               ;OL7=1, enable audio control line

        bra     aud40
;
aud30
        bclr    TMSK1,audio_ctrl        ;turn off tone

;       bclr    TCTL1,OL7               ;OL7=0
;       nop
;       nop
;       bset    TCTL1,OM7               ;OM7=1 disable audio control line

;
aud40
        inx                             ;increment and save audio table
;
aud50
        inx                             ;  pointer
        inx
        stx     audio_ptr
;
audex
        rts
;
;----------------------------------------------------------------------------
pwr_on_tone
        db      20,20,20        ;       db      80,50,0
        db      20,20,20        ;       db      80,50,0
        db      20,40,$50       ;       db      80,40,$64
        db      $ff,0,0

pb_tone
        db      140,40,0
        db      240,30,255
        db      $ff,0,0
