;MAIN.ASM
;MC68HC912D60 MAIN ROUTINE
;REGD60.INC CONTAINS ALL REGISTERS
;
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*May 17, 2000            V1.00           Boot Flash for D60
*Author: Exequiel Rarama
********************************************************************************

; -----------------------
; Coin Dispenser - Main Routine
; -----------------------
$BASE 0AH

        INCLUDE "REGD60.INC"                ;register block addresses

;RAM     equ     $0800           ;68HC812A4 internal RAM
STACK   equ     $0800           ;Stack at top of internal ram

EEPROM  equ     $0c00           ;68HC912B32 internal EEPROM
FLASH   equ     $8000           ;68HC912B32 internal FLASH memory

FlashStart32    equ     $8000
FlashStart28    equ     $1000
BootFlash       equ     $e000
FlashSize32     equ     32768
FlashSize28     equ     28672
BootBlkSize     equ     8192

;CodeStart       equ     $8000   ;Start of Code

;SCI Variables
scimask         equ     %00101100       ;RIE - SCI Interrupt enable
scimask1        equ     $0c             ;TE - Transmit Enable, RE - Receiver Enable
RDRFflag        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
;MCLK=8Mzh
BAUD110         equ     4545    ;(baud) 110 baud with 16 Mhz crystal
BAUD300         equ     1667    ;(baud) 300 baud with 16 Mhz crystal
BAUD600         equ     833     ;(baud) 600 baud with 16 Mhz crystal
BAUD1200        equ     417     ;(baud) 1200 baud with 16 Mhz crystal
BAUD2400        equ     208     ;(baud) 2400 baud with 16 Mhz crystal
BAUD4800        equ     104     ;(baud) 4800 baud with 16 Mhz crystal
BAUD9600        equ     52      ;(baud) 9600 baud with 16 Mhz crystal
BAUD14400       equ     35      ;(baud) 14400 baud with 16 Mhz crystal
BAUD19200       equ     26      ;(baud) 19200 baud with 16 Mhz crystal
BAUD38400       equ     13      ;(baud) 19200 baud with 16 Mhz crystal
;
;Boot Flash Variables
S0REcType       equ     '0'     ;ASCII '0' used as S0 record type indicator
S1REcType       equ     '1'     ;ASCII '1' used as S1 record type indicator
S9REcType       equ     '9'     ;ASCII '9' used as S9 record type indicator

us22            equ     175
us11            equ     88
ms100           equ     $30d4   ;$61a8
ms1             equ     $9c3
TEN             equ     $80

ENPE            equ     %0001
LAT             equ     %0010
ERAS            equ     %0100
SVFP            equ     %1000
MaxProgPulses   equ     50      ;maximum number of programming pulses.
MaxErasePulses  equ     5       ;maximum number of erase pulses

ByteWord32      equ     16384   ;FlashSize32/2
ByteWord28      equ     14336   ;FlashSize28/2

;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
        org     $200    ;BootFlash
;
BootStart                       ;This is where the RESET vector points to
        sei                     ;Disable Any interrupts

;Initialize Stack
        lds     #STACK          ;initialize stack pointer
        clr     COPCTL                  ;Disable watchdog timer

;Initialize Serial Communication Interface
        movb    #scimask1,SC0CR2        ;enable SCI 0 rcvr. & xmtr.
        movb    #0,SC0CR1
;
        movw    #BAUD9600,SC0BDH        ;Set baud rate to 9600
        ldab    SC0SR1                  ;read register to clear flag RDRF
        ldab    SC0DRL                  ;read receive buffer

        include "EEFLASH.ASM"

         org     RAM

;Ram Variables
RecType         ds      1
DataBytes       ds      1
LoadAddr        ds      2
SRecData        ds      65

ProgPulses      ds      1
PMarginFlag     ds      1
EMarginFlag     ds      1
NumPulses       ds      1
NotErasedFlag   ds      1
SRecBytes       ds      1
CheckSum        ds      1
temp            ds      1
CURPAGE         ds      1
Ramcode         equ     temp+1

code            equ     *
