*FILENAME:  fmsload.asm (run convert for 1K; offset 63)
*BOOTSTRAP DOWNLOADER PROGRAM
*Programs an S-record file into internal EEPROM, after doing bulk erase,
*via SCI at 9600 baud; for 8MHz 68HC711D0
*24 Aug 2000


rbase		equ     $0000           ;power up register base address
STACK		equ	$00FF		;put stack at top of ram
RAM             equ     $40             ;Beginning of Ram
DELAY           equ     $E00           ;Approx. 10 ms for 8 MHz clock rate

;DELAY           equ     $ffff           ;Approx. 5 ms for 8 MHz clock rate
*
* standard registers equates
*
porta   equ     $00       ;input/output port
portb   equ     $04       ;output port
portd   equ     $08       ;portd, serial communications
ddrd    equ     $09       ;data direction register, portd
tcnt    equ     $0e       ;timer count
toc1    equ     $16       ;output compare, register 1 
toc2    equ     $18       ;output compare, register 2
tflg1   equ     $23       ;main timer interrupt flags
tmsk2   equ     $24       ;timer interrupt mask register, prescaler
baud    equ     $2b       ;sci baud rate control
sccr2   equ     $2d       ;sci control register 2
scsr    equ     $2e       ;sci status register
scdr    equ     $2f       ;sci data, read (rdr) and write (tdr)
adctl   equ     $30       ;a/d control register, not used
adr1    equ     $31       ;a/d channel 1 register, not used
bprot   equ     $35       ;EEPROM block protect register
option  equ     $39       ;system options   
pprog   equ     $3b       ;EEPROM program control register
hprio   equ     $3c       ;misc. control register
config  equ     $3f       ;system configuration register

opts  	equ	%00011011	;a/d off, stop delay, clock monitor, 1 s COP

tmask	equ	%00000011	;timer prescale mask: E/16    
onmsk	equ	%10000000	;mask for timer flag, on time over
offmsk	equ	%11000000	;mask for timer flag, off time over

bdmsk12	equ	%00110011	;1200 baud with 8 MHz crystal
bdmsk96	equ	%00110000	;9600 baud with 8 MHz crystal
bd9msk12 equ    %00100101       ;1200 baud with 9.8304 MHz crystal

ptdmsk	equ 	%00000010	;portd data direction: input, except txd
sc2msk2	equ	%00001100	;mask to enable both transmit and receive
tdremsk	equ	%10000000	;transmitter ready flag
rdrfmsk	equ	%00100000	;receiver ready flag

*        PAGE0
	org $40

TEMP1:		rmb	1	;note that variables overwrite boot code
TEMP2:		rmb	1
check_flag	rmb	1


*        CODE
	org $40

init:
        sei
        lds     #STACK          ;initialize stack

        ldaa    #04
        staa    config

        ldaa    #$65
        staa    hprio           ;Place micro into Expanded mode

	ldaa	#opts		;load in system options
	staa	option

;        ldaa    #bd9msk12        ;baud = 1200 for 9.8304Mhz crystal
       ldaa    #bdmsk96        ;baud = 9600 for 8Mhz crystal
	staa	baud
	ldaa	#sc2msk2	;disable interrupts, enable rcvr. & xmtr.
	staa	sccr2
	ldaa	#$30
	staa	check_flag

M0:
	bsr	GetChar		;look for S record
        cmpa    #'S'
	bne	M0
		
	bsr	GetChar
        cmpa    #'1'            ;if not S1 record then
	beq	Load1

        cmpa    #'9'            ;if S9 record then
	bne	M0
Load9:
	bsr	GetChar
	bra	Load9	

Load1:
	bsr	GetByte		;S1 record so get byte count
	tab
	subb	#3		;adjust for address and checksum bytes
	bsr	GetAddress	;get address
	dey			;adjust address for L1B loop
	bra	L1B

L1B:
	bsr	GetByte		;repeat
	iny			;  get a byte and write it to EEPROM
        bsr     Write           ;  increment EEPROM address
	decb			;  decrement # of bytes
	bne	L1B		;until all bytes in record programmed
        bra     M0              ;get next S-record

***********************************************************************
*Procedure Definitions:
***********************************************************************

SendChar:

*  Transmits a byte, contained in register A, to the serial device via the SCI.

	pshb
SC1:
	ldab	scsr	;wait for transmit data register empty (TDRE)
	bpl	SC1
	pulb
	stab	scdr	;send byte
	rts


*
*  Fetches one character from the SCI, 
*  and returns it in register A.  

GetChar:

	pshb
	
GC1:        
        ldaa    scsr            ;get sci flags
	anda	#rdrfmsk	;mask off irrelevant bits
        beq     GC1	        ;loop until character found
	ldaa	scdr		;get character
        
	ldab	check_flag
	bsr	SendChar	;send back the result of programming
	pulb
	rts

*  Converts 2 hex characters to a single byte value, 
*  and returns it in register A.

GetByte:
GB1:
	bsr	GetChar
	bsr	Hex2Bin
	lsla
	lsla
	lsla
	lsla
	staa	TEMP1
	bsr	GetChar
	bsr	Hex2Bin
	oraa	TEMP1
	rts


Hex2Bin:

*  Converts an ASCII hex character in register A
*  to a binary nibble and returns it in register A.

        cmpa    #'9'
	bls	HEX
	adda	#9
HEX:	anda	#$f
	rts

GetAddress:

* Extracts load address and returns it in register Y.

	pshb			;preserve byte count
	bsr	GetByte
	staa	TEMP2
	bsr	GetByte
	tab
	ldaa	TEMP2
	xgdy
	pulb
	rts	
	

Write:

*  Writes the value contained in register A to the address pointed to
*  by register Y.
	pshb			;preserve byte count

*	ldab	#$40		;turn on led d2
*	stab	porta	

	cmpa	0,Y
	beq	Rt
	staa	0,Y

        ldx	#DELAY
D1:
	dex
	bne	D1
	

	cmpa    0,Y             ; check programming
        beq     Rt  
   
        ldaa    #$35
        staa    check_flag
	
Rt:	
*	clr	porta		;turn off led d2
	pulb
	rts

        END
