*FILENAME:  FXLOAD.ASM (run convert for 1K; offset 65535)
*68HC11 BOOTSTRAP DOWNLOADER FOR EXPANDED MODE SYSTEMS
*Writes s-record file to any combination of internal/external EEPROM/RAM
*10 March 1998

* system addresses

rbase		equ	$1000		;power up register base address
STACK           equ     $01FF           ;put stack at top of ram
maskid		equ	$bfd4		;location of chip I.D. in bootROM

DELAY		equ	$0d00		;10 ms for 8 MHz clock rate

*
* registers
*

porta	equ	rbase+$00	;porta, multi-purpose
portb	equ	rbase+$04	;output port
portd	equ	rbase+$08	;portd, serial communications
ddrd  	equ	rbase+$09	;data direction register, portd
tcnt  	equ	rbase+$0e  	;timer count
toc1  	equ	rbase+$16	;output compare, register 1 
toc2  	equ	rbase+$18	;output compare, register 2
tflg1	equ	rbase+$23	;main timer interrupt flags
tmsk2	equ	rbase+$24	;timer interrupt mask register, prescaler
baud  	equ	rbase+$2b	;sci baud rate control
sccr2	equ	rbase+$2d	;sci control register 2
scsr  	equ	rbase+$2e	;sci status register
scdr  	equ	rbase+$2f	;sci data, read (rdr) and write (tdr)
adctl	equ	rbase+$30	;a/d control register, not used
adr1  	equ	rbase+$31	;a/d channel 1 register, not used
bprot	equ	rbase+$35	;EEPROM block protect register (68HC811E2)
option 	equ	rbase+$39	;system options  	
pprog	equ	rbase+$3b	;EEPROM program control register
hprio	equ	rbase+$3c	;misc.
config	equ	rbase+$3f	;system configuration register

opts  	equ	%00011011	;a/d off, stop delay, clock monitor, 1 s COP

tmask	equ	%00000011	;timer prescale mask: E/16    
onmsk	equ	%10000000	;mask for timer flag, on time over
offmsk	equ	%11000000	;mask for timer flag, off time over

clrmsk	equ	%11000000	;mask for clearing timer flags
bdmsk3	equ	%00110101	;300 baud with 8 MHz crystal
bdmsk12	equ	%00110011	;1200 baud with 8 MHz crystal
bdmsk96 equ	%00110000	;9600 baud with 8 MHZ crystal
ptdmsk	equ 	%00000010	;portd data direction: input, except txd
sc2msk2	equ	%00001100	;mask to enable both transmit and receive
tdremsk	equ	%10000000	;transmitter ready flag
rdrfmsk	equ	%00100000	;receiver ready flag


	org	#$ffff

	fill	$ff,1		;$FF requiured to start bootstrap comm.


TEMP1:		rmb	1	;note that variables overwrite boot code
TEMP2:		rmb	1

	org	0

init:

	ldaa	#opts		;load in system options
	staa	option

	lds	#STACK	 	;initialize stack

	ldaa	#sc2msk2	;disable interrupts, enable rcvr. & xmtr.
	staa	sccr2
	ldaa	#bdmsk96	;set baud rate to 9600
	staa	baud
	ldaa	#$30	
	staa	check_flag
	

No_EE:
	ldaa	#$66		;special test mode for external memory access
	staa	hprio		; and COP inhibit (even if enabled)


M0:
	bsr	GetChar		;look for S record
	
*	bra	M0
	


	cmpa	#'S
	bne	M0

	
	bsr	GetChar
	cmpa	#'1		;if not S1 record then
	beq	Load1

	cmpa	#'9		;if S9 record then
	bne	M0
	bsr	GetByte		;get byte count
	tab
	subb	#2
	bsr	GetAddress	;get execution address
Load9:
	bsr	GetByte		;get checksum byte (and ignore it)
	bra	Load9	

        

Load1:
	bsr	GetByte		;S1 record so get byte count
	tab
	subb	#3		;adjust for address and checksum bytes
	bsr	GetAddress	;get address
	dey			;adjust address for L1B loop
	bra	L1B

L1B:
	bsr	GetByte		;repeat
	iny			;  get a byte and write it to EEPROM
	jsr	Write		;  increment EEPROM address
	decb			;  decrement # of bytes
	bne	L1B		;until all bytes in record programmed
	bra	M0		;get next S-record


***********************************************************************
*Procedure Definitions:
***********************************************************************

SendChar:

*  Transmits a byte, contained in register A, to the serial device via the SCI.

	pshb
SC1
	ldab	scsr	;wait for transmit data register empty (TDRE)
	bpl	SC1
	pulb
	stab	scdr	;send byte
	rts


GetChar:

*  Fetches one character from the SCI, 
*  and returns it in register A.  

	pshb

GC1:
	ldaa	scsr		;get sci flags
	anda	#rdrfmsk	;mask off irrelevant bits
	beq	GC1		;loop until character found
	ldaa	scdr		;get character
	ldab	check_flag
	jsr	SendChar	;send back the result of programming
	pulb
	rts

GetByte:

*  Converts 2 hex characters to a single byte value, 
*  and returns it in register A.

GB1:
	bsr	GetChar
	bsr	Hex2Bin
	lsla
	lsla
	lsla
	lsla
	staa	TEMP1
	bsr	GetChar
	bsr	Hex2Bin
	oraa	TEMP1
	rts


Hex2Bin:

*  Converts an ASCII hex character in register A
*  to a binary nibble and returns it in register A.

	cmpa	#'9
	bls	HEX
	adda	#9
HEX:	anda	#$f
	rts

GetAddress:

* Extracts load address and returns it in register Y.

	pshb			;preserve byte count
	bsr	GetByte
	staa	TEMP2
	bsr	GetByte
	tab
	ldaa	TEMP2
	xgdy
	pulb
	rts	
	

Write:

*  Writes the value contained in register A to the address pointed to
*  by register Y.
	
	pshb			;preserve byte count
	ldab	#$2
	stab	cnt
Rewrt:
	dec	cnt
	cmpa	0,Y
	beq	C_ok
	staa	0,Y		;write byte
	cmpa	0,Y
	beq	C_ok
	jsr	Delay_10_ms
		
        cmpa    0,Y             ; check programming
        beq     C_ok
	
	ldab	cnt
	bne	Rewrt
	
        ldaa    #$35
        staa    check_flag
	bra	Rt
C_ok:   
	ldaa	#$30
	staa	check_flag
Rt:	pulb
	rts


Delay_10_ms:
	pshb
	ldx	#DELAY
D1:
	cmpa	0,Y
	beq	ExitDelay
        dex
	bne	D1
ExitDelay:
	pulb
	rts


end:    equ     *

        org     end
toggle_a        rmb     1
check_flag	rmb	1
buffer		rmb	1
cnt		rmb	1