*filename: mc11demo9.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE		REV. NO.	DESCRIPTION
*
* 4/07/99	0		Initial release
*
*
*******************************************************************************
*TECHNOLOGICAL ARTS
*MicroCore-11 Turbo Demo Software
*7 APRIL 1999
*by CARL BARNES

* System Addresses

RAM		equ	$0000
rbase		equ	$1000		;power up register base address
STACK		equ	$01FF		;put stack at top of internal ram
EEPROM		equ	$E000		;start code at last 8K boundary
*					  for compatibility with 8K & 32K units

*  Operational Parameters

_100MS		equ	25
_250MS		equ	61
_500MS		equ	125
_1SECOND	equ	250
_2SECONDS	equ	500
_3SECONDS	equ	750
_5SECONDS	equ	1250
_10SECONDS	equ	2500
_25SECONDS	equ	6250
_60SECONDS	equ	15000
_2MIN		equ	30000

* Operational Constants

TRUE		equ	$FF
FALSE		equ	$00
CR		equ	$D
LF		equ	$A
SP		equ	$20

	org	RAM

* System Variables

COMMAND		rmb	1	;used by ProcessCommand

H		rmb	1	;used in binary to decimal conversion
TO		rmb	1

DURATION	rmb	2	;used for tone generation
HALF_PERIOD	rmb	2

TIMER		rmb	2	;software timers using RTI
TIMER1		rmb	2

* Boolean Variables

COMMAND_PENDING	rmb	1	;used by ProcessCommand

CONTINUOUS	rmb	1	;flag for real-time a/d screen update

TONE_2K		equ	500	;frequencies in Hertz for tone generation
TONE_1K		equ	1000
TONE_440	equ	2272
TONE_220	equ	4545
TONE_180	equ	3000
TONE_110	equ	9090
TONE_60		equ	16666

* registers

**********************************************************************
*	PORT ASSIGNMENTS for this program

porta	equ	rbase+0		;input/output port

*	PA0	spare		;input only
*	PA1	spare		;input only
*	PA2	spare		;input only
*	PA3	spare		;input or output
*	PA4	spare		;output only
*	PA5	spare		;output only
*	PA6	SPEAKER		;output only
*	PA7	spare		;input or output
**********************************************************************

portd	equ	rbase+$08	;portd, serial communications
ddrd  	equ	rbase+$09	;data direction register, portd
oc1m	equ	rbase+$0c	;output compare 1 mask register, porta
tcnt  	equ	rbase+$0e  	;timer count
toc1  	equ	rbase+$16	;output compare register 1 
toc2  	equ	rbase+$18	;output compare register 2
toc3  	equ	rbase+$1A	;output compare register 3
toc4  	equ	rbase+$1C	;output compare register 4
tctl1	equ	rbase+$20	;timer control register
tmsk1	equ	rbase+$22	;OC/IC interrupt mask register
tflg1	equ	rbase+$23	;main timer interrupt flags
tmsk2	equ	rbase+$24	;timer interrupt mask register, prescaler
tflg2	equ	rbase+$25	;timer interrupt flag register 2
pactl	equ	rbase+$26	;real time interrupt prescaler, pulse accum.
baud  	equ	rbase+$2b	;sci baud rate control
sccr1	equ	rbase+$2c	;sci control register 1
sccr2	equ	rbase+$2d	;sci control register 2
scsr  	equ	rbase+$2e	;sci status register
scdr  	equ	rbase+$2f	;sci data, read (rdr) and write (tdr)

*Analog-to-Digital Converter

adctl	equ	rbase+$30	;a/d control register
adr1  	equ	rbase+$31	;a/d channel 1 register
adr2  	equ	rbase+$32	;a/d channel 2 register
adr3  	equ	rbase+$33	;a/d channel 3 register
adr4  	equ	rbase+$34	;a/d channel 4 register

option 	equ	rbase+$39	;system options  	
pprog	equ	rbase+$3b	;EEPROM program control register
hprio	equ	rbase+$3c	;highest priority interrupt

* Masks
opts  	equ	%10010000	;a/d on
admask1	equ	%00110000	;(adctl)continuous conversion, AD0 thru AD3
admask2	equ	%00110100	;(adctl)continuous conversion, AD4 thru AD7
tmask	equ	%01000000	;(tmsk2)no timer prescale, RTI enabled
rtimsk	equ	%00001000	;(pactl) 4.1 msec interrupt with 8 MHz xtal
tc1msk	equ	%01000000	;OC2 in toggle mode

clrmsk	equ	%11000000	;mask for clearing timer flags
bd9msk38 equ    %00100000       ;38400 baud with 9.8304 MHz crystal
ptdmsk	equ 	%00000010	;(ddrd)portd data direction: input, except txd
sc2msk2	equ	%00101100	;(sccr2)enable tx & rx and Rx Interrupt

********************************** Program *******************************

	org	EEPROM

init:
	sei			;this is where the RESET vector points

*NOTE-  The option register must be written within 64 E-cycles of reset.

	ldaa	#opts		;define system options
	staa	option

	lds	#STACK	 	;initialize stack pointer

	ldaa	#admask1	;set A/D to scan AD0 thru AD3 continuously
	staa	adctl
	ldaa	#tmask		;enable real-time interrupt (RTI)
	staa	tmsk2

	ldaa	#rtimsk		;initialize RTI rate
	staa	pactl

	ldaa	#ptdmsk		;initialize PORTD
	staa 	ddrd
	ldaa	#bd9msk38	;baud=2400
	staa	baud
	ldaa	#sc2msk2
	staa	sccr2		;enable SCI rcvr. & xmtr. & rx int.
	ldaa	scdr		;dummy read to flush receive buffer

	clr	COMMAND_PENDING
	clr	CONTINUOUS

	cli			;enable interrupts

	ldx	#TONE_440	;generate two 100 millisecond beeps @ 440 Hz
	ldab	#2
	ldy	#_100MS
	jsr	PulseXToneB

begin:

	jsr	ProcessCommand		;this is the program loop
	ldaa	CONTINUOUS
	beq	NotCont
	jsr	ShowAnalog

NotCont
	jmp	begin


***********************************************************************
*Procedure Definitions:
***********************************************************************

WaitX:
	stx	TIMER1		;delays a length of time defined by x
W1	ldx	TIMER1
	bne	W1
	rts

PulseXToneB:

* b contains number of beeps desired
* x contains tone frequency
* y contains tone duration (eg. if y=1  => duration=4.1 ms; y=255 => 1 sec)

	sty	DURATION
rpt
	jsr	EnableToneX	;tone generated via OutputCompare feature
	ldy	DURATION
	sty	TIMER
d2_1	ldy	TIMER
	bne	d2_1
	clr	tmsk1		;turn off tone
	clr	tctl1
	ldy	DURATION
	sty	TIMER
d2_2	ldy	TIMER
	bne	d2_2
	decb
	bne	rpt
	rts


ProcessCommand:

	ldaa	COMMAND_PENDING	;commands received via SCI interrupt
	cmpa	#TRUE
	beq	Process
	jmp	PCX
Process
	clr	COMMAND_PENDING	
	clr	CONTINUOUS
	jsr	PutNewLine
	ldaa	COMMAND

	cmpa	#'A
	beq	PCA
	cmpa	#'a
	beq	PCA

	cmpa	#'C
	beq	PCC
	cmpa	#'c
	beq	PCC

	cmpa	#'D
	beq	PCD
	cmpa	#'d
	beq	PCD

	cmpa	#'R
	beq	PCR
	cmpa	#'r
	beq	PCR

	cmpa	#'S
	beq	PCS
	cmpa	#'s
	beq	PCS

	cmpa	#'4
	blo	PCM
	cmpa	#'6
	bhi	PCM
	jsr	ToggleOutLine
	bra	PCX

PCM
	jsr	ShowMenu
	bra	PCX

PCA
	ldx	#M_PORTA
	jsr	SendString
	ldab	porta
	clra
	jsr	SendDecByte
	jsr	PutNewLine
	bra	PCX

PCC
	ldx	#M_CLEAR
	jsr	SendString
	clr	porta
	jsr	PutNewLine
	bra	PCX

PCD
	ldx	#M_PORTD
	jsr	SendString
	ldab	portd
	clra
	jsr	SendDecByte
	jsr	PutNewLine
	bra	PCX

PCR
	staa	CONTINUOUS	;set continuous a/d display flag
	bra	PCX

PCS
	ldx	#M_BEEP		;beep speaker (if connected to PA6)
	jsr	SendString
	jsr	PutNewLine
	ldx	#TONE_440	;generate two 100 millisecond beeps @ 440 Hz
	ldab	#2
	ldy	#_100MS
	jsr	PulseXToneB
*	bra	PCX

PCX
	rts


ToggleOutLine:

	ldab	#1		;set first bit high
	suba	#'0		;convert ASCII digit to binary number
TBL0
	aslb			;set the appropriate mask bit
	deca
	bne	TBL0
TBL1
	bitb	porta		;if designated PORTA bit is 1
	beq	TBM1		;  then make it 0
	comb
	bra	TBM0
TBM1
	orab	porta
	stab	porta
	rts
TBM0
	andb	porta
	stab	porta	
	rts


ShowMenu:
	jsr	PutDblLine
	ldx	#M_UNDLN
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_HEADER1
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_UNDLN
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_LINE1
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_LINE2
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_LINE3
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_LINE4
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_LINE5
	jsr	SendString
	jsr	PutNewLine
	ldx	#M_LINE6
	jsr	SendString
	jsr	PutDblLine	
	ldx	#M_PROMPT
	jsr	SendString
	rts

ShowAnalog:

	ldaa	#admask1
	staa	adctl

	ldx	#M_AD0
	jsr	SendString
	ldab	adr1
	clra
	jsr	SendDecByte
	ldaa	#SP
	jsr	SendByte

	ldx	#M_AD1
	jsr	SendString
	ldab	adr2
	clra
	jsr	SendDecByte
	ldaa	#SP
	jsr	SendByte

	ldx	#M_AD2
	jsr	SendString
	ldab	adr3
	clra
	jsr	SendDecByte
	ldaa	#SP
	jsr	SendByte

	ldx	#M_AD3
	jsr	SendString
	ldab	adr4
	clra
	jsr	SendDecByte
	ldaa	#SP
	jsr	SendByte

	ldaa	#admask2
	staa	adctl

	ldx	#M_AD4
	jsr	SendString
	ldab	adr1
	clra
	jsr	SendDecByte
	ldaa	#SP
	jsr	SendByte

	ldx	#M_AD5
	jsr	SendString
	ldab	adr2
	clra
	jsr	SendDecByte
	ldaa	#SP
	jsr	SendByte

	ldx	#M_AD6
	jsr	SendString
	ldab	adr3
	clra
	jsr	SendDecByte
	ldaa	#SP
	jsr	SendByte

	ldx	#M_AD7
	jsr	SendString
	ldab	adr4
	clra
	jsr	SendDecByte

	ldaa	#CR
	jsr	SendByte
	rts


HexByte2Dec:

*		Supply hex value to be converted in B register
	clra
	ldx	#100	;numerator in D, denominator in X
	idiv
*		remainder in D, quotient in X
*		B is lo-order byte
	xgdx
	stab	H	;8 bit quotient in B
	xgdx
	ldx	#10	;H=0X  TO=packed BCD
	idiv
	stab	TO
	xgdx
	aslb
	aslb
	aslb
	aslb
	orab	TO
	stab	TO
	rts

SendDecByte:

* value is in B

	clra
	jsr	HexByte2Dec
	ldaa	H
	adda	#'0
	jsr	SendByte
	ldaa	TO
	jsr	SendASCIIHex
	rts

SendASCIIHex:
*	value in A

	psha
	anda	#$F0
	lsra
	lsra
	lsra
	lsra
	cmpa	#$A
	blt	SAH1
	suba	#$A
	adda	#'A
	bra	SAH2
SAH1:
	adda	#'0
SAH2:
	jsr	SendByte
	pula
	psha
	anda	#$0F
	cmpa	#$A
	blt	SAH3
	suba	#$A
	adda	#'A
	bra	SAH4
SAH3:
	adda	#'0
SAH4:
	jsr	SendByte
	pula
	rts


SendByte:

*  Transmits a byte, contained in register A, to the serial device via the SCI.

SB1
	ldab	scsr	;wait for transmit data register empty (TDRE)
	bpl	SB1
	staa	scdr	;send byte
	rts

PutNewLine:

	ldaa	#CR
	jsr	SendByte
	ldaa	#LF
	jsr	SendByte
	rts

PutDblLine:

	ldaa	#CR
	jsr	SendByte
	ldaa	#LF
	jsr	SendByte
	ldaa	#LF
	jsr	SendByte
	rts


SendString:

*	x contains starting address of string
RV1:
	ldaa	0,X		;$FF denotes end of string
	cmpa	#$FF
	beq	RVX
	jsr	SendByte
	inx
	bra	RV1
RVX:
	rts	


EnableToneX:

	sei			;tone generation done via OutputCompare
	stx	HALF_PERIOD
	ldaa	#tc1msk
	staa	tctl1
	staa	tflg1
	staa	tmsk1
	cli
	rts


*******************************************************************************
*  Interrupt Routines
*******************************************************************************

* Real-time Interrupt Routine

RealTimeInt:

RTI_1
	ldx	TIMER
	beq	RTI_2
	dex
	stx	TIMER
RTI_2
	ldx	TIMER1
	beq	RTI_3
	dex
	stx	TIMER1
RTI_3
	ldaa	#%01000000		;clear real-time interrupt flag
	staa	tflg2
	rti

*  SCI Input Interrupt Handler

*  Gets bytes from SCI.  Sets COMMAND_PENDING flag.

SerInputInt:

	ldaa	scsr		;clear RDRF
	ldaa	scdr
	staa	COMMAND
	ldaa	#TRUE
	staa	COMMAND_PENDING
SIIX:
	rti


*  Output Compare Interrupt Handler

OC2Int
	ldd	HALF_PERIOD
	addd	toc2
	std	toc2
	ldx	#rbase
	bclr	$23,x $bf
	rti

*******************************************************************************
* Messages

M_LINE1		fcc	'A  => SHOW PORT A STATUS'
		fcb	$ff
M_LINE2		fcc	'C  => CLEAR PORT A OUTPUTS'
		fcb	$ff
M_LINE3		fcc	'D  => SHOW PORT D STATUS'
		fcb	$ff
M_LINE4		fcc	'R  => SHOW REAL-TIME ANALOG VALUES'
		fcb	$ff
M_LINE5		fcc	'S  => BEEP SPEAKER (CONNECT TO PA6)'
		fcb	$ff
M_LINE6		fcc	'4 TO 6 => TOGGLE THE SELECTED PORTA OUTPUT'
		fcb	$ff
M_PROMPT	fcc	'?'
		fcb	$ff
M_HEADER1	FCC	' MICROCORE-11 DEMO PROGRAM COMMAND MENU'
		FCB	$FF
M_UNDLN		FCC	'_________________________________________'
		FCB	$FF
M_AD0		fcc	'AD0='
		fcb	$ff
M_AD1		fcc	'AD1='
		fcb	$ff
M_AD2		fcc	'AD2='
		fcb	$ff
M_AD3		fcc	'AD3='
		fcb	$ff
M_AD4		fcc	'AD4='
		fcb	$ff
M_AD5		fcc	'AD5='
		fcb	$ff
M_AD6		fcc	'AD6='
		fcb	$ff
M_AD7		fcc	'AD7='
		fcb	$ff
M_PORTA		fcc	'PORTA='
		fcb	$ff
M_PORTD		fcc	'PORTD='
		fcb	$ff
M_CLEAR		FCC	'PORTA OUTPUTS CLEARED'
		FCB	$FF
M_BEEP		FCC	'>>> BEEP! <<<'
		FCB	$FF


*******************************************************************************

	org	$FFD6

*  Interrupt and reset vectors.

SCI_VECT	FDB	SerInputInt
SPI_VECT	FDB	init
PAI_VECT	FDB	init
PAO_VECT	FDB	init
TOF_VECT	FDB	init

TOC5_VECT	FDB	init
TOC4_VECT	FDB	init
TOC3_VECT	FDB	init
TOC2_VECT	FDB	OC2Int
TOC1_VECT	FDB	init
TIC3_VECT	FDB	init
TIC2_VECT	FDB	init
TIC1_VECT	FDB	init

RTI_VECT	FDB	RealTimeInt
IRQ_VECT	FDB	init
XIRQ_VECT	FDB	init
SWI_VECT	FDB	init
TRAP_VECT	FDB	init
COP_FAIL_VECT	FDB	init
COP_CMF_VECT	FDB	init
RESET_VECT	FDB	init
