// filename ******** Main.C ************** 
// NanoCore12DX example using hardware timer to blink LEDs on Docking Module    
// TCNT increments at a fixed rate
// PT0 and PT1 are outputs to LEDs
// original by Jonathan W. Valvano 7/14/07
// modified for NanoCore12DXC32 by Carl Barnes  5/27/2014
// [The original version of this example] accompanies the books
//   "Embedded Microcomputer Systems: Real Time Interfacing",
//         Thomson Engineering, copyright (c) 2006,
//   "Introduction to Embedded Microcomputer Systems: 
//    Motorola 6811 and 6812 Simulation", Thomson, copyright (c) 2002

// Copyright 2007 by Jonathan W. Valvano, valvano@mail.utexas.edu 
//    You may use, edit, run or distribute this file 
//    as long as the above copyright notice remains
#include <mc9s12c32.h>

void main(void) {
  PLL_Init();
  Timer_Init();
  DDRT |= 0x3;    // PT0 and PT1 outputs drive LEDs D2 and D3
  PTT |= 0x01;
  for(;;) {
     Timer_Wait1ms(100);   // 0.1 sec wait
     PTT ^= 0x03;       // flashes D2 and D3 alternately at 5 Hz
  } 
}
