// filename ******** Main.C ************** 
// MC9S12C32 not gate example   
// PT0 is output to LED
// PT0 high turns on LED
// PAD07 is input from switch
// PAD07 is zero if switch pressed

//  This example accompanies the books
//   "Embedded Microcomputer Systems: Real Time Interfacing", 
//     Thomsen, copyright (c) 2006,
//   "Introduction to Embedded Microcomputer Systems: 
//    Motorola 6811 and 6812 Simulation", Brooks-Cole, copyright (c) 2002,
//    Jonathan W. Valvano 3/17/07
//    revised 12/22/2009  Carl Barnes, www.technologicalarts.com

// You may use, edit, run or distribute this file 
//    as long as the above copyright notices remain

#include <hidef.h>      /* common defines and macros */
#include <mc9s12c32.h>     /* derivative information */
#pragma LINK_INFO DERIVATIVE "mc9s12c32"



void main(void) {
  DDRT |= 0x01;    // PT0 is output to LED
  DDRAD &= ~0x80;  // PAD07 is input from switch
  ATDDIEN |= 0x80; // enable AD digital input driver  

  for(;;) {
    if(PTAD&0x80){
      PTT |= 0x01;  // LED on if switch not pressed
    }else{
      PTT &= ~0x01;  // LED off if switch is pressed
    }
  }
}
