;HardwareTest.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*April 18, 2005		1.00		Initial release
*
*Author: Exequiel Rarama for the NanoCORE12MAX
*******************************************************************************
;Compiled using Codewarrior
;
; ---------------------------
; Demo - HardwareTest Routine
; ---------------------------

	include "C32Regs.INC"

;Public Function
	XDEF HardwareTestGo
	XDEF HardwareTestInit
	XDEF HardwareReady

;Public Variables
	XDEF hardware_state
	XDEF testFlag

;Public Tones

;External Function
	XREF SerOutput0
	XREF OutStr0	

	XREF SendDecByte		;Hex to Decimal conversion


;External Variables

	XREF adflag

DataSec:SECTION
Var		ds	3
hardware_state	ds	2
count		ds	1
Error		ds	1
testFlag	ds	1
PassFailFlag	ds	1

;

PUPAE		equ	%00000001		;Port A pullup
PUPBE		equ	%00000010
PUPEE		equ	%00010000
PUPKE		equ	%10000000

switch		equ	%01000000		;Port A bit 6

;***********************************************************************************************
NON_BANKED:SECTION
;
HardwareTestInit				;Testing the Hardware ports
	bset	PUCR,PUPAE+PUPBE+PUPEE+PUPKE	;Enable all pull up's

	movb	#$FF,PERT
	movb	#$FF,PERS
	movb	#$FF,PERM
	movb	#$FF,PERP
	movb	#$FF,PERJ
	movb	#$FF,PERAD

	movw	#HardwareReady,hardware_state
	clr	testFlag
	clr	PassFailFlag

goEx
	rts

HardwareReady
	rts


HardwareTestGo
	movw	#WaitForChar,hardware_state
;	ldx	#WarningMSG1
;	jsr	OutStr0

	ldx	#WarningMSG2
	jsr	OutStr0
	movb	#1,testFlag

	clr	PassFailFlag
	rts

WaitForChar
	ldaa	testFlag
	bne	WaitForCharEx

	movw	#HardwareTestADT,hardware_state
WaitForCharEx
	rts

;----------------------------------------------------------------------------------------------
;H2 header
;Port A <=> Port B

;H1 header
;Port U <=> Port S
;Port T <=> Port AD
;Port P <=> Port E special case where PP5 <-> PE7 and PE0,PE1 are i/p only

;Note: Port A,B,E do not have dedicated Input Port register

HardwareTestADT
;Initialize Analog To Digital
	movb	#$00,ATDCTL2	        ;enable ATD
	movb	#$00,ATDCTL3	        ;8 Channels ATD result
	movb	#$00,ATDCTL4		;Select Sample rate
	movb	#$00,ATDCTL5		;Select 8 channel mode, Continuous scan
	movb	#1,adflag

;Start checking on Port AD driving T
	ldx	#TestMSG5
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRAD	;make Port AD o/p
	movb	#$00,DDRT	;make Port T i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortT20

CheckPortT10
	lsl	Var

CheckPortT20
	dec	Var+1
	beq	CheckPortTDone

	movb	Var,PTAD
	movb	Var,PTAD

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTT
	ldab	PORTT
	cmpb	Var
	beq	CheckPortT10

	ldx	#Error2
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PORTT
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortT10	;Go continue the test

CheckPortTDone
	ldaa	Error
	beq	CheckPortTDoneEx10

	ldx	#Error7
	jsr	OutStr0
	bra	CheckPortTDoneEx

CheckPortTDoneEx10
	ldx	#TestMSG3
	jsr	OutStr0

CheckPortTDoneEx
	movw	#HardwareTestTAD,hardware_state
	rts

;----------------------------------------------------------------------------------------------
HardwareTestTAD
;Start checking on Port T driving AD
	movb	#$FF,ATDDIEN1		;Enable ATD channel as Digital input

	ldx	#TestMSG4
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRT	;make Port T o/p
	movb	#$00,DDRAD	;make Port ADL i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortAD20

CheckPortAD10
	lsl	Var

CheckPortAD20
	dec	Var+1
	beq	CheckPortADDone

	movb	Var,PORTT
	movb	Var,PORTT

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PTAD
	ldab	PTAD

	cmpb	Var
	beq	CheckPortAD10

	ldx	#Error2
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PTAD
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortAD10	;Go continue the test

CheckPortADDone
	ldaa	Error
	beq	CheckPortADDoneEx10

	ldx	#Error6
	jsr	OutStr0
	bra	CheckPortADDoneEx

CheckPortADDoneEx10
	ldx	#TestMSG3
	jsr	OutStr0

CheckPortADDoneEx
	movb	#$80,ATDCTL2	        ;enable ATD
	movb	#$40,ATDCTL3	        ;8 Channels ATD result
	movb	#$60,ATDCTL4		;Select Sample rate
	movb	#$B0,ATDCTL5		;Select 8 channel mode, Continuous scan
	movb	#$00,ATDDIEN1		;Disable ATD channel as Digital input
	clr	adflag

	movw	#HardwareTestME,hardware_state
	rts

;---------------------------------------------------------------------------------------------
HardwareTestME
;Start checking on Port M bit 0 and 1 driving Port E bit 0 and 1
	ldx	#TestMSG6
	jsr	OutStr0

	clr	Error
	movb	#$3,DDRM	;make Port Q o/p

	clr	PORTM
	clr	Var

	ldab	PORTE
	andb	#%0011		;Masked off bit 0 and 1
	cmpb	#%0000		;check if Zero
	beq	CheckBit0	

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTE
	andb	#%11
	jsr	SendDecByte	;Convert Value
	inc	PassFailFlag	;Error increment flag

	clr	Error

CheckBit0
	movb	#1,PORTM	;Make Port M bit 0 and Drive E
	movb	#1,Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTE
	andb	#%0011		;Masked off bit 0 and 1
	cmpb	#%0001		;check if Zero
	beq	CheckBit1

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTE
	andb	#%11
	jsr	SendDecByte	;Convert Value

	ldx	#Error4
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

CheckBit1
	ldaa	Error
	bne	CheckBitE1	

	ldx	#TestMSG3	;Send 'PASS' messages
	jsr	OutStr0

CheckBitE1
	movb	#2,PORTM	;Make bit 1 high and Drive E
	movb	#2,Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTE
	andb	#%0011		;Masked off bit 0 and 1
	cmpb	#%0010		;check if Zero
	beq	TestPortM

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTE
	andb	#%0011
	jsr	SendDecByte	;Convert Value

	ldx	#Error5
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

TestPortM			
	ldaa	Error
	bne	PortM2P5	

	ldx	#TestMSG3	;Send 'PASS' messages
	jsr	OutStr0

PortM2P5			;Test Port M bit 2 driving Port P bit 5
	ldx	#TestMSG17
	jsr	OutStr0

	clr	Error

	movb	#%0000100,DDRM	;make Port M bit 2 o/p to drive Port P bit 5
	clr	DDRP		;Make Port P as input

	clr	PORTM		;Set PORTM low
	clr	Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTP		;Read PORTP
	andb	#%00100000
	cmpb	#0
	beq	PortM2P5H	;Now go check PORTP high

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTP
	andb	#%00100000
	jsr	SendDecByte	;Convert Value

	ldx	#Error15
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortM2P5H			;Checking PORTP high
	ldaa	Error
	bne	PortM2P5H_10	

	ldx	#TestMSG3	;Send 'PASS' messages
	jsr	OutStr0

PortM2P5H_10
	ldx	#TestMSG18
	jsr	OutStr0

	clr	Error

	ldab	#%00000100	;Drive Port M bit 2 high
	stab	PORTM
	stab	Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTP		;Read Port P bit 5 
	andb	#%00100000
	cmpb	#%00100000
	beq	PortP5M2	;Now reverse the PORT

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTP		;Read Port P bit 5 
	andb	#%00100000
	jsr	SendDecByte	;Convert Value

	ldx	#Error8
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortP5M2
	ldaa	Error
	bne	PortP5M2_10

	ldx	#TestMSG3	;Send 'PASS' messages
	jsr	OutStr0


PortP5M2_10
	ldx	#TestMSG19
	jsr	OutStr0

	clr	Error

	clr	DDRM		;make Port M as input
	nop
	movb	#%00100000,DDRP	;make Port P bit 5 o/p to drive Port M bit 2

	clr	PORTP
	clr	Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTM		;Check if PORTM bit 2 is lo
	andb	#%00000100
	cmpb	#0
	beq	PortP5M2H	;Go drive Port P bit 5 hi

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTM
	andb	#%00000100
	jsr	SendDecByte	;Convert Value

	ldx	#Error9
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortP5M2H
	ldaa	Error
	bne	PortP5M2_10

	ldx	#TestMSG3	;Send 'PASS' messages
	jsr	OutStr0

PortP5M2H_10
	ldx	#TestMSG20
	jsr	OutStr0

	clr	Error

	bset	PORTP,%00100000		;Drive PORTP bit 5 hi
	bset	Var,%00100000

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTM		;Check if PORTM bit 2 is lo
	andb	#%00000100
	cmpb	#%00000100
	beq	PortM3E4	;Go check Port M bit 3 with Port E bit 4

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTM
	andb	#%00000100
	jsr	SendDecByte	;Convert Value

	ldx	#Error9
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag


PortM3E4			;checking Port M bit 3 with Port E bit 4
	ldaa	Error
	bne	PortM3E4_10

	ldx	#TestMSG3	;Send 'PASS' messages
	jsr	OutStr0

PortM3E4_10
	ldx	#TestMSG21
	jsr	OutStr0

	clr	Error

	movb	#%00001000,DDRM	;make Port M bit 3 o/p to drive Port bit 4

	clr	PORTM		;set Port M lo
	clr 	Var	

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTE
	andb	#%00010000	;check Port E bit 4
	cmpb	#0		;check if 0
	beq	PortM3E4H	;Go drive Port E hi

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTE		;check Port E bit 4
	andb	#$10
	jsr	SendDecByte	;Convert Value

	ldx	#Error10
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortM3E4H
	ldaa	Error
	bne	PortM3E4H_10

	ldx	#TestMSG3	;Send 'PASS' messages
	jsr	OutStr0

PortM3E4H_10
	ldx	#TestMSG22
	jsr	OutStr0

	clr	Error

	ldab	#%00001000
	stab	PORTM		;Drive Port M bit 3 high
	stab	Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTE		;check Port E bit 4
	andb	#%00010000
	cmpb	#%00010000
	beq	PortM3M4

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTE
	andb	#%00010000
	jsr	SendDecByte	;Convert Value

	ldx	#Error10
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortM3M4
	ldaa	Error
	bne	PortM3M4_10

	ldx	#TestMSG3	;Send 'PASS' messages
	jsr	OutStr0

PortM3M4_10
	ldx	#TestMSG9
	jsr	OutStr0
	clr	Error

	movb	#%0001000,DDRM	;make Port M bit 3 o/p to drive Port M bit 4

	clr	PORTM		;Drive Port M bit 3 lo
	clr	Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTM		;check Port M bit 4
	andb	#%00010000
	cmpb	#%00000000
	beq	PortM3M4H

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTM
	andb	#%00010000
	jsr	SendDecByte	;Convert Value

	ldx	#Error11
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortM3M4H
	ldaa	Error
	bne	PortM3M4H_10

	ldx	#TestMSG3	;Send 'PASS' messages
	jsr	OutStr0

PortM3M4H_10
	ldx	#TestMSG10
	jsr	OutStr0
	clr	Error

	movb	#%0001000,PORTM	;make Port M bit 3 o/p to drive Port M bit 4
	movb	#%0001000,Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTM		;check Port M bit 4
	andb	#%00010000
	cmpb	#%00010000
	beq	PortM5E7	;check Port M bit 5 with Port E bit 7

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTM		;Read Port M bit 4
	andb	#%00010000
	jsr	SendDecByte	;Convert Value

	ldx	#Error11
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortM5E7
	ldaa	Error
	bne	PortM5E7_10

	ldx	#TestMSG3	;Send 'PASS' messages
	jsr	OutStr0

PortM5E7_10
	ldx	#TestMSG11
	jsr	OutStr0
	clr	Error

	movb	#%00100000,DDRM	;make Port M bit 5 o/p to drive Port E bit 7

	clr	PORTM
	clr	Var

	movb	#%0001000,Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTE		;check Port E bit 7 if 0
	andb	#%10000000
	cmpb	#0	
	beq	PortM5E7H	;check Port M bit 5 with Port E bit 7

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTE		;check Port E bit 7 
	andb	#%10000000
	jsr	SendDecByte	;Convert Value

	ldx	#Error12
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortM5E7H
	ldaa	Error
	bne	PortM5E7H_10

	ldx	#TestMSG3	;Send 'PASS' messages
	jsr	OutStr0

PortM5E7H_10
	ldx	#TestMSG12
	jsr	OutStr0
	clr	Error

	bset	PORTM,%00100000	;drive Port M bit 5 hi
	bset	Var,%00100000

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTE		;check Port E bit 7 if 0
	andb	#%10000000
	cmpb	#%10000000
	beq	PortA0B4	;check Port A bit 0 with Port B bit 4

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTE
	andb	#%10000000
	jsr	SendDecByte	;Convert Value

	ldx	#Error12
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortA0B4
	ldaa	Error
	bne	PortA0B4_10

	ldx	#TestMSG3	;Send 'PASS' messages
	jsr	OutStr0

PortA0B4_10
	ldx	#TestMSG13
	jsr	OutStr0
	clr	Error

	movb	#1,DDRA		;make Port A bit 0 output
	clr	DDRB		;make Port B inputs

	clr	PORTA		;Port A = 0
	clr 	Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTB		;check Port B bit 4 if 0
	andb	#%00010000
	cmpb	#0
	beq	PortA0B4H	;check Port A bit 0 with Port B bit 4

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTB		;Check Port B bit 4
	andb	#%00010000
	jsr	SendDecByte	;Convert Value

	ldx	#Error13
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortA0B4H
	ldaa	Error
	bne	PortA0B4H_10

	ldx	#TestMSG3	;Send 'PASS' messages
	jsr	OutStr0

PortA0B4H_10
	ldx	#TestMSG14
	jsr	OutStr0
	clr	Error

	bset	PORTA,1		;Drive Port A bit 0 hi
	bset	Var,1

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTB		;check Port B bit 4 if 1
	andb	#%00010000
	cmpb	#%00010000
	beq	PortB4A0	;check Port A bit 0 with Port B bit 4

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTB		;Check Port B bit 4
	andb	#%00010000
	jsr	SendDecByte	;Convert Value

	ldx	#Error13
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortB4A0
	ldaa	Error
	bne	PortB4A0_10

	ldx	#TestMSG3	;Send 'PASS' messages
	jsr	OutStr0

PortB4A0_10
	ldx	#TestMSG15
	jsr	OutStr0
	clr	Error

	clr	DDRA		;Make Port A inputs
	nop
	movb	#$10,DDRB	;make Port B bit 4 output

	clr	PORTB		;make Port B inputs
	clr 	Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTA		;check Port A bit 0 if 0
	andb	#%00000001
	cmpb	#0

	beq	PortB4A0H	;check Port A bit 0 with Port B bit 4

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTA		;Check Port A bit 0
	andb	#%00000001
	jsr	SendDecByte	;Convert Value

	ldx	#Error14
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortB4A0H
	ldaa	Error
	bne	PortB4A0H_10

	ldx	#TestMSG3	;Send 'PASS' messages
	jsr	OutStr0

PortB4A0H_10
	ldx	#TestMSG16
	jsr	OutStr0
	clr	Error

	bset	PORTB,$10		;Drive Port B bit 4 hi
	bset	Var,$10

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTA		;check Port A bit 0 if 1
	andb	#%00000001
	cmpb	#%00000001

	beq	ExitB		;done

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTA		;Check Port A bit 0
	andb	#%00000001
	jsr	SendDecByte	;Convert Value

	ldx	#Error14
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

ExitB
	ldaa	Error
	bne	ExitTest

	ldx	#TestMSG3
	jsr	OutStr0

ExitTest
	ldaa	PassFailFlag	;Error increment flag
	beq	ExitTest10

	ldx	#HardwareFailed
	jsr	OutStr0
	bra	ExitTest20

ExitTest10
	ldx	#HardwarePass
	jsr	OutStr0

ExitTest20
	movw	#HardwareReady,hardware_state
	ldx	#WarningMSG3
	jsr	OutStr0
	rts


littleDelay
	pshb	
	clrb
	dbne	b,*           ;delay to allow sw pin to pull up
	pulb
	rts

;----------------------------------------------------------------------------------------------
WarningMSG2	dc.b	'Press Any Key when READY',$D,$A,0
WarningMSG3	dc.b	$D,$A,'Press RESET when DONE',$D,$A,0
HardwareFailed	dc.b	$D,$A,'Port TEST = FAILED',$D,$A,0
HardwarePass	dc.b	$D,$A,'Port TEST = PASS',$D,$A,0

TestMSG3	dc.b	'Pass',$D,$A,0

TestMSG4	dc.b	$D,$A,'Test ->Port T driving Port AD',$D,$A,0
TestMSG5	dc.b	$D,$A,'Test ->Port AD driving Port T',$D,$A,0
TestMSG6	dc.b	$D,$A,'Test ->Port M driving Port E bit 0 and 1',$D,$A,0
TestMSG7	dc.b	$D,$A,'Test ->Port M bit 2,3,4,5',$D,$A,0

TestMSG9	dc.b	$D,$A,'Test ->Port M bit 3 driving Port M bit 4 low',$D,$A,0
TestMSG10	dc.b	$D,$A,'Test ->Port M bit 3 driving Port M bit 4 high',$D,$A,0

TestMSG11	dc.b	$D,$A,'Test ->Port M bit 5 driving Port E bit 7 low',$D,$A,0
TestMSG12	dc.b	$D,$A,'Test ->Port M bit 5 driving Port E bit 7 high',$D,$A,0

TestMSG13	dc.b	$D,$A,'Test ->Port A bit 0 driving Port B bit 4 low',$D,$A,0
TestMSG14	dc.b	$D,$A,'Test ->Port A bit 0 driving Port B bit 4 high',$D,$A,0

TestMSG15	dc.b	$D,$A,'Test ->Port B bit 4 driving Port A bit 0 low',$D,$A,0
TestMSG16	dc.b	$D,$A,'Test ->Port B bit 4 driving Port A bit 0 high',$D,$A,0

TestMSG17	dc.b	$D,$A,'Test ->Port M bit 2 driving Port P bit 5 low',$D,$A,0
TestMSG18	dc.b	$D,$A,'Test ->Port M bit 2 driving Port P bit 5 high',$D,$A,0

TestMSG19	dc.b	$D,$A,'Test ->Port P bit 5 driving Port M bit 2 low',$D,$A,0
TestMSG20	dc.b	$D,$A,'Test ->Port P bit 5 driving Port M bit 2 high',$D,$A,0

TestMSG21	dc.b	$D,$A,'Test ->Port M bit 3 driving Port E bit 4 low',$D,$A,0
TestMSG22	dc.b	$D,$A,'Test ->Port M bit 3 driving Port E bit 4 high',$D,$A,0


Error1		dc.b	$D,$A,'Fail ->Port A driving Port B on H2',$D,$A,0
Error2		dc.b	$D,$A,'Sent    ',0
Error3		dc.b	$D,$A,'Receive ',0

Error4		dc.b	$D,$A,'Fail ->Port M bit 0 driving Port E bit 0 High',$D,$A,0
Error5		dc.b	$D,$A,'Fail ->Port M bit 1 driving Port E bit 1 High',$D,$A,0
Error5a		dc.b	$D,$A,'Fail ->Port M driving Port E ',$D,$A,0

Error6		dc.b	$D,$A,'Fail ->Port T driving Port AD on H1',$D,$A,0
Error7		dc.b	$D,$A,'Fail ->Port AD driving Port T on H1',$D,$A,0

Error8		dc.b	$D,$A,'Fail ->Port M bit 2 driving Port P bit 5',$D,$A,0
Error9		dc.b	$D,$A,'Fail ->Port P bit 5 driving Port M bit 2',$D,$A,0

Error10		dc.b	$D,$A,'Fail ->Port M bit 3 driving Port E bit 4',$D,$A,0
Error11		dc.b	$D,$A,'Fail ->Port M bit 3 driving Port M bit 4',$D,$A,0

Error12		dc.b	$D,$A,'Fail ->Port M bit 5 driving Port E bit 7',$D,$A,0

Error13		dc.b	$D,$A,'Fail ->Port A bit 0 driving Port B bit 4',$D,$A,0
Error14		dc.b	$D,$A,'Fail ->Port B bit 4 driving Port A bit 0',$D,$A,0

Error15		dc.b	$D,$A,'Fail ->Port M bit 2 driving Port P bit 5',$D,$A,0

	END
