;MAIN.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*April 18, 2005		1.00		Initial release
*
*Author: Exequiel Rarama for the NanoCORE12MAX
*******************************************************************************
;Compiled using Codewarrior
;
; ---------------------------
; Demo - Main Routine
; ---------------------------

;C32regs.INC CONTAINS ALL REGISTERS
	include "C32Regs.INC"

;Public Function
	XDEF ResetFunc
	XDEF delay

;Public Variables
	XDEF COMMAND
	XDEF COMMAND_PENDING
	XDEF CONTINUOUS

	XDEF state
	XDEF state_timer

;External Function
	XREF RealTimeInit
	XREF audio_init

	XREF ShowAnalog
	XREF ProcessCommand

	XREF ShowMenu
	XREF set_audio

	XREF go_power
	XREF HardwareTestInit

	XREF SerInputInt0
	XREF RealTimeInt
	XREF audio_int

	XREF goReady

	XREF CANInit
	XREF CANReceive

;External Tones
	XREF pwr_on_tone
	XREF Ftone

;External Variables
	XREF audio_state
	XREF hardware_state


*  Operational Parameters
*  Operational Parameters

RAM		equ	$2000		;9S12E128 internal RAM
STACK		equ	$3F80		;Stack at below Ubug12
FLASH		equ	$4000		;Flash start address

OscFreq		equ	8000		;Enter Osc speed
initSYNR	equ	$02		; mult by synr + 1 = 3 (24MHz)
initREFDV	equ	$00		;
PLLSEL		equ	%10000000	;PLL select bit
LOCK		equ	%00001000	;lock status bit
PLLON		equ	%01000000	;phase lock loop on bit
LED		equ	%00000001	;Port P bit 0

DataSec:SECTION

* System Variables

state		ds	2
state_timer	ds	2

COMMAND		ds	1		;used by ProcessCommand
COMMAND_PENDING	ds	1		;used by ProcessCommand
CONTINUOUS	ds	1		;flag for real-time a/d screen update

***************************** Program *******************************

NON_BANKED:SECTION

ResetFunc				;This is where the RESET vector points to
	sei				;Disable Any interrupts

	movb	#$00,INITRG		;set registers at $0000 
	movb	#$39,INITRM		;move and set ram to end at $3fff 

;Initialize Stack
	lds	#STACK			;initialize stack pointer

; Initialize clock generator and PLL
	bclr	CLKSEL,PLLSEL      	;disengage PLL to system
	bset	PLLCTL,PLLON       	;turn on PLL

	movb	#initSYNR,SYNR     	;set PLL multiplier 
	movb	#initREFDV,REFDV   	;set PLL divider

	nop
	nop
	nop
	nop

	brclr	CRGFLG,LOCK,*+0    	;while (!(crg.crgflg.bit.lock==1))
	bset	CLKSEL,PLLSEL      	;engage PLL to system

	jsr	go_power		;
	jsr	RealTimeInit		;Initialize SCI and RTI

	jsr	audio_init		;Initialize bit 0 of PORTP as audio o/p
	jsr	HardwareTestInit	;Initialize for Hardware Checking
	jsr	CANInit

	clr	COMMAND_PENDING
	clr	CONTINUOUS

	cli				;unmask interrupts
	jsr	ShowMenu


;------------------------------------------------------------------------------
main					;Main Loop
	jsr	ProcessCommand		;this is the program loop
	ldaa	CONTINUOUS
	beq	NotCont
	jsr	ShowAnalog

NotCont
	ldx	state			;Process state command
	jsr	0,x

	ldx	hardware_state		;Go check hardware
	jsr	0,x

	ldx	audio_state		;Process audio command
	jsr	0,x

	bra	main


;------------------------------------------------------------------------------
;small delay
delay
	pshy
	ldy	#0

dly
	dbne	y,dly			;decrement y counter
	puly
	rts

	END