;STATES.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*April 5, 2004		1.02		- Bug fixes
*
*Author: Exequiel Rarama for the NanoCore12
*******************************************************************************
;Compiled using MCUez
;
; ---------------------------
; Demo - State Routine
; ---------------------------

	include "C32Regs.INC"

;Public Function
	XDEF ProcessCommand
	XDEF ShowAnalog
	XDEF SendDecByte		;Hex to Decimal conversion
	XDEF ShowMenu
	XDEF go_power
	XDEF goReady

;Public Variables
	XDEF d_flag

;External Function
	XREF SerOutput0
	XREF OutStr0	

	XREF set_audio
	XREF AudioOn

	XREF HardwareTestGo
	XREF delay

;External Tones
	XREF pwr_on_tone
	XREF Ftone

;External Variables
	XREF COMMAND
	XREF COMMAND_PENDING
	XREF CONTINUOUS

	XREF ad0
	XREF ad1
	XREF ad2
	XREF ad3
	XREF ad4
	XREF ad5
	XREF ad6
	XREF ad7

	XREF TIMER
	XREF TIMER1
	XREF COUNTER

	XREF audio_state
	XREF audio_delay
	XREF audio_counter

	XREF state
	XREF state_timer
	XREF testFlag

DataSec:SECTION

H		ds	1		;used in binary to decimal conversion
TO		ds	1

ad_flag		ds	1
ad_val		ds	2
DBUFR		ds	5
d_flag		ds	1

temp		ds	1


* Operational Constants

TRUE            equ     $FF
FALSE           equ     $00
CR              equ     $D
LF              equ     $A
SPACE           equ     $20

PUPAE		equ	%00000001		;Port A pullup
PUPBE		equ	%00000010
PUPEE		equ	%00010000
PUPKE		equ	%10000000

switch		equ	%01000000	;Port A bit 6

***************************** Program *******************************

NON_BANKED:SECTION

go_power
	movw	#goReady1,state
	movw	#30,state_timer		;1 second delay

	movb	#$FF,DDRT
	movb	#%11,PORTT			;Turn Led On
	rts

loop_menu
	ldx	state_timer
	bne	loopEx

	com	PORTP
	ldx	#M_UNDLN
	jsr	OutStr0

	movw	#1,state_timer

	ldx	#Ftone
	jsr	set_audio		;Blink/Sound LED/SPEAKER

loopEx
	rts

goReady1
	ldx	state_timer
	bne	loopEx

	clr	PORTT
	movw	#goReady,state

goReady
	rts

goTest
	clr	testFlag
	rts

;-----------------------------
;Choose which one to process

ProcessCommand
	ldaa	COMMAND_PENDING         ;commands received via SCI interrupt
	lbeq	PCX

	clr	COMMAND_PENDING
	clr	CONTINUOUS

	ldaa	testFlag
	bne	goTest

	ldaa	COMMAND
	staa	temp

	anda	#$df            ;simple convert to upper case (only works for alpha char)

	cmpa	#'A'
	beq	PCA

	cmpa	#'B'
	beq	PCB

	cmpa	#'C'
	lbeq	PCC

	cmpa	#'E'
	beq	PCE

	cmpa	#'F'
	lbeq	PCF

	cmpa	#'G'
	lbeq	PCG

	cmpa	#'H'
	lbeq	PCH

	cmpa	#'I'
	lbeq	PCI

	cmpa	#'J'
	lbeq	PCJ

	cmpa	#'M'
	lbeq	PCM

	cmpa	#'P'
	lbeq	PCP

	cmpa	#'Q'
	lbeq	PCQ

	cmpa	#'S'
	lbeq	PCS

	cmpa	#'R'
	lbeq	PXR

	cmpa	#'T'
	lbeq	PCT

	cmpa	#'U'
	lbeq	PCU

	cmpa	#'V'
	lbeq	PCV

	cmpa	#'Z'
	lbeq	PCZ

	ldaa	temp
	cmpa	#'0'
	lblo	PPCMenu
	cmpa	#'7'
	lbhi	PPCMenu

	jsr	TogglePLine
	rts

;----------------------------
;X register points to routine
;----------------------------

PCA
        ldx     #PPCA
        jsr     0,x             ;go execute routine
        bra     PCX
PCB
        ldx     #PPCB
        jsr     0,x             ;go execute routine
        bra     PCX

PCC
        ldx     #PPCC
        jsr     0,x             ;go execute routine
        bra     PCX

PCE
        ldx     #PPCE
        jsr     0,x             ;go execute routine
        bra     PCX

PCF
        ldx     #PPCF
        jsr     0,x             ;go execute routine
        bra     PCX


PCG
;	ldx	#M_DAC
        jsr     OutStr0

;	jsr	DacOut
        bra     PCX

PCH
        ldx     #PPCH
        jsr     0,x             ;go execute routine
        bra     PCX

PCI
        ldx     #PPCI
        jsr     0,x             ;go execute routine
        bra     PCX

PCJ
        ldx     #PPCJ
        jsr     0,x             ;go execute routine
        bra     PCX


PCM
        ldx     #PPCM
        jsr     0,x             ;go execute routine
        bra     PCX

PCP
        ldx     #PPCP
        jsr     0,x             ;go execute routine
        bra     PCX

PCQ
        ldx     #PPCQ
        jsr     0,x             ;go execute routine
        bra     PCX

PCS
        ldx     #PPCS
        jsr     0,x             ;go execute routine
        bra     PCX
PCT
        ldx     #PPCT
        jsr     0,x             ;go execute routine
        bra     PCX

PCU
        ldx     #PPCU
        jsr     0,x             ;go execute routine
        bra     PCX

PXR
        ldx     #PPCR
        jsr     0,x             ;go execute routine
        bra     PCX

PCV
;	ldx	#CheckExternalRAM
        jsr     0,x             ;go execute routine
        bra     PCX

PCZ
        ldx     #HardwareTestGo
        jsr     0,x             ;go execute routine
        bra     PCX

PCX
PCXX
        RTS
;----------------------------------------------

PPCA
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTA
        jsr     OutStr0

        ldab    PORTA
        clra
        jsr     SendDecByte	;Display PORTA value

	lbra	PCXX

PPCB
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTB
        jsr     OutStr0

        ldab    PORTB
        clra
        jsr     SendDecByte

	lbra	PCXX

PPCC
	ldx	#CrlfStr
	jsr	OutStr0	

	clr	PORTT
	ldx	#M_POFF
	jsr	OutStr0

	lbra	PPCX

PPCE
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTE
        jsr     OutStr0

        ldab    PORTE
        clra
        jsr     SendDecByte

	lbra	PCXX

PPCF
        ldx     #M_BEEP         ;beep speaker (if connected to PP0)
        jsr     OutStr0

	ldx	#CrlfStr
	jsr	OutStr0	

        ldx	#Ftone
        jsr     set_audio

	movw	#AudioOn,audio_state
	movb	#2,audio_counter	;Flash 2 times

	lbra	PCXX


PPCH
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTAD
        jsr     OutStr0

        ldab    PTIAD
        clra
        jsr     SendDecByte

	lbra	PCXX

PPCI
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTAD
        jsr     OutStr0

        ldab    PTIAD
        clra
        jsr     SendDecByte

	lbra	PCXX

PPCJ
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTJ
        jsr     OutStr0

        ldab    PTIJ
        clra
        jsr     SendDecByte

	lbra	PCXX


PPCM
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTM
        jsr     OutStr0

        ldab    PTIM
        clra
        jsr     SendDecByte

	lbra	PCXX

PPCP
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTP
        jsr     OutStr0

        ldab    PTIP
        clra
        jsr     SendDecByte

	lbra	PCXX

PPCQ
	ldx	#CrlfStr
	jsr	OutStr0	

;        ldx     #M_PORTQ
        jsr     OutStr0

;        ldab    PTIQ
        clra
        jsr     SendDecByte

	bra	PPCX

PPCS
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTS
        jsr     OutStr0
        ldab    PTIS
        clra
        jsr     SendDecByte

	bra	PPCX

PPCT
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTT
        jsr     OutStr0
        ldab    PTIT

        clra
        jsr     SendDecByte

	bra	PPCX

PPCU
	ldx	#CrlfStr
	jsr	OutStr0	

        ldx     #M_PORTU
        jsr     OutStr0

;        ldab    PTIU
        clra
        jsr     SendDecByte

	bra	PPCX


PPCMenu
        jsr     ShowMenu
        bra     PPCX

PPCR
        staa    CONTINUOUS      ;set continuous a/d display flag
        bra     PPCX

PPCX
        rts


;------------------------------------------------------------------------------
PPCL
        ldx     #M_BEEP         ;beep speaker (if connected to PP0)
        jsr     OutStr0

	ldx	#CrlfStr
	jsr	OutStr0	

        ldx	#Ftone
        jsr     set_audio

	movw	#AudioOn,audio_state
	movb	#2,audio_counter	;Flash 2 times

        rts

TogglePLine
        ldab    #1              ;number is between 0 and 7
        suba    #'0'            ;convert ASCII digit to binary number
        beq     TBL1

TBL0
        aslb                    ;set the appropriate mask bit
        dbne    a,TBL0

TBL1
        bitb    PORTT           ;if designated port bit is 1
        beq     TBM1            ;  then make it 0
        comb
        bra     TBM0

TBM1
        orab    PORTT
        stab    PORTT
        rts

TBM0
        andb    PORTT
        stab    PORTT
        rts

;Reg y contain the port address to toggle
;Reg b contain the the toggle bit

toggle_port
        movb    #8,COUNTER
        ldab    #%01

toggle
        stab    0,y
        stab    0,x

        movw    #120,TIMER
        jsr     wait

        lslb
        dec     COUNTER
        bne     toggle
        rts

wait
        pshx
        pshy

wt
        ldx     TIMER
        bne     wt
        puly
        pulx
        rts

;-----------------------------------------------------------------------------
ShowMenu
        ldx     #M_UNDLN
        jsr     OutStr0

Show_Prompt
        ldx     #M_PROMPT
        jsr     OutStr0
        rts

ShowAnalog
        inc     d_flag
        sei

        ldx     #M_AD0
        jsr     OutStr0
        ldx     #ad0
        jsr     HTOD

        ldaa    #SPACE
        jsr     SerOutput0

        ldx     #M_AD1
        jsr     OutStr0
        ldx     #ad1
        jsr     HTOD

        ldaa    #SPACE
        jsr     SerOutput0

        ldx     #M_AD2
        jsr     OutStr0
        ldx     #ad2
        jsr     HTOD

        ldaa    #SPACE
        jsr     SerOutput0

        ldx     #M_AD3
        jsr     OutStr0
        ldx     #ad3
        jsr     HTOD

        ldaa    #SPACE
        jsr     SerOutput0

        ldx     #M_AD4
        jsr     OutStr0
        ldx     #ad4
        jsr     HTOD

        ldaa    #SPACE
        jsr     SerOutput0

        ldx     #M_AD5
        jsr     OutStr0
        ldx     #ad5
        jsr     HTOD

        ldaa    #SPACE
        jsr     SerOutput0

        ldx     #M_AD6
        jsr     OutStr0
        ldx     #ad6
        jsr     HTOD

        ldaa    #SPACE
        jsr     SerOutput0

        ldx     #M_AD7
        jsr     OutStr0
        ldx     #ad7
        jsr     HTOD

        ldaa    #SPACE
        jsr     SerOutput0

        cli
        clr     d_flag

        ldaa    #CR
        jsr     SerOutput0
        rts

;------------------------------------------------------------------------------
HexByte2Dec

*               Supply hex value to be converted in B register
        clra
        ldx     #100    ;numerator in D, denominator in X
        idiv
*               remainder in D, quotient in X
*               B is lo-order byte
        xgdx
        stab    H       ;8 bit quotient in B
        xgdx
        ldx     #10     ;H=0X  TO=packed BCD
        idiv
        stab    TO
        xgdx
        aslb
        aslb
        aslb
        aslb
        orab    TO
        stab    TO
        rts

SendDecByte

* value is in B

        clra
        jsr     HexByte2Dec
        ldaa    H
        adda    #'0'
        jsr     SerOutput0
        ldaa    TO
        jsr     SendASCIIHex
        rts

SendASCIIHex
*       value in A

        psha
        anda    #$F0
        lsra
        lsra
        lsra
        lsra
        cmpa    #$A
        blt     SAH1
        suba    #$A
        adda    #'A'
        bra     SAH2
SAH1
        adda    #'0'
SAH2
        jsr     SerOutput0
        pula
        psha
        anda    #$0F
        cmpa    #$A
        blt     SAH3
        suba    #$A
        adda    #'A'
        bra     SAH4
SAH3
        adda    #'0'
SAH4
        jsr     SerOutput0
        pula
        rts



;==============================================================================
;-----------------------------------------------------------------------------
;HTOD-SUBROUTINE TO CONVERT A 16-BIT HEX NUMBER TO A 5 DIGIT DECIMAL
;This routine is taken from the HC11 manual.
;D=HEX VALUE TO BE CONVERTED
;X=ADDRESS WHERE THE NUMBER IS STORED TO BE CONVERTED

HTOD
        LDD     0,X             ;
	LDX     #10000
        IDIV                    ;
	XGDX
	ADDB    #$30
	STAB    DBUFR
	XGDX
	LDX     #1000
	IDIV
	XGDX
	ADDB    #$30
	STAB    DBUFR+1
	XGDX
	LDX     #100
	IDIV
	XGDX
	ADDB    #$30
	STAB    DBUFR+2
	XGDX
	LDX     #10
	IDIV
	ADDB    #$30
	STAB    DBUFR+4
	XGDX
	ADDB    #$30
	STAB    DBUFR+3
        LDX     #DBUFR+1        ;POINT AT DECIMAL
        BRA     P1K

P5DEC
        LDX     #DBUFR          ;POINT AT DECIMAL
	LDAA    #$30            ;CHECK FOR LEADING ZEROS
	CMPA    0,X             ;CHECK FOR 10,000S DIGIT

	BNE     P10K            ;START AT 10K DIGIT
        BSR     SKP1            ;INX AND PRINT A SPACE
	CMPA    0,X             ;CHECK FOR 1,000S

	BNE     P1K             ;START AT 1K DIGIT
        BSR     SKP1
        BSR     SKP1
	DEX
	CMPA    0,X             ;CHECK FOR 100S DIGIT

	BNE     P100            ;START AT 100 DIGIT
        BSR     SKP1
	CMPA    0,X             ;CHECK 10S DIGIT

	BNE     P10
        BSR     SKP1
	BRA     P1              ;START AT 1S DIGIT

P10K    LDAA    0,X             ;10,000 DIGIT
	PSHX
        jsr     SerOutput0
        PULX
	INX

P1K     LDAA    0,X
	PSHX
        jsr     SerOutput0
        PULX
	INX

P100    LDAA    0,X
	PSHX
        jsr     SerOutput0
	PULX
	INX

P10     LDAA    0,X
	PSHX
        jsr     SerOutput0
        PULX
	INX

P1      LDAA    0,X
        jsr     SerOutput0
        RTS

SKP1    PSHA
	INX
	LDAA    #$20
        jsr     SerOutput0
	PULA
	RTS



;==============================================================================

*******************************************************************************
* Messages
M_UNDLN		dc.b	$D,$A,$D,$A
M_HEADER	dc.b	' NanoCor12 DEMO PROGRAM COMMAND MENU V1.02',$D,$A
		dc.b	'_____________________________________________',$D,$A
		dc.b	$D,$A
;		dc.b	'A => SHOW PORT A STATUS',$D,$A
;		dc.b	'B => SHOW PORT B STATUS',$D,$A
		dc.b	'C => CLEAR PORT T OUTPUTS',$D,$A
;		dc.b	'E => SHOW PORT E STATUS',$D,$A
		dc.b	'F => FLASH LED (CONNECT TO PT0)',$D,$A

		dc.b	'H => SHOW PORT PTAD STATUS',$D,$A

;		dc.b	'J => SHOW PORT J STATUS',$D,$A
;		dc.b	'M => SHOW PORT M STATUS',$D,$A
;		dc.b	'P => SHOW PORT P STATUS',$D,$A
;		dc.b	'S => SHOW PORT S STATUS',$D,$A

		dc.b	'T => SHOW PORT T STATUS',$D,$A


		dc.b	'R => SHOW 10-bit REAL-TIME ANALOG VALUES',$D,$A
		dc.b	'0 TO 7 => TOGGLE THE SELECTED T PORT LINE',$D,$A,0

M_PROMPT	dc.b	'?',0

M_AD0		dc.b	'AD0=',0
M_AD1		dc.b	'AD1=',0
M_AD2		dc.b	'AD2=',0
M_AD3		dc.b	'AD3=',0
M_AD4		dc.b	'AD4=',0
M_AD5		dc.b	'AD5=',0
M_AD6		dc.b	'AD6=',0
M_AD7		dc.b	'AD7=',0

M_PORTA		dc.b	'PORTA=',0
M_PORTB		dc.b	'PORTB=',0
M_PORTE		dc.b	'PORTE=',0

M_PORTM		dc.b	'PORTM=',0
M_PORTP		dc.b	'PORTP=',0
M_PORTJ		dc.b	'PORTJ=',0
M_PORTS		dc.b	'PORTS=',0
M_PORTT		dc.b	'PORTT=',0
M_PORTU		dc.b	'PORTU=',0

M_PORTAD	dc.b	'PTAD=',0

M_POFF		dc.b	'PORT T CLEARED',0
M_BEEP		dc.b	'>>> LED FLASH! <<<',0

CrlfStr		dc.b	$0a,$0d,$0


	END


