' simple5.bas for NanoCore12
' connect LEDs to PT0 and PT1

' 2/20/2009 by Carl Barnes

' It is written in SBASIC.
' To compile this file, you need to invoke the following commands:

' sbasic simple5.bas /c4000 /v3800 /s3f80 /m6812 > simple5.asm
' as12 nc_echo.asm

include "reg9s12c.lib"	' PORT definitions and constants for 9S12C family of MCUs

'========================================
'Declare the variables
'========================================

declare	command
declare	n

'========================================
'Define all the subroutines first
'========================================

ShowMenu:
	print "Command Menu:"
	print "=============\n\r\"

	print "1 - Turn on LED connected to PT0"
	print "2 - Flash LED connected to PT0"
	print "3 - Alternately flash LEDs on PT0 and PT1"
	print "4 - Send out a message\n\r"

	print "Enter your choice:\n\r"
	return

DoCommand1:
	print "LED on PT0 has been activated.\n\r"
	print "Hit any key to exit...\n\r"
	pokeb	ptt,%00000001	'turn on PT0 LED
	do
	  command = inkey()
	loop until command <> 0
	pokeb ptt,0		'turn off LED
	return

DoCommand2:
	print "LED on PT0 is now flashing.\n\r"
	print "Hit any key to exit...\n\r"
	do
	  pokeb	ptt,%00000001		'turn on LED
	  for n=1 to* 65000	'waste time
	  next
	  pokeb	ptt,0		'turn off LED
	  for n=1 to* 65000	'waste time
	  next
	  command = inkey()
	loop until command <> 0
	pokeb ptt,0		'turn off LED
	return

DoCommand3:
	print "LEDs on PT0 and PT1 now blinking alternately.\n\r"
	print "Hit any key to exit...\n\r"
	do
	  pokeb	ptt,%00000001		'turn PT0 on and PT1 off
	  for n=1 to* 65000	'waste time
	  next
	  pokeb	ptt,%00000010		'turn PT1 on and PT0 off
	  for n=1 to* 65000	'waste time
	  next
	  command = inkey()
	loop until command <> 0
	pokeb ptt,0		'turn off LEDs
	return

DoCommand4:
	print "Hello World!\n\r"
	print "Hit any key to exit...\n\r"
	do
	  command = inkey()
	loop until command <> 0
	return

'========================================
'Now define the main program
'========================================

Main:

rem	Initialize the serial port

	poke  scibdh, 26	' Set for 9600 baud
	pokeb	scicr2,$0c	' Enable transceiver

rem	Initialize PortT
	pokeb	ptt,0		'make sure port T pins will be LOW
	pokeb	ddrt,%00000011	'designate PT0 and PT1 as outputs

	do
	  gosub ShowMenu
          do
               command = inkey()	'loop for user command
          loop while command = 0	'0 is returned when no character pressed
          outch command			'echo the command to the screen
	  print "\n\r"
	  command = command and $ff	'ensure upper 8 bits of command = 0
	  if command = '1'			'command 1
	    gosub DoCommand1
	    elseif command = '2'
	      gosub DoCommand2
	    elseif command = '3'
	      gosub DoCommand3
	    elseif command = '4'
	      gosub DoCommand4
	  endif
	loop
end