/*	Header file for the standard interface to the fat16 system	*/
uint16	MountDevice(void);
uint16	FileOpen(uint8 *FileName, uint32 *FilePtr, uint16 Mode);	/*	FilePtr is offset within file	*/
uint16	FileRead(uint32 *FilePtr, uint8 *ReadStr, uint16 LenReadStr);
uint16	FileWrite(uint32 *FilePtr, uint8 *WriteStr, uint16	LenWriteStr);
uint16	FileAppend(uint8 *WriteStr, uint16 LenWriteStr);
uint16	FileClose(void);
uint16	FileDelete(uint8 *FileName);
uint16	FileExists(uint8 *FileName);
uint16	FileNew(uint8 *FileName);
uint16	FileSave(void);
uint16	FileDateStr(uint8 *DateString);
uint16	FileTimeStr(uint8 *DateString);
uint16	FileSearchStr(uint8 *SearchStr, uint32 *FilePtr);

/*	FAT16 ErrorCodes	*/
#define FILE_NOT_FOUND	0x1000
#define FILE_ALREADY_EXISTS 0x1100
#define DEVICE_NOT_READY	0x2000
#define NOT_FOUND_IN_FILE	0x3000
#define FILE_NOT_OPEN	0x4000
#define NOT_WITHIN_FILE	0x5000
#define END_OF_FILE	0x6000
#define LOST_CLUSTER	0x7000
#define BAD_CLUSTER	0x8000
#define FILENAME_IS_OK	0x9000
#define END_OF_SECTOR	0xa000
#define MEDIA_FULL	0xb000
#define MEDIA_NOT_FORMATED 0xc000
#define FILE_LEN_EXCEED	0xe00
#define FILE_READ_ONLY	0xf000


