/*	Functions to manage the Directories		*/

uint16	DirectorySearch(uint8 *FileName);
uint16	SearchDirSecForFileName(uint8 *FileName, uint8	*FileAttrib);
uint16	GetDirContents(uint16 DirEntryStart, uint16 *EntryCount, uint8 *DirStrArray, uint16 SizeOfArray);
void	LoadFileData(uint8	*FileAtrib);
uint16	SearchDirSecForValidEntry(uint16 EntryCount, uint8 *NameStr, uint8 *Attribute);
uint8	DecodeAttrib(uint8 Attribute);
uint16	SaveNewDirEntry(void);
void	StoreDirEntry(uint16 DirEntryCount);

/*	Defines for Attribute bit positions	*/
#define ATT_READ_ONLY	0x01
#define ATT_HIDDEN	0x02
#define ATT_SYSTEM	0x04
#define ATT_VOL_NAME	0x08
#define ATT_DIR		0x10
#define ATT_ARCHIVE	0x20

/*	Directory Search error code	*/
#define FOUND_ENTRY			0x0001
#define NOT_IN_THIS_SECTOR		0x0002
#define NO_FURTHER_ENTRIES	0x0003
#define NOT_FOUND_IN_ROOT		0x0004
#define LIST_FULL			0x0005

