//#include <hcs12dp256.h>

#ifndef PTK
#define PTK PORTK
#endif

uint16		MMCard_InitComs(void);
void		ResetMMCARD(void);
uint16		CMDMMCARD(uint16 CMD, uint8 ValidResponse);
uint16		MMCardReadCardData(uint8 CMD);
uint16		MMCardReadCardMem(uint32 StartAdd, uint16 Length, uint8 *DataString);
uint16		MMCardWriteCardMem(uint32 StartAdd,uint16 Length, uint8 *DataString);

//#define MMCMDTimeOut	10
//#define ReadDataTimeOut	500
//#define ReadTimeOut 	0x00ff
//#define WriteTimeOut	0xfff0


/*	Data Structures for the MMCard data	*/
typedef uint8	CardID[16];	
typedef	uint8	CardSpecificData[16];
typedef	struct MMCARDType{
		CardID				CID;
		CardSpecificData	CSD;
		uint16				Flags;
		uint8				IsReady;
		};
/*	Define for flag bits	*/	
#define CardOK		0x0001
#define CardSD		0x0002
#define CardIdle 	0x0004
#define Ready		0x0008
#define Present		0x0010

/*	#defines for the commands	*/
#define CMD0	0x40
#define CMD1	0x41
#define CMD9	0x49
#define CMD10	0x4a
#define CMD13	0x4d
#define CMD16	0x50
#define CMD17	0x51
#define CMD24	0x58
#define CMD27	0x5b
#define CMD28	0x5c
#define CMD29	0x5d
#define CMD30	0x5e
#define CMD32	0x60
#define CMD33	0x61
#define CMD34	0x62
#define CMD35	0x63
#define CMD36	0x64
#define CMD37	0x65
#define CMD38	0x66
#define CMD59	0x7b

#define CMD0_CRC	0x95

#define GO_IDLE_STATE			CMD0
#define SEND_OP_COND			CMD1
#define SEND_CSD				CMD9
#define SEND_CID				CMD10
#define SEND_STATUS				CMD13
#define SET_BLOCKLEN			CMD16
#define READ_SINGLE_BLOCK		CMD17
#define WRITE_BLOCK				CMD24
#define PROGRAM_CSD				CMD27
#define SET_WRITE_PROT			CMD28
#define CLR_WRITE_PROT			CMD29
#define SEND_WRITE_PROT			CMD30
#define TAG_SECTOR_START		CMD32
#define TAG_SECTOR_END			CMD33
#define UNTAG_SECTOR			CMD34
#define TAG_ERASE_GROUP_START	CMD35
#define TAG_ERASE_GROUP_END		CMD36
#define UNTAG_ERASE_GROUP		CMD37
#define ERASE					CMD37
#define CRC_ON_OFF				CMD59

/*	MMCARD Error Codes	*/
#define MMCardNotReady		0x0001
#define MMCardNotPresent	0x0002
#define FaultFlashCard		0x0003
#define FlashCardPresent 	0x0004
#define NoFlashCard			0x0005

/*	MMCard Module Internal function/subfuction numbers for error code appendment	*/
#define MMCardInitComms		0x0100
/*	Command function error codes	*/
#define CMD_TimeOut			0x0400
#define CMD0_Error			0x4000	/*These are reserved as the CMD is use	*/
#define CMD1_Error			0x4100	/*To indicate these errors	*/
/*	ReadCard Data function ErrorCodes	*/
#define ReadData_CMDTimeOut	0x0500
#define ReadData_Error		0x5000
#define ReadData_DataTimeOut 0x5100

/*	ReadCard Memory function ErrorCodes	*/
#define ReadMem_CMDTimeOut	0x0600
#define ReadMem_Error		0x6000
#define ReadMem_DataTimeOut 0x6100

/*	WriteCard Memory function ErrorCodes	*/
#define WriteMem_CMDTimeOut	0x0700
#define WriteMem_Error		0x7000
#define WriteMem_DataTimeOut 0x7100
#define WriteMem_DataRejected 0x7200


/*	Data structure for CID register	*/
typedef struct CIDregister{
	uint8	ManID[3];
	uint8	ProductName[7];
	unsigned FWRevision : 4;
	unsigned HWRevision : 4;
	uint8	SerialNo0;
	uint8	SerialNo1;
	uint8	SerialNo2;
	unsigned NotUsed :1;
	unsigned CRC7 : 7;
	unsigned YearOS :4;
	unsigned Month :4;
};

/*	Data structure for CID register	*/
//typedef struct CSDregister{
	
	/*	First byte	*/
//	unsigned	Reserved_01		2;
//	unsigned	MMC_Prot		4;
//	unsigned	CSD_Structure 	2;
	/*	Second Byte	*/



	
