/*	This is the code file for 
 *	the assemblier interface to the FAT16 code.
 */
#include <project.h>
#include <FileSystem1.h>
#include <Fat16ASMIF.h>
 
 /*	Global declarations of data for the function calls	*/
uint8	ASMFileName[15] = "filename.ext";
uint8	ASMWriteData[128];
uint16	ASMWriteDataLength;
uint32	ASMFilePtr;
uint8	ASMReadData[128];
uint16	ASMReadDataLength;
uint8	ASMFileSearchStr[20];
uint16	ASMFileErrorCode = NoError;

/****************************************************************************/
/*	Function to initialize and mount the FAT16 of a MM or SDCard
 *	ErrorCodes deposited in ASMFileErrorCode
 */
void	ASMInitFat16(void){
uint16	ErrorCode = NoError;
uint16	i,d;

       	if(MMCardIn()){
		if(MMCardControl(3) == 0){
       			(void)MMCardControl(1);	/*	Turn it on	*/
			i = 100;
			while(--i){
				d = 10000;
				while(--d){;}
			}
       		}
       		ErrorCode = MMCardInit();	/*	Initialize card	*/
		if(!ErrorCode){
			ErrorCode = MountDevice();/*	Initialise the file system	*/
		}
		if(ErrorCode){
			(void)MMCardControl(0);
			i = 100;
			while(--i){
				d = 10000;
				while(--d){;}
			}
		}
	}
	else{
		ErrorCode = DEVICE_NOT_READY;
		(void)MMCardControl(0);		/*	Turn it off	*/
		i = 100;
		while(--i){
			d = 10000;
			while(--d){;}
		}
	}
	ASMFileErrorCode = ErrorCode;
}
 
/****************************************************************************/
/*	Function to open a file as named in ASMFileName	
 *	in the append mode
 */
void	ASMFileOpen(void){
uint16	ErrorCode = NoError;
uint32	FilePtr = 0;
uint16 	Mode = 'A';
	
	ErrorCode = FileOpen(ASMFileName, &FilePtr, Mode);	/*	FilePtr is offset within file	*/
	if(ErrorCode){
		ASMFileErrorCode = ErrorCode;	/* Just to capture it for debug	*/
	}
}
 
/****************************************************************************/
/*	Function to Save the open file.	
 */
void	ASMFileSave(void){
uint16	ErrorCode = NoError;
	ErrorCode = FileSave();
	if(ErrorCode){
		ASMFileErrorCode = ErrorCode;	/* Just to capture it for debug	*/
	}
}
 
/****************************************************************************/
/*	Function to close the open file	
 */
void	ASMFileClose(void){
uint16	ErrorCode = NoError;
	ErrorCode = FileClose();
	if(ErrorCode){
		ASMFileErrorCode = ErrorCode;	/* Just to capture it for debug	*/
	}
}
 
/****************************************************************************/
/*	Function to append the data contained at ASMWriteData 
 *	that is of length ASMWriteDataLength,
 *	to the end of the file that is currently open.
 */
void	ASMFileAppend(void)
{
uint16	ErrorCode = NoError;
uint8 *WriteStr = ASMWriteData;
uint16 LenWriteStr = ASMWriteDataLength;

	ErrorCode = FileAppend(WriteStr, LenWriteStr);
	if(ErrorCode){
		ASMFileErrorCode = ErrorCode;	/* Just to capture it for debug	*/
	}
}
 
/****************************************************************************/
/*	Function to Read the data from the open file
 *	into the buffer at ASMReadData, 
 *	for a length of ASMReadDataLength
 *	From the point defined by ASMFilePtr ????
 */
void	ASMFileRead(void){
uint16	ErrorCode = NoError;
uint32	*FilePtr = &ASMFilePtr;
uint8	*ReadStr = ASMReadData;
uint16	LenReadStr = ASMReadDataLength;

	ErrorCode = FileRead(FilePtr, ReadStr, LenReadStr);
	if(ErrorCode){
		ASMFileErrorCode = ErrorCode;	/* Just to capture it for debug	*/
	}
}
	
/****************************************************************************/
/*	Function to Read the data from the open file
 *	into the buffer at ASMReadData, 
 *	for a length of ASMReadDataLength
 *	From the point defined by the search string ASMFileSearchStr
 */
void	ASMFileSearchRead(void){
uint16	ErrorCode = NoError;
uint32	FilePtr = 0;
uint8	*ReadStr = ASMReadData;
uint16	LenReadStr = ASMReadDataLength;

	ErrorCode = FileSearchStr(ASMFileSearchStr, &FilePtr);
	if(ErrorCode){
		ASMFileErrorCode = ErrorCode;	/* Just to capture it for debug	*/
	}
	ErrorCode = FileRead(&FilePtr, ReadStr, LenReadStr);
	if(ErrorCode){
		ASMFileErrorCode = ErrorCode;	/* Just to capture it for debug	*/
	}
}














