/*******************************************************************
 *	Code file for Testing the FastFile
 *	FAT16 code
 */
#include <hardwareIF.h>
#include <Fat16FastTest.h>
#include <FileSystem1.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "..\FAT16\FAT16FastFileOps.h"


/*	The follow function is used to test FAT16 FastFile system.
 *	It creates a single large file and stores text in the file.
 *	This continues until the the file is full 
 */
// uint16	Debug = 0;

/*****************************************************************************/
uint32	FileSize = 1000000;

uint16	FileNum = 0;
void	Fat16FastFileTest(void)
{
uint16 ErrorCode = NoError;
uint8	Str[40] = {0};
uint16	LineNum = 0;
uint8	FileName[12] = {0};
uint8	c[6] = {0};
uint32	FilePtr = 0;
uint16	i = 0;
uint16	d;

/*	Initialize the required SPI module, pins and data structures.	*/
	MMCardInitSystem();
		while(CardPresent){ /*	Stay in this loop while the card is in place	*/
        	if(MMCardIn()){			/*	If the card has been inserted	*/
        		if(MMCardControl(3) == 0){
        			(void)MMCardControl(1);	/*	Turn it on	*/
				i = 100;
				while(--i){
					d = 10000;
					while(--d){;}
					}
        			}
        		ErrorCode = MMCardInit();	/*	Initialize card	*/
			if(!ErrorCode){
				ErrorCode = MountDevice();/*	Initialise the file system	*/
			}
			while(!ErrorCode){
				FileNum++;
				/*	Create a new file and add to it, the data available as a test	*/
				strcpy(FileName, "FFILE");
				itoa(Str, FileNum,10);
				strcat(FileName,Str);
				strcat(FileName,".txt");
				i=0;
				while(FileName[i]){
					FileName[i] = toupper(FileName[i]);
					i++;
            			}
				if(!ErrorCode){
					ErrorCode = FileOpenFastWrite(FileName, &FileSize, 'W');
					if(!ErrorCode){
						ErrorCode = FastFileFlatOutTest();
					i = 100;
					while(--i){			/***** Wait for a while before turning off ****/
						d = 10000;
						while(--d){;}
						}
					(void)MMCardControl(0);
//					while(2);			/***** STOP HERE *****/
					}
				}
				if(!ErrorCode){
					LineNum = 0;
					ErrorCode = FileCloseFastWrite();
				}
			}
			if(ErrorCode){
				(void)MMCardControl(0);
				i = 100;
				while(--i){
					d = 10000;
					while(--d){;}
					}
				}
   			}
		/*	Maybe have loop here when card requested to be ejected until it is removed.	*/
		else{/* If card is not in, turn the power off	*/
	 		(void)MMCardControl(0);
			}
		}
	d = 10000;
	while(--d){;}
}



