/*******************************************************************
 *	Code file for TEsting/utilizing 
 *	FAT16 code
 */
#include <hardwareIF.h>
#include <Fat16Test.h>
#include <FileSystem1.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <Fat16ASMIF.h>

/*	The follow function is used to test FAT 16 system.
 *	It creates files and stores text in the file.
 *	This continues until there are MAXLINES lines in the file 
 *	then another is created etc.
 *	This is an endless loop due to the "while(1)"
 */
#define MAXLINES 100
uint16	Debug = 0;

/*****************************************************************************/
uint16	TestLine = 0;
uint16	TestFile = 0;

void	ASMFat16Test(void){
extern uint8	ASMFileName;
extern uint8	ASMWriteData;
extern uint16	ASMWriteDataLength;
extern uint32	ASMFilePtr;
extern uint8	ASMReadData;
extern uint16	ASMReadDataLength;
extern uint8	ASMFileSearchStr;
extern uint16	ASMFileErrorCode;
uint8	c[10];

	MMCardInitSystem();

	while(1){
		ASMInitFat16();
		if(ASMFileErrorCode == 0){
			strcpy(&ASMFileName, "FILE");
			itoa(c, TestFile++, 10);
			strcat(&ASMFileName, c);
			strcat(&ASMFileName, ".TXT");
			ASMFileOpen();
			TestLine = 0;
		}
		if(ASMFileErrorCode == 0){
			while((TestLine <= 100) && (ASMFileErrorCode == 0)){
				strcpy(&ASMWriteData, "This is test #");
				itoa(c, TestLine++, 10);
				strcat(&ASMWriteData, c);
				strcat(&ASMWriteData, ".\r\n");
				ASMWriteDataLength = strlen(&ASMWriteData);
				ASMFileAppend();
			}
		}
		if(ASMFileErrorCode == 0){
			ASMFileClose();
		}
		if(ASMFileErrorCode == 0){
			strcpy(&ASMFileSearchStr, "test #12");
			ASMReadDataLength = 20;
			ASMFileSearchRead();
		}
	}
}

/*****************************************************************************/
void	Fat16Test(void)
{
uint16 ErrorCode = NoError;
uint8	Str[30] = {0};
uint16	FileNum = 0;
uint16	LineNum = 0;
uint8	FileName[12] = {0};
uint8	c[6] = {0};
uint32	FilePtr = 0;
uint16	i = 0;
uint16	d;

/*	Initialize the required SPI module, pins and data structures.	*/
	MMCardInitSystem();
	while(CardPresent){ /*	Stay in this loop while the card is in place	*/
		if(MMCardIn()){			/*	If the card has been inserted	*/
			if(MMCardControl(3) == 0){
				(void)MMCardControl(1);	/*	Turn it on	*/
			i = 100;
			while(--i){
				d = 10000;
				while(--d){;}
				}
				}
			ErrorCode = MMCardInit();	/*	Initialize card	*/
		if(!ErrorCode){
			ErrorCode = MountDevice();/*	Initialise the file system	*/
		}
		FileNum = 0;
		while(!ErrorCode){
			FileNum++;
			/*	Create a new file and add to it, the data available as a test	*/
			strcpy(FileName, "FILE");
			itoa(Str, FileNum,10);
			strcat(FileName,Str);
			strcat(FileName,".txt");
			i=0;
			while(FileName[i]){
				FileName[i] = toupper(FileName[i]);
				i++;
					}
			if(!ErrorCode){
				ErrorCode = FileOpen(FileName, &FilePtr, 'A');
			}
			while(!ErrorCode &&(LineNum < MAXLINES)){
				strcpy(Str, FileName);
				strcat(Str, " This is line Number ");
				itoa(c, LineNum++, 10);
				strcat(Str, c);
				strcat(Str, ".\r\n"); 	
				ErrorCode = FileWrite(&FilePtr, Str, strlen(Str));
			}
			if(!ErrorCode && Debug){
				uint32 FilePtr = 0;
				uint8 SearchStr[10] = "99.";
				ErrorCode = FileSave();
				ErrorCode = FileSearchStr(SearchStr, &FilePtr);
				if(ErrorCode){
					ErrorCode++;
				}
			}
			if(!ErrorCode){
				LineNum = 0;
				ErrorCode = FileClose();
			}
		}
		if(ErrorCode){
			(void)MMCardControl(0);
			i = 100;
			while(--i){
				d = 10000;
				while(--d){;}
				}
			}
		}
	/*	Maybe have loop here when card requested to be ejected until it is removed.	*/
	else{/* If card is not in, turn the power off	*/
		(void)MMCardControl(0);
		}
	}
	d = 10000;
	while(--d){;}
}



