/*
 *	This is the code file for the low level drivers
 *	for the SPI module
 *
 */
/* Include Files                              */
#include <project.h>
#include <hcs12dp256.h>
#include <SPIdp.h>
#include "SPIdpP.h"

/*********************************************
 *		Routine description          *
 *	Setup the registers for the baudrate etc.
 ********************************************/
void	InitSPI0(void)
/*setup the chip selects in the hardware specific file
and then set the default SPI config and baud rate
*/
{
unsigned char tempvar;
/*	Initialise the location of the SPI0 pins.	*/
/*	Standard on Port S	*/
//	MODRR BitOff 0x10;	

	PTS = 0x80;			/* Prevent any glitch in PORTS.7 		*/
	DDRS   = 0xEA;		/* configure direction of SPI pins 		*/
	SPI0BR = 0x00;		/* SPI rate = 125 kHz 					*/
	SPI0CR1 = 0x10;		/* SPI in master mode CPOL = 0 CPHA = 0 */
	SPI0CR2 = 0x0A;     /* Halt SPI clock in WAIT mode 			*/
/*	If this is a dedicated SPI module using SS0 then set the SSOE and MODFEN bits	*/
//	SPI0CR1 BitOn SSOE;
//	SPI0CR2 BitOn MODFEN;
/**/
	tempvar = SPI0SR;   /* Clear the SPIF by reading the SP0SR then SP0DR register*/
	tempvar = SPI0DR;
	SPI0CR1 |= 0x40;   	/* Now enable the SPI interface (SPE = 1) */

	return;
}

/*********************************************
 *		Routine description          *
 *	Setup the registers for the baudrate etc.
 ********************************************/
void	InitSPI1(void)
/*setup the chip selects in the hardware specific file
and then set the default SPI config and baud rate
*/
{
unsigned char tempvar;

/*	Initialise the location of the SPI1 pins.	*/
/*	Standard on Port P	*/
//	MODRR BitOff 0x20;	
	
	PTP = 0x08;				/* Prevent any glitch in PORTS.7 */
	DDRP  BitOn 0x0e;		/* configure direction of SPI pins */
	DDRP  BitOff 0x01;		/* configure direction of SPI pins */
	SPI1BR = 0x04;			/* SPI rate = 125 kHz */
	SPI1CR1 = 0x10;			/* SPI in master mode CPOL = 0 CPHA = 0 */
	SPI1CR2 = 0x0A;     	/* Halt SPI clock in WAIT mode */
/*	If this is a dedicated SPI module using SS1 then set the SS1E and MODFEN bits	*/
//	SPI1CR1 BitOn SSOE;
//	SPI1CR2 BitOn MODFEN;
/**/
	tempvar = SPI1SR;    	/* Clear the SPIF by reading the SP0SR then SP0DR register*/
	tempvar = SPI1DR;
	SPI1CR1 |= 0x40;    	/* Now enable the SPI interface (SPE = 1) */

	return;
}

/*********************************************
*		Routine description          *
The basic SPI transfer, not bidirectional.
This is specific to the HCS series
**********************************************/
unsigned char SendGetSPI0(unsigned char DataByte)
/*
Basic IO routine for the SPI
*/
{
	SPI0DR= DataByte;
	while ((SPI0SR & SPRF) == 0) {}
	return(SPI0DR);
}

/*********************************************
*		Routine description          *
The basic SPI transfer, not bidirectional.
This is specific to the HCS series
**********************************************/
unsigned int SendGetSPI0Word(unsigned int DataWord)
/*
 2 byte IO routine for the SPI
Most significant byte/bit first
*/
{
unsigned int tempint = 0;
unsigned char tempchar;
/*	This is slower but more reliable !?	*/
	if (SPI0SR & SPTEF)
		{
		tempchar = DataWord >>8;
		SPI0DR= tempchar;
		while ((SPI0SR & SPRF) == 0) {}
		tempint = SPI0DR<<8;

		tempchar = DataWord;
		SPI0DR = tempchar;

		while ((SPI0SR & SPRF) == 0) {}
		tempint |= SPI0DR;
	
		}
	return(tempint);
}

/*	The same as above for SPI1	*/
/*********************************************
*		Routine description          *
The basic SPI transfer, not bidirectional.
This is specific to the HCS series
**********************************************/
unsigned char SendGetSPI1(unsigned char DataByte)
/*
Basic IO routine for the SPI
*/
{
	SPI1DR= DataByte;
	while ((SPI1SR & SPRF) == 0) {}
	return(SPI1DR);
}

/*********************************************
*		Routine description          *
The basic SPI transfer, not bidirectional.
This is specific to the HCS series
**********************************************/
unsigned int SendGetSPI1Word(unsigned int DataWord)
/*
 2 byte IO routine for the SPI
Most significant byte/bit first
*/
{
unsigned int tempint = 0;
unsigned char tempchar;
/*	This is slower but more reliable !?	*/
	if (SPI1SR & SPTEF)
		{
		tempchar = DataWord >>8;
		SPI1DR= tempchar;
		while ((SPI1SR & SPRF) == 0) {}
		tempint = SPI1DR<<8;

		tempchar = DataWord;
		SPI1DR = tempchar;

		while ((SPI1SR & SPRF) == 0) {}
		tempint |= SPI1DR;
	
		}
	return(tempint);
}

