	.module list.c
	.area text
;  lreg1 -> -4,x
;  lreg2 -> -8,x
;         pxList -> 2,x
_vListInitialise::
	pshd
	pshx
	tfr s,x
	leas -8,sp
; /*
; 	FreeRTOS V2.5.3 - Copyright (C) 2003, 2004 Richard Barry.
; 
; 	This file is part of the FreeRTOS distribution.
; 
; 	FreeRTOS is free software; you can redistribute it and/or modify
; 	it under the terms of the GNU General Public License as published by
; 	the Free Software Foundation; either version 2 of the License, or
; 	(at your option) any later version.
; 
; 	FreeRTOS is distributed in the hope that it will be useful,
; 	but WITHOUT ANY WARRANTY; without even the implied warranty of
; 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; 	GNU General Public License for more details.
; 
; 	You should have received a copy of the GNU General Public License
; 	along with FreeRTOS; if not, write to the Free Software
; 	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
; 
; 	A special exception to the GPL can be applied should you wish to distribute
; 	a combined work that includes FreeRTOS, without being obliged to provide
; 	the source code for any proprietary components.  See the licensing section 
; 	of http://www.FreeRTOS.org for full details of how and when the exception
; 	can be applied.
; 
; 	***************************************************************************
; 	See http://www.FreeRTOS.org for documentation, latest information, license 
; 	and contact details.  Please ensure to read the configuration and relevant 
; 	port sections of the online documentation.
; 	***************************************************************************
; */
; 
; /*
; Changes from V1.2.0
; 
; 	+ Removed the volatile modifier from the function parameters.  This was
; 	  only ever included to prevent compiler warnings.  Now warnings are 
; 	  removed by casting parameters where the calls are made.
; 
; 	+ prvListGetOwnerOfNextEntry() and prvListGetOwnerOfHeadEntry() have been
; 	  removed from the c file and added as macros to the h file.
; 
; 	+ usNumberOfItems has been added to the list structure.  This removes the
; 	  need for a pointer comparison when checking if a list is empty, and so
; 	  is slightly faster.
; 
; 	+ Removed the NULL check in vListRemove().  This makes the call faster but
; 	  necessitates any application code utilising the list implementation to
; 	  ensure NULL pointers are not passed.
; 
; Changes from V2.0.0
; 
; 	+ Double linked the lists to allow faster removal item removal.
; */
; 
; #include <stdlib.h>
; #include "projdefs.h"
; #include "portable.h"
; #include "list.h"
; 
; #ifdef __HIWARE__
; #pragma MESSAGE DISABLE C1825
; #endif
; 
; /*-----------------------------------------------------------
;  * PUBLIC LIST API documented in list.h
;  *----------------------------------------------------------*/
; 
; void vListInitialise( xList *pxList )
; {
; 	/* The list structure contains a list item which is used to mark the 
; 	end of the list.  To initialise the list the list end is inserted
; 	as the only list entry. */
; 	pxList->pxHead = &( pxList->xListEnd );
	ldd 2,x
	addd #6
	ldy 2,x
	std 2,y
; 	pxList->pxIndex = pxList->pxHead;
	ldy 2,x
	ldd 2,y
	ldy 2,x
	std 4,y
; 
; 	/* The list end value is the highest possible value in the list to
; 	ensure it remains at the end of the list. */
; 	pxList->xListEnd.xItemValue = portMAX_DELAY;
	ldy #L2
	movw 0,y,-4,x
	movw 2,y,-2,x
	ldy 2,x
	; vol
	leay 6,y
	movw -4,x,0,y
	movw -2,x,2,y
; 
; 	/* The list end next and previous pointers point to itself so we know
; 	when the list is empty. */
; 	pxList->xListEnd.pxNext = &( pxList->xListEnd );
	ldd 2,x
	addd #6
	ldy 2,x
	std 10,y
; 	pxList->xListEnd.pxPrevious = &( pxList->xListEnd );
	ldd 2,x
	addd #6
	ldy 2,x
	std 12,y
; 
; 	/* The list head will never get used and has no owner. */
; 	pxList->xListEnd.pvOwner = NULL;
	ldy 2,x
	ldd #0
	std 14,y
; 
; 	/* Make sure the marker items are not mistaken for being on a list. */
; 	vListInitialiseItem( ( xListItem * ) &( pxList->xListEnd ) );
	ldd 2,x
	addd #6
	jsr _vListInitialiseItem
; 
; 	pxList->usNumberOfItems = ( unsigned portSHORT ) 0;
	ldy 2,x
	ldd #0
	std 0,y
; }
L1:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
;         pxItem -> 2,x
_vListInitialiseItem::
	pshd
	pshx
	tfr s,x
; /*-----------------------------------------------------------*/
; 
; void vListInitialiseItem( xListItem *pxItem )
; {
; 	/* Make sure the list item is not recorded as being on a list. */
; 	pxItem->pvContainer = NULL;
	ldy 2,x
	ldd #0
	std 10,y
; }
L3:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
;        pxIndex -> -2,x
;  pxNewListItem -> 6,x
;         pxList -> 2,x
_vListInsertEnd::
	pshd
	pshx
	tfr s,x
	leas -2,sp
; /*-----------------------------------------------------------*/
; 
; void vListInsertEnd( xList *pxList, xListItem *pxNewListItem )
; {
; volatile xListItem * pxIndex;
; 
; 	/* Insert a new list item into pxList, but rather than sort the list, 
; 	makes the new list item the last item to be removed by a call to 
; 	pvListGetOwnerOfNextEntry.  This means it has to be the item pointed to by
; 	the pxIndex member. */
; 	pxIndex = pxList->pxIndex;
	ldy 2,x
	ldy 4,y
	sty -2,x
; 
; 	pxNewListItem->pxNext = pxIndex->pxNext;
	ldy -2,x
	; vol
	ldd 4,y
	ldy 6,x
	std 4,y
; 	pxNewListItem->pxPrevious = pxList->pxIndex;
	ldy 2,x
	ldd 4,y
	ldy 6,x
	std 6,y
; 	pxIndex->pxNext->pxPrevious = ( volatile xListItem * ) pxNewListItem;
	ldy -2,x
	; vol
	ldy 4,y
	ldd 6,x
	std 6,y
; 	pxIndex->pxNext = ( volatile xListItem * ) pxNewListItem;
	ldy -2,x
	ldd 6,x
	std 4,y
; 	pxList->pxIndex = ( volatile xListItem * ) pxNewListItem;
	ldy 2,x
	ldd 6,x
	std 4,y
; 
; 	/* Remember which list the item is in. */
; 	pxNewListItem->pvContainer = ( void * ) pxList;
	ldy 6,x
	ldd 2,x
	std 10,y
; 
; 	( pxList->usNumberOfItems )++;
	ldd [2,x]
	addd #1
	ldy 2,x
	std 0,y
; }
L4:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
;  lreg1 -> -4,x
;  lreg2 -> -8,x
;     pxIterator -> -14,x
; xValueOfInsertion -> -12,x
;  pxNewListItem -> 6,x
;         pxList -> 2,x
_vListInsert::
	pshd
	pshx
	tfr s,x
	leas -14,sp
; /*-----------------------------------------------------------*/
; 
; void vListInsert( xList *pxList, xListItem *pxNewListItem )
; {
; volatile xListItem *pxIterator;
; register portTickType xValueOfInsertion;
; 
; 	/* Insert the new list item into the list, sorted in ulListItem order. */
; 	xValueOfInsertion = pxNewListItem->xItemValue;
	ldy 6,x
	movw 0,y,-4,x
	movw 2,y,-2,x
	leay -12,x
	movw -4,x,0,y
	movw -2,x,2,y
; 
; 	/* If the list already contains a list item with the same item value then
; 	the new list item should be placed after it.  This ensures that TCB's which
; 	are stored in ready lists (all of which have the same ulListItem value)
; 	get an equal share of the CPU.  However, if the xItemValue is the same as 
; 	the back marker the iteration loop below will not end.  This means we need
; 	to guard against this by checking the value first and modifying the 
; 	algorithm slightly if necessary. */
; 	if( xValueOfInsertion == portMAX_DELAY )
	leay -12,x
	movw 0,y,-4,x
	movw 2,y,-2,x
	ldy #L2
	movw 0,y,-8,x
	movw 2,y,-6,x
	jsr __lcmp
	bne L6
; 	{
; 		for( pxIterator = pxList->pxHead; pxIterator->pxNext->xItemValue < xValueOfInsertion; pxIterator = pxIterator->pxNext )
	ldy 2,x
	ldy 2,y
	sty -14,x
	bra L11
L8:
L9:
	ldy -14,x
	; vol
	ldy 4,y
	sty -14,x
L11:
	ldy -14,x
	; vol
	ldy 4,y
	; vol
	movw 0,y,-4,x
	; vol
	movw 2,y,-2,x
	leay -12,x
	movw 0,y,-8,x
	movw 2,y,-6,x
	jsr __lcmp
	blo L8
; 		{
; 			/* There is nothing to do here, we are just iterating to the 
; 			wanted insertion position. */
; 		}
; 	}
	bra L7
L6:
; 	else
; 	{
; 		for( pxIterator = pxList->pxHead; pxIterator->pxNext->xItemValue <= xValueOfInsertion; pxIterator = pxIterator->pxNext )
	ldy 2,x
	ldy 2,y
	sty -14,x
	bra L15
L12:
L13:
	ldy -14,x
	; vol
	ldy 4,y
	sty -14,x
L15:
	ldy -14,x
	; vol
	ldy 4,y
	; vol
	movw 0,y,-4,x
	; vol
	movw 2,y,-2,x
	leay -12,x
	movw 0,y,-8,x
	movw 2,y,-6,x
	jsr __lcmp
	bls L12
; 		{
; 			/* There is nothing to do here, we are just iterating to the 
; 			wanted insertion position. */
; 		}
; 	}
L7:
; 
; 	pxNewListItem->pxNext = pxIterator->pxNext;
	ldy -14,x
	; vol
	ldd 4,y
	ldy 6,x
	std 4,y
; 	pxNewListItem->pxNext->pxPrevious = ( volatile xListItem * ) pxNewListItem;
	ldy 6,x
	ldy 4,y
	ldd 6,x
	std 6,y
; 	pxNewListItem->pxPrevious = pxIterator;
	ldy 6,x
	ldd -14,x
	std 6,y
; 	pxIterator->pxNext = ( volatile xListItem * ) pxNewListItem;
	ldy -14,x
	ldd 6,x
	std 4,y
; 
; 	/* Remember which list the item is in.  This allows fast removal of the
; 	item later. */
; 	pxNewListItem->pvContainer = ( void * ) pxList;
	ldy 6,x
	ldd 2,x
	std 10,y
; 
; 	( pxList->usNumberOfItems )++;
	ldd [2,x]
	addd #1
	ldy 2,x
	std 0,y
; }
L5:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
;         pxList -> -2,x
; pxItemToRemove -> 2,x
_vListRemove::
	pshd
	pshx
	tfr s,x
	leas -2,sp
; /*-----------------------------------------------------------*/
; 
; void vListRemove( xListItem *pxItemToRemove )
; {
; xList * pxList;
; 
; 	pxItemToRemove->pxNext->pxPrevious = pxItemToRemove->pxPrevious;
	ldy 2,x
	ldy 4,y
	pshy ; spill
	ldy 2,x
	ldd 6,y
	puly ; reload
	std 6,y
; 	pxItemToRemove->pxPrevious->pxNext = pxItemToRemove->pxNext;
	ldy 2,x
	ldy 6,y
	pshy ; spill
	ldy 2,x
	ldd 4,y
	puly ; reload
	std 4,y
; 	
; 	/* The list item knows which list it is in.  Obtain the list from the list
; 	item. */
; 	pxList = ( xList * ) pxItemToRemove->pvContainer;
	ldy 2,x
	ldy 10,y
	sty -2,x
; 
; 	/* Make sure the index is left pointing to a valid item. */
; 	if( pxList->pxIndex == pxItemToRemove )
	ldy -2,x
	ldd 4,y
	cpd 2,x
	bne L17
; 	{
; 		pxList->pxIndex = pxItemToRemove->pxPrevious;
	ldy 2,x
	ldd 6,y
	ldy -2,x
	std 4,y
; 	}
L17:
; 
; 	pxItemToRemove->pvContainer = NULL;
	ldy 2,x
	ldd #0
	std 10,y
; 	( pxList->usNumberOfItems )--;
	ldd [-2,x]
	subd #1
	ldy -2,x
	std 0,y
; }
L16:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
	.even
L2:
	.word 65535,65535
