	.module queue.c
	.area text
; usQueueSizeInBytes -> -4,x
;     pxNewQueue -> -2,x
;     ucItemSize -> 7,x
;  ucQueueLength -> 3,x
_xQueueCreate::
	pshd
	pshx
	tfr s,x
	leas -6,sp
; /*
; 	FreeRTOS V2.5.3 - Copyright (C) 2003, 2004 Richard Barry.
; 
; 	This file is part of the FreeRTOS distribution.
; 
; 	FreeRTOS is free software; you can redistribute it and/or modify
; 	it under the terms of the GNU General Public License as published by
; 	the Free Software Foundation; either version 2 of the License, or
; 	(at your option) any later version.
; 
; 	FreeRTOS is distributed in the hope that it will be useful,
; 	but WITHOUT ANY WARRANTY; without even the implied warranty of
; 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; 	GNU General Public License for more details.
; 
; 	You should have received a copy of the GNU General Public License
; 	along with FreeRTOS; if not, write to the Free Software
; 	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
; 
; 	A special exception to the GPL can be applied should you wish to distribute
; 	a combined work that includes FreeRTOS, without being obliged to provide
; 	the source code for any proprietary components.  See the licensing section
; 	of http://www.FreeRTOS.org for full details of how and when the exception
; 	can be applied.
; 
; 	***************************************************************************
; 	See http://www.FreeRTOS.org for documentation, latest information, license
; 	and contact details.  Please ensure to read the configuration and relevant
; 	port sections of the online documentation.
; 	***************************************************************************
; */
; 
; /*
; Changes from V1.01
; 
; 	+ More use of 8bit data types.
; 	+ Function name prefixes changed where the data type returned has changed.
; 
; Changed from V2.0.0
; 
; 	+ Added the queue locking mechanism and make more use of the scheduler
; 	  suspension feature to minimise the time interrupts have to be disabled
; 	  when accessing a queue.
; 
; Changed from V2.2.0
; 
; 	+ Explicit use of 'signed' qualifier on portCHAR types added.
; */
; 
; #include <stdlib.h>
; #include <string.h>
; #include "projdefs.h"
; #include "portable.h"
; #include "errors.h"
; #include "task.h"
; #include "list.h"
; 
; #ifdef __HIWARE__
; #pragma MESSAGE DISABLE C12056
; #endif
; 
; 
; /*-----------------------------------------------------------
;  * PUBLIC LIST API documented in list.h
;  *----------------------------------------------------------*/
; 
; /* Constants used with the cRxLock and cTxLock structure members. */
; #define queueUNLOCKED	( ( signed portCHAR ) -1 )
; 
; /*
;  * Definition of the queue used by the scheduler.
;  * Items are queued by copy, not reference.
;  */
; typedef struct QueueDefinition
; {
; 	signed portCHAR *pcHead;				/*< Points to the beginning of the queue storage area. */
; 	signed portCHAR *pcTail;				/*< Points to the byte at the end of the queue storage area.  Once more byte is allocated than necessary to store the queue items, this is used as a marker. */
; 
; 	signed portCHAR *pcWriteTo;				/*< Points to the free next place in the storage area. */
; 	signed portCHAR *pcReadFrom;			/*< Points to the last place that a queued item was read from. */
; 
; 	xList xTasksWaitingToSend;				/*< List of tasks that are blocked waiting to post onto this queue.  Stored in priority order. */
; 	xList xTasksWaitingToReceive;			/*< List of tasks that are blocked waiting to read from this queue.  Stored in priority order. */
; 
; 	unsigned portCHAR ucMessagesWaiting;	/*< The number of items currently in the queue. */
; 	unsigned portCHAR ucLength;				/*< The length of the queue defined as the number of items it will hold, not the number of bytes. */
; 	unsigned portCHAR ucItemSize;			/*< The size of each items that the queue will hold. */
; 
; 	signed portCHAR cRxLock;				/*< Stores the number of items received from the queue (removed from the queue) while the queue was locked.  Set to queueUNLOCKED when the queue is not locked. */
; 	signed portCHAR cTxLock;				/*< Stores the number of items transmitted to the queue (added to the queue) while the queue was locked.  Set to queueUNLOCKED when the queue is not locked. */
; } xQUEUE;
; /*-----------------------------------------------------------*/
; 
; /*
;  * Inside this file xQueueHandle is a pointer to a xQUEUE structure.
;  * To keep the definition private the API header file defines it as a
;  * pointer to void.
;  */
; typedef xQUEUE * xQueueHandle;
; 
; /*
;  * Prototypes for public functions are included here so we don't have to
;  * include the API header file (as it defines xQueueHandle differently).  These
;  * functions are documented in the API header file.
;  */
; xQueueHandle xQueueCreate( unsigned portCHAR ucQueueLength, unsigned portCHAR ucItemSize );
; signed portCHAR cQueueSend( xQueueHandle xQueue, const void * pvItemToQueue, portTickType xTicksToWait );
; unsigned portCHAR ucQueueMessagesWaiting( xQueueHandle pxQueue );
; void vQueueDelete( xQueueHandle xQueue );
; signed portCHAR cQueueSendFromISR( xQueueHandle pxQueue, const void *pvItemToQueue, signed portCHAR cTaskPreviouslyWoken );
; signed portCHAR cQueueReceive( xQueueHandle pxQueue, void *pcBuffer, portTickType xTicksToWait );
; 
; /*
;  * Unlocks a queue locked by a call to prvLockQueue.  Locking a queue does not
;  * prevent an ISR from adding or removing items to the queue, but does prevent
;  * an ISR from removing tasks from the queue event lists.  If an ISR finds a
;  * queue is locked it will instead increment the appropriate queue lock count
;  * to indicate that a task may require unblocking.  When the queue in unlocked
;  * these lock counts are inspected, and the appropriate action taken.
;  */
; static signed portCHAR prvUnlockQueue( xQueueHandle pxQueue );
; 
; /*
;  * Uses a critical section to determine if there is any data in a queue.
;  *
;  * @return pdTRUE if the queue contains no items, otherwise pdFALSE.
;  */
; static signed portCHAR prvIsQueueEmpty( const xQueueHandle pxQueue );
; 
; /*
;  * Uses a critical section to determine if there is any space in a queue.
;  *
;  * @return pdTRUE if there is no space, otherwise pdFALSE;
;  */
; static signed portCHAR prvIsQueueFull( const xQueueHandle pxQueue );
; 
; /*
;  * Macro that copies an item into the queue.  This is done by copying the item
;  * byte for byte, not by reference.  Updates the queue state to ensure it's
;  * integrity after the copy.
;  */
; #define prvCopyQueueData( pxQueue, pvItemToQueue )												\
; {																								\
; 	memcpy( ( void * ) pxQueue->pcWriteTo, (void*)pvItemToQueue, ( unsigned ) pxQueue->ucItemSize );	\
; 	++( pxQueue->ucMessagesWaiting );															\
; 	pxQueue->pcWriteTo += pxQueue->ucItemSize;													\
; 	if( pxQueue->pcWriteTo >= pxQueue->pcTail )													\
; 	{																							\
; 		pxQueue->pcWriteTo = pxQueue->pcHead;													\
; 	}																							\
; }
; /*-----------------------------------------------------------*/
; 
; /*
;  * Macro to mark a queue as locked.  Locking a queue prevents an ISR from
;  * accessing the queue event lists.
;  */
; #define prvLockQueue( pxQueue )			\
; {										\
; 	taskENTER_CRITICAL();				\
; 		++( pxQueue->cRxLock );			\
; 		++( pxQueue->cTxLock );			\
; 	taskEXIT_CRITICAL();				\
; }
; /*-----------------------------------------------------------*/
; 
; 
; /*-----------------------------------------------------------
;  * PUBLIC QUEUE MANAGEMENT API documented in queue.h
;  *----------------------------------------------------------*/
; 
; xQueueHandle xQueueCreate( unsigned portCHAR ucQueueLength, unsigned portCHAR ucItemSize )
; {
; xQUEUE *pxNewQueue;
; unsigned portSHORT usQueueSizeInBytes;
; 
; 	/* Allocate the new queue structure. */
; 	if( ucQueueLength > ( unsigned portCHAR ) 0 )
	tst 3,x
	lbls L4
; 	{
; 		pxNewQueue = ( xQUEUE * ) pvPortMalloc( sizeof( xQUEUE ) );
	ldd #50
	jsr _pvPortMalloc
	std -2,x
; 		if( pxNewQueue != NULL )
	ldd -2,x
	lbeq L6
; 		{
; 			/* Create the list of pointers to queue items.  The queue is one byte
; 			longer than asked for to make wrap checking easier/faster. */
; 			usQueueSizeInBytes = ( unsigned portSHORT ) ( ucQueueLength * ucItemSize ) + ( unsigned portSHORT ) 1;
	ldab 7,x
	clra
	xgdy
	ldab 3,x
	clra
	emuls
	addd #1
	std -4,x
; 
; 			pxNewQueue->pcHead = ( signed portCHAR * ) pvPortMalloc( usQueueSizeInBytes );
	ldd -4,x
	jsr _pvPortMalloc
	std -6,x
	ldy -2,x
	ldd -6,x
	std 0,y
; 			if( pxNewQueue->pcHead != NULL )
	ldd [-2,x]
	beq L8
; 			{
; 				/* Initialise the queue members as described above where the
; 				queue type is defined. */
; 				pxNewQueue->pcTail = pxNewQueue->pcHead + ( ucQueueLength * ucItemSize );
	ldab 7,x
	clra
	xgdy
	ldab 3,x
	clra
	emuls
	addd [-2,x]
	ldy -2,x
	std 2,y
; 				pxNewQueue->ucMessagesWaiting = ( unsigned portCHAR ) 0;
	ldy -2,x
	clr 44,y
; 				pxNewQueue->pcWriteTo = pxNewQueue->pcHead;
	ldy -2,x
	ldd [-2,x]
	std 4,y
; 				pxNewQueue->pcReadFrom = pxNewQueue->pcHead + ( ( ucQueueLength - ( unsigned portCHAR ) 1 ) * ucItemSize );
	ldab 7,x
	clra
	xgdy
	ldab 3,x
	clra
	subd #1
	emuls
	addd [-2,x]
	ldy -2,x
	std 6,y
; 				pxNewQueue->ucLength = ucQueueLength;
	ldy -2,x
	ldab 3,x
	stab 45,y
; 				pxNewQueue->ucItemSize = ucItemSize;
	ldy -2,x
	ldab 7,x
	stab 46,y
; 				pxNewQueue->cRxLock = queueUNLOCKED;
	ldy -2,x
	ldab #-1
	stab 47,y
; 				pxNewQueue->cTxLock = queueUNLOCKED;
	ldy -2,x
	ldab #-1
	stab 48,y
; 
; 				/* Likewise ensure the event queues start with the correct state. */
; 				vListInitialise( &( pxNewQueue->xTasksWaitingToSend ) );
	ldd -2,x
	addd #8
	jsr _vListInitialise
; 				vListInitialise( &( pxNewQueue->xTasksWaitingToReceive ) );
	ldd -2,x
	addd #26
	jsr _vListInitialise
; 
; 				return  pxNewQueue;
	ldd -2,x
	bra L3
L8:
; 			}
; 			else
; 			{
; 				vPortFree( pxNewQueue );
	ldd -2,x
	jsr _vPortFree
; 			}
; 		}
L6:
; 	}
L4:
; 
; 	/* Will only reach here if we could not allocate enough memory or no memory
; 	was required. */
; 	return NULL;
	ldd #0
L3:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
;  lreg1 -> -4,x
;  lreg2 -> -8,x
;          ?temp -> -12,x
;          ?temp -> -14,x
;          ?temp -> -12,x
;          ?temp -> -14,x
;          ?temp -> -12,x
;          ?temp -> -14,x
;          ?temp -> -12,x
;        cReturn -> -9,x
;   xTicksToWait -> 8,x
;  pvItemToQueue -> 6,x
;        pxQueue -> 2,x
_cQueueSend::
	pshd
	pshx
	tfr s,x
	leas -26,sp
; }
; /*-----------------------------------------------------------*/
; 
; signed portCHAR cQueueSend( xQueueHandle pxQueue, const void *pvItemToQueue, portTickType xTicksToWait )
; {
; signed portCHAR cReturn;
; 
; 	/* Make sure other tasks do not access the queue. */
; 	vTaskSuspendAll();
	jsr _vTaskSuspendAll
; 
; 	/* It is important that this is the only thread/ISR that modifies the
; 	ready or delayed lists until cTaskResumeAll() is called.  Places where
; 	the ready/delayed lists are modified include:
; 
; 		+ vTaskDelay() -  Nothing can call vTaskDelay as the scheduler is
; 		  suspended, vTaskDelay() cannot be called from an ISR.
; 		+ vTaskPrioritySet() - Has a critical section around the access.
; 		+ vTaskSwitchContext() - This will not get executed while the scheduler
; 		  is suspended.
; 		+ prvCheckDelayedTasks() - This will not get executed while the
; 		  scheduler is suspended.
; 		+ sTaskCreate() - Has a critical section around the access.
; 		+ vTaskResume() - Has a critical section around the access.
; 		+ cTaskResumeAll() - Has a critical section around the access.
; 		+ cTaskRemoveFromEventList - Checks to see if the scheduler is
; 		  suspended.  If so then the TCB being removed from the event is
; 		  removed from the event and added to the xPendingReadyList.
; 	*/
; 
; 	/* Make sure interrupts do not access the queue event list. */
; 	prvLockQueue( pxQueue );
	jsr _vPortEnterCritical
	ldd 2,x
	addd #47
	std -12,x
	tfr d,y
	pshy ; spill
	ldy -12,x
	puly ; reload
	inc 0,y
	ldd 2,x
	addd #48
	std -14,x
	tfr d,y
	pshy ; spill
	ldy -14,x
	puly ; reload
	inc 0,y
	jsr _vPortExitCritical
; 
; 	/* It is important that interrupts to not access the event list of the
; 	queue being modified here.  Places where the event list is modified
; 	include:
; 
; 		+ cQueueSendFromISR().  This checks the lock on the queue to see if
; 		  it has access.  If the queue is locked then the Tx lock count is
; 		  incremented to signify that a task waiting for data can be made ready
; 		  once the queue lock is removed.  If the queue is not locked then
; 		  a task can be moved from the event list, but will not be removed
; 		  from the delayed list or placed in the ready list until the scheduler
; 		  is unlocked.
; 
; 		+ cQueueReceiveFromISR().  As per cQueueSendFromISR().
; 	*/
; 
; 	/* If the queue is already full we may have to block. */
; 	if( prvIsQueueFull( pxQueue ) )
	ldd 2,x
	jsr _prvIsQueueFull
	std -16,x
	tst -15,x
	lbeq L11
; 	{
; 		/* The queue is full - do we want to block or just leave without
; 		posting? */
; 		if( xTicksToWait > ( portTickType ) 0 )
	leay 8,x
	movw 0,y,-4,x
	movw 2,y,-2,x
	ldy #L15
	movw 0,y,-8,x
	movw 2,y,-6,x
	jsr __lcmp
	beq L13
; 		{
; 			/* We are going to place ourselves on the xTasksWaitingToSend event
; 			list, and will get woken should the delay expire, or space become
; 			available on the queue.
; 
; 			As detailed above we do not require mutual exclusion on the event
; 			list as nothing else can modify it or the ready lists while we
; 			have the scheduler suspended and queue locked.
; 
; 			It is possible that an ISR has removed data from the queue since we
; 			checked if any was available.  If this is the case then the data
; 			will have been copied from the queue, and the queue variables
; 			updated, but the event list will not yet have been checked to see if
; 			anything is waiting as the queue is locked. */
; 			vTaskPlaceOnEventList( &( pxQueue->xTasksWaitingToSend ), xTicksToWait );
	leay 8,x
	movw 0,y,-4,x
	movw 2,y,-2,x
	leay 0,sp
	movw -4,x,0,y
	movw -2,x,2,y
	ldd 2,x
	addd #8
	jsr _vTaskPlaceOnEventList
; 
; 			/* Force a context switch now as we are blocked.  We can do
; 			this from within a critical section as the task we are
; 			switching to has its own context.  When we return here (i.e. we
; 			unblock) we will leave the critical section as normal.
; 
; 			It is possible that an ISR has caused an event on an unrelated and
; 			unlocked queue.  If this was the case then the event list for that
; 			queue will have been updated but the ready lists left unchanged -
; 			instead the readied task will have been added to the pending ready
; 			list. */
; 			taskENTER_CRITICAL();
	jsr _vPortEnterCritical
; 			{
; 				/* We can safely unlock the queue and scheduler here as
; 				interrupts are disabled.  We must not yield with anything
; 				locked, but we can yield from within a critical section.
; 
; 				Tasks that have been placed on the pending ready list cannot
; 				be tasks that are waiting for events on this queue.  See
; 				in comment cTaskRemoveFromEventList(). */
; 				prvUnlockQueue( pxQueue );
	ldd 2,x
	jsr _prvUnlockQueue
; 
; 				/* Resuming the scheduler may cause a yield.  If so then there
; 				is no point yielding again here. */
; 				if( !cTaskResumeAll() )
	jsr _cTaskResumeAll
	std -18,x
	tst -17,x
	bne L16
; 				{
; 					taskYIELD();
	jsr _vPortYield
; 				}
L16:
; 
; 				/* Before leaving the critical section we have to ensure
; 				exclusive access again. */
; 				vTaskSuspendAll();
	jsr _vTaskSuspendAll
; 				prvLockQueue( pxQueue );
	jsr _vPortEnterCritical
	ldd 2,x
	addd #47
	std -12,x
	tfr d,y
	pshy ; spill
	ldy -12,x
	puly ; reload
	inc 0,y
	ldd 2,x
	addd #48
	std -14,x
	tfr d,y
	pshy ; spill
	ldy -14,x
	puly ; reload
	inc 0,y
	jsr _vPortExitCritical
; 			}
; 			taskEXIT_CRITICAL();
	jsr _vPortExitCritical
; 		}
L13:
; 	}
L11:
; 
; 	/* When we are here it is possible that we unlblocked as space became
; 	available on the queue.  It is also possible that an ISR posted to the
; 	queue since we left the critical section, so it may be that again there
; 	is no space.  This would only happen if a task and ISR post onto the
; 	same queue. */
; 	taskENTER_CRITICAL();
	jsr _vPortEnterCritical
; 	{
; 		if( pxQueue->ucMessagesWaiting < pxQueue->ucLength )
	ldy 2,x
	ldab 44,y
	ldy 2,x
	cmpb 45,y
	bhs L18
; 		{
	ldy 2,x
	ldab 46,y
	clra
	std 2,sp
	movw 6,x,0,sp
	ldy 2,x
	ldd 4,y
	jsr _memcpy
	ldd 2,x
	addd #44
	std -12,x
	tfr d,y
	ldab 0,y
	clra
	addd #1
	ldy -12,x
	stab 0,y
	ldd 2,x
	addd #4
	std -14,x
	ldy 2,x
	ldab 46,y
	clra
	addd [-14,x]
	ldy -14,x
	std 0,y
	ldy 2,x
	ldd 4,y
	ldy 2,x
	cpd 2,y
	blo L20
	ldy 2,x
	ldd [2,x]
	std 4,y
L20:
; 			/* There is room in the queue, copy the data into the queue. */
; 			prvCopyQueueData( pxQueue, pvItemToQueue );
; 			cReturn = ( signed portCHAR ) pdPASS;
	ldab #1
	stab -9,x
; 
; 			/* Update the TxLock count so prvUnlockQueue knows to check for
; 			tasks waiting for data to become available in the queue. */
; 			++( pxQueue->cTxLock );
	ldd 2,x
	addd #48
	std -12,x
	tfr d,y
	pshy ; spill
	ldy -12,x
	puly ; reload
	inc 0,y
; 		}
	bra L19
L18:
; 		else
; 		{
; 			cReturn = errQUEUE_FULL;
	ldab #-3
	stab -9,x
; 		}
L19:
; 	}
; 	taskEXIT_CRITICAL();
	jsr _vPortExitCritical
; 
; 	/* We no longer require exclusive access to the queue.  prvUnlockQueue
; 	will remove any tasks suspended on a receive if either this function
; 	or an ISR has posted onto the queue. */
; 	if( prvUnlockQueue( pxQueue ) )
	ldd 2,x
	jsr _prvUnlockQueue
	std -20,x
	tst -19,x
	beq L22
; 	{
; 		/* Resume the scheduler - making ready any tasks that were woken
; 		by an event while the scheduler was locked.  Resuming the
; 		scheduler may cause a yield, in which case there is no point
; 		yielding again here. */
; 		if( !cTaskResumeAll() )
	jsr _cTaskResumeAll
	std -22,x
	tst -21,x
	bne L23
; 		{
; 			taskYIELD();
	jsr _vPortYield
; 		}
; 	}
	bra L23
L22:
; 	else
; 	{
; 		/* Resume the scheduler - making ready any tasks that were woken
; 		by an event while the scheduler was locked. */
; 		cTaskResumeAll();
	jsr _cTaskResumeAll
; 	}
L23:
; 
; 	return cReturn;
	ldab -9,x
	tfr b,d
L10:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
;          ?temp -> -2,x
;          ?temp -> -4,x
;          ?temp -> -2,x
; cTaskPreviouslyWoken -> 9,x
;  pvItemToQueue -> 6,x
;        pxQueue -> 2,x
_cQueueSendFromISR::
	pshd
	pshx
	tfr s,x
	leas -10,sp
; }
; /*-----------------------------------------------------------*/
; 
; signed portCHAR cQueueSendFromISR( xQueueHandle pxQueue, const void *pvItemToQueue, signed portCHAR cTaskPreviouslyWoken )
; {
; 	/* Similar to cQueueSend, except we don't block if there is no room in the
; 	queue.  Also we don't directly wake a task that was blocked on a queue
; 	read, instead we return a flag to say whether a context switch is required
; 	or not (i.e. has a task with a higher priority than us been woken by this
; 	post). */
; 	if( pxQueue->ucMessagesWaiting < pxQueue->ucLength )
	ldy 2,x
	ldab 44,y
	ldy 2,x
	cmpb 45,y
	lbhs L27
; 	{
	ldy 2,x
	ldab 46,y
	clra
	std 2,sp
	movw 6,x,0,sp
	ldy 2,x
	ldd 4,y
	jsr _memcpy
	ldd 2,x
	addd #44
	std -2,x
	tfr d,y
	ldab 0,y
	clra
	addd #1
	ldy -2,x
	stab 0,y
	ldd 2,x
	addd #4
	std -4,x
	ldy 2,x
	ldab 46,y
	clra
	addd [-4,x]
	ldy -4,x
	std 0,y
	ldy 2,x
	ldd 4,y
	ldy 2,x
	cpd 2,y
	blo L29
	ldy 2,x
	ldd [2,x]
	std 4,y
L29:
; 		prvCopyQueueData( pxQueue, pvItemToQueue );
; 
; 		/* If the queue is locked we do not alter the event list.  This will
; 		be done when the queue is unlocked later. */
; 		if( pxQueue->cTxLock == queueUNLOCKED )
	ldy 2,x
	ldab 48,y
	cmpb #-1
	bne L31
; 		{
; 			/* We only want to wake one task per ISR, so check that a task has
; 			not already been woken. */
; 			if( !cTaskPreviouslyWoken )
	tst 9,x
	bne L32
; 			{
; 				if( !listLIST_IS_EMPTY( &( pxQueue->xTasksWaitingToReceive ) ) )
	ldy 2,x
	ldd 26,y
	beq L32
; 				{
; 					if( cTaskRemoveFromEventList( &( pxQueue->xTasksWaitingToReceive ) ) != ( signed portCHAR ) pdFALSE )
	ldd 2,x
	addd #26
	jsr _cTaskRemoveFromEventList
	std -6,x
	tst -5,x
	beq L32
; 					{
; 						/* The task waiting has a higher priority so record that a
; 						context	switch is required. */
; 						return pdTRUE;
	ldd #1
	bra L26
X0:
; 					}
; 				}
; 			}
; 		}
L31:
; 		else
; 		{
; 			/* Increment the lock count so the task that unlocks the queue
; 			knows that data was posted while it was locked. */
; 			++( pxQueue->cTxLock );
	ldd 2,x
	addd #48
	std -2,x
	tfr d,y
	pshy ; spill
	ldy -2,x
	puly ; reload
	inc 0,y
; 		}
L32:
; 	}
L27:
; 
; 	return cTaskPreviouslyWoken;
	ldab 9,x
	tfr b,d
L26:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
;  lreg1 -> -4,x
;  lreg2 -> -8,x
;          ?temp -> -16,x
;          ?temp -> -14,x
;          ?temp -> -12,x
;          ?temp -> -14,x
;          ?temp -> -12,x
;          ?temp -> -14,x
;          ?temp -> -12,x
;        cReturn -> -9,x
;   xTicksToWait -> 8,x
;       pcBuffer -> 6,x
;        pxQueue -> 2,x
_cQueueReceive::
	pshd
	pshx
	tfr s,x
	leas -28,sp
; }
; /*-----------------------------------------------------------*/
; 
; signed portCHAR cQueueReceive( xQueueHandle pxQueue, void *pcBuffer, portTickType xTicksToWait )
; {
; signed portCHAR cReturn;
; 
; 	/* This function is very similar to cQueueSend().  See comments within
; 	cQueueSend() for a more detailed explanation.
; 
; 	Make sure other tasks do not access the queue. */
; 	vTaskSuspendAll();
	jsr _vTaskSuspendAll
; 
; 	/* Make sure interrupts do not access the queue. */
; 	prvLockQueue( pxQueue );
	jsr _vPortEnterCritical
	ldd 2,x
	addd #47
	std -12,x
	tfr d,y
	pshy ; spill
	ldy -12,x
	puly ; reload
	inc 0,y
	ldd 2,x
	addd #48
	std -14,x
	tfr d,y
	pshy ; spill
	ldy -14,x
	puly ; reload
	inc 0,y
	jsr _vPortExitCritical
; 
; 	/* If there are no messages in the queue we may have to block. */
; 	if( prvIsQueueEmpty( pxQueue ) )
	ldd 2,x
	jsr _prvIsQueueEmpty
	std -18,x
	tst -17,x
	lbeq L40
; 	{
; 		/* There are no messages in the queue, do we want to block or just
; 		leave with nothing? */
; 		if( xTicksToWait > ( portTickType ) 0 )
	leay 8,x
	movw 0,y,-4,x
	movw 2,y,-2,x
	ldy #L15
	movw 0,y,-8,x
	movw 2,y,-6,x
	jsr __lcmp
	beq L42
; 		{
; 			vTaskPlaceOnEventList( &( pxQueue->xTasksWaitingToReceive ), xTicksToWait );
	leay 8,x
	movw 0,y,-4,x
	movw 2,y,-2,x
	leay 0,sp
	movw -4,x,0,y
	movw -2,x,2,y
	ldd 2,x
	addd #26
	jsr _vTaskPlaceOnEventList
; 			taskENTER_CRITICAL();
	jsr _vPortEnterCritical
; 			{
; 				prvUnlockQueue( pxQueue );
	ldd 2,x
	jsr _prvUnlockQueue
; 				if( !cTaskResumeAll() )
	jsr _cTaskResumeAll
	std -20,x
	tst -19,x
	bne L44
; 				{
; 					taskYIELD();
	jsr _vPortYield
; 				}
L44:
; 
; 				vTaskSuspendAll();
	jsr _vTaskSuspendAll
; 				prvLockQueue( pxQueue );
	jsr _vPortEnterCritical
	ldd 2,x
	addd #47
	std -12,x
	tfr d,y
	pshy ; spill
	ldy -12,x
	puly ; reload
	inc 0,y
	ldd 2,x
	addd #48
	std -14,x
	tfr d,y
	pshy ; spill
	ldy -14,x
	puly ; reload
	inc 0,y
	jsr _vPortExitCritical
; 			}
; 			taskEXIT_CRITICAL();
	jsr _vPortExitCritical
; 		}
L42:
; 	}
L40:
; 
; 	taskENTER_CRITICAL();
	jsr _vPortEnterCritical
; 	{
; 		if( pxQueue->ucMessagesWaiting > ( unsigned portCHAR ) 0 )
	ldy 2,x
	tst 44,y
	bls L46
; 		{
; 			pxQueue->pcReadFrom += pxQueue->ucItemSize;
	ldd 2,x
	addd #6
	std -12,x
	ldy 2,x
	ldab 46,y
	clra
	addd [-12,x]
	ldy -12,x
	std 0,y
; 			if( pxQueue->pcReadFrom >= pxQueue->pcTail )
	ldy 2,x
	ldd 6,y
	ldy 2,x
	cpd 2,y
	blo L48
; 			{
; 				pxQueue->pcReadFrom = pxQueue->pcHead;
	ldy 2,x
	ldd [2,x]
	std 6,y
; 			}
L48:
; 			--( pxQueue->ucMessagesWaiting );
	ldd 2,x
	addd #44
	std -14,x
	tfr d,y
	ldab 0,y
	clra
	subd #1
	ldy -14,x
	stab 0,y
; 			memcpy( ( void * ) pcBuffer, ( void * ) pxQueue->pcReadFrom, ( unsigned ) pxQueue->ucItemSize );
	ldy 2,x
	ldab 46,y
	clra
	std 2,sp
	ldy 2,x
	ldy 6,y
	sty 0,sp
	ldd 6,x
	jsr _memcpy
; 
; 			/* Increment the lock count so prvUnlockQueue knows to check for
; 			tasks waiting for space to become available on the queue. */
; 			++( pxQueue->cRxLock );
	ldd 2,x
	addd #47
	std -16,x
	tfr d,y
	pshy ; spill
	ldy -16,x
	puly ; reload
	inc 0,y
; 			cReturn = ( signed portCHAR ) pdPASS;
	ldab #1
	stab -9,x
; 		}
	bra L47
L46:
; 		else
; 		{
; 			cReturn = ( signed portCHAR ) pdFAIL;
	clr -9,x
; 		}
L47:
; 	}
; 	taskEXIT_CRITICAL();
	jsr _vPortExitCritical
; 
; 	/* We no longer require exclusive access to the queue. */
; 	if( prvUnlockQueue( pxQueue ) )
	ldd 2,x
	jsr _prvUnlockQueue
	std -22,x
	tst -21,x
	beq L50
; 	{
; 		if( !cTaskResumeAll() )
	jsr _cTaskResumeAll
	std -24,x
	tst -23,x
	bne L51
; 		{
; 			taskYIELD();
	jsr _vPortYield
; 		}
; 	}
	bra L51
L50:
; 	else
; 	{
; 		cTaskResumeAll();
	jsr _cTaskResumeAll
; 	}
L51:
; 
; 	return cReturn;
	ldab -9,x
	tfr b,d
L39:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
;          ?temp -> -8,x
;          ?temp -> -6,x
;          ?temp -> -4,x
;        cReturn -> -1,x
;    pcTaskWoken -> 8,x
;       pcBuffer -> 6,x
;        pxQueue -> 2,x
_cQueueReceiveFromISR::
	pshd
	pshx
	tfr s,x
	leas -14,sp
; }
; /*-----------------------------------------------------------*/
; 
; signed portCHAR cQueueReceiveFromISR( xQueueHandle pxQueue, void *pcBuffer, signed portCHAR *pcTaskWoken )
; {
; signed portCHAR cReturn;
; 
; 	/* We cannot block from an ISR, so check there is data available. */
; 	if( pxQueue->ucMessagesWaiting > ( unsigned portCHAR ) 0 )
	ldy 2,x
	tst 44,y
	lbls L55
; 	{
; 		/* Copy the data from the queue. */
; 		pxQueue->pcReadFrom += pxQueue->ucItemSize;
	ldd 2,x
	addd #6
	std -4,x
	ldy 2,x
	ldab 46,y
	clra
	addd [-4,x]
	ldy -4,x
	std 0,y
; 		if( pxQueue->pcReadFrom >= pxQueue->pcTail )
	ldy 2,x
	ldd 6,y
	ldy 2,x
	cpd 2,y
	blo L57
; 		{
; 			pxQueue->pcReadFrom = pxQueue->pcHead;
	ldy 2,x
	ldd [2,x]
	std 6,y
; 		}
L57:
; 		--( pxQueue->ucMessagesWaiting );
	ldd 2,x
	addd #44
	std -6,x
	tfr d,y
	ldab 0,y
	clra
	subd #1
	ldy -6,x
	stab 0,y
; 		memcpy( ( void * ) pcBuffer, ( void * ) pxQueue->pcReadFrom, ( unsigned ) pxQueue->ucItemSize );
	ldy 2,x
	ldab 46,y
	clra
	std 2,sp
	ldy 2,x
	ldy 6,y
	sty 0,sp
	ldd 6,x
	jsr _memcpy
; 
; 		/* If the queue is locked we will not modify the event list.  Instead
; 		we update the lock count so the task that unlocks the queue will know
; 		that an ISR has removed data while the queue was locked. */
; 		if( pxQueue->cRxLock == queueUNLOCKED )
	ldy 2,x
	ldab 47,y
	cmpb #-1
	bne L59
; 		{
; 			/* We only want to wake one task per ISR, so check that a task has
; 			not already been woken. */
; 			if( !( *pcTaskWoken ) )
	ldy 8,x
	tst 0,y
	bne L60
; 			{
; 				if( !listLIST_IS_EMPTY( &( pxQueue->xTasksWaitingToSend ) ) )
	ldy 2,x
	ldd 8,y
	beq L60
; 				{
; 					if( cTaskRemoveFromEventList( &( pxQueue->xTasksWaitingToSend ) ) != ( signed portCHAR ) pdFALSE )
	ldd 2,x
	addd #8
	jsr _cTaskRemoveFromEventList
	std -10,x
	tst -9,x
	beq L60
; 					{
; 						/* The task waiting has a higher priority than us so
; 						force a context switch. */
; 						*pcTaskWoken = ( signed portCHAR ) pdTRUE;
	ldy 8,x
	ldab #1
	stab 0,y
; 					}
; 				}
; 			}
; 		}
	bra L60
L59:
; 		else
; 		{
; 			/* Increment the lock count so the task that unlocks the queue
; 			knows that data was removed while it was locked. */
; 			++( pxQueue->cRxLock );
	ldd 2,x
	addd #47
	std -8,x
	tfr d,y
	pshy ; spill
	ldy -8,x
	puly ; reload
	inc 0,y
; 		}
L60:
; 
; 		cReturn = ( signed portCHAR ) pdPASS;
	ldab #1
	stab -1,x
; 	}
	bra L56
L55:
; 	else
; 	{
; 		cReturn = ( signed portCHAR ) pdFAIL;
	clr -1,x
; 	}
L56:
; 
; 	return cReturn;
	ldab -1,x
	tfr b,d
L54:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
;       ucReturn -> -1,x
;        pxQueue -> 2,x
_ucQueueMessagesWaiting::
	pshd
	pshx
	tfr s,x
	leas -2,sp
; }
; /*-----------------------------------------------------------*/
; 
; unsigned portCHAR ucQueueMessagesWaiting( xQueueHandle pxQueue )
; {
; unsigned portCHAR ucReturn;
; 
; 	taskENTER_CRITICAL();
	jsr _vPortEnterCritical
; 		ucReturn = pxQueue->ucMessagesWaiting;
	ldy 2,x
	ldab 44,y
	stab -1,x
; 	taskEXIT_CRITICAL();
	jsr _vPortExitCritical
; 
; 	return ucReturn;
	ldab -1,x
	clra
L67:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
;        pxQueue -> 2,x
_vQueueDelete::
	pshd
	pshx
	tfr s,x
; }
; /*-----------------------------------------------------------*/
; 
; void vQueueDelete( xQueueHandle pxQueue )
; {
; 	vPortFree( pxQueue->pcHead );
	ldd [2,x]
	jsr _vPortFree
; 	vPortFree( pxQueue );
	ldd 2,x
	jsr _vPortFree
; }
L68:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
;          ?temp -> -4,x
;          ?temp -> -4,x
; cYieldRequired -> -1,x
;        pxQueue -> 2,x
_prvUnlockQueue:
	pshd
	pshx
	tfr s,x
	leas -8,sp
; /*-----------------------------------------------------------*/
; 
; static signed portCHAR prvUnlockQueue( xQueueHandle pxQueue )
; {
; signed portCHAR cYieldRequired = ( signed portCHAR ) pdFALSE;
	clr -1,x
; 
; 	/* THIS FUNCTION MUST BE CALLED WITH THE SCHEDULER SUSPENDED. */
; 
; 	/* The lock counts contains the number of extra data items placed or
; 	removed from the queue while the queue was locked.  When a queue is
; 	locked items can be added or removed, but the event lists cannot be
; 	updated. */
; 	taskENTER_CRITICAL();
	jsr _vPortEnterCritical
; 	{
; 		--( pxQueue->cTxLock );
	ldd 2,x
	addd #48
	std -4,x
	tfr d,y
	pshy ; spill
	ldy -4,x
	puly ; reload
	dec 0,y
; 
; 		/* See if data was added to the queue while it was locked. */
; 		if( pxQueue->cTxLock > queueUNLOCKED )
	ldy 2,x
	ldab 48,y
	cmpb #-1
	ble L70
; 		{
; 			pxQueue->cTxLock = queueUNLOCKED;
	ldy 2,x
	ldab #-1
	stab 48,y
; 
; 			/* Data was posted while the queue was locked.  Are any tasks
; 			blocked waiting for data to become available? */
; 			if( !listLIST_IS_EMPTY( &( pxQueue->xTasksWaitingToReceive ) ) )
	ldy 2,x
	ldd 26,y
	beq L72
; 			{
; 				/* Tasks that are removed from the event list will get added to
; 				the pending ready list as the scheduler is still suspended. */
; 				if( cTaskRemoveFromEventList( &( pxQueue->xTasksWaitingToReceive ) ) != ( signed portCHAR ) pdFALSE )
	ldd 2,x
	addd #26
	jsr _cTaskRemoveFromEventList
	std -6,x
	tst -5,x
	beq L74
; 				{
; 					/* The task waiting has a higher priority so record that a
; 					context	switch is required. */
; 					cYieldRequired = ( signed portCHAR ) pdTRUE;
	ldab #1
	stab -1,x
; 				}
L74:
; 			}
L72:
; 		}
L70:
; 	}
; 	taskEXIT_CRITICAL();
	jsr _vPortExitCritical
; 
; 	/* Do the same for the Rx lock. */
; 	taskENTER_CRITICAL();
	jsr _vPortEnterCritical
; 	{
; 		--( pxQueue->cRxLock );
	ldd 2,x
	addd #47
	std -4,x
	tfr d,y
	pshy ; spill
	ldy -4,x
	puly ; reload
	dec 0,y
; 
; 		if( pxQueue->cRxLock > queueUNLOCKED )
	ldy 2,x
	ldab 47,y
	cmpb #-1
	ble L76
; 		{
; 			pxQueue->cRxLock = queueUNLOCKED;
	ldy 2,x
	ldab #-1
	stab 47,y
; 
; 			if( !listLIST_IS_EMPTY( &( pxQueue->xTasksWaitingToSend ) ) )
	ldy 2,x
	ldd 8,y
	beq L78
; 			{
; 				if( cTaskRemoveFromEventList( &( pxQueue->xTasksWaitingToSend ) ) != ( signed portCHAR ) pdFALSE )
	ldd 2,x
	addd #8
	jsr _cTaskRemoveFromEventList
	std -8,x
	tst -7,x
	beq L80
; 				{
; 					cYieldRequired = ( signed portCHAR ) pdTRUE;
	ldab #1
	stab -1,x
; 				}
L80:
; 			}
L78:
; 		}
L76:
; 	}
; 	taskEXIT_CRITICAL();
	jsr _vPortExitCritical
; 
; 	return cYieldRequired;
	ldab -1,x
	tfr b,d
L69:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
;          ?temp -> -4,x
;        cReturn -> -1,x
;        pxQueue -> 2,x
_prvIsQueueEmpty:
	pshd
	pshx
	tfr s,x
	leas -4,sp
; }
; /*-----------------------------------------------------------*/
; 
; static signed portCHAR prvIsQueueEmpty( const xQueueHandle pxQueue )
; {
; signed portCHAR cReturn;
; 
; 	taskENTER_CRITICAL();
	jsr _vPortEnterCritical
; 		cReturn = ( pxQueue->ucMessagesWaiting == ( unsigned portCHAR ) 0 );
	ldy 2,x
	tst 44,y
	bne L84
	ldd #1
	std -4,x
	bra L85
L84:
	ldd #0
	std -4,x
L85:
	ldab -3,x
	stab -1,x
; 	taskEXIT_CRITICAL();
	jsr _vPortExitCritical
; 
; 	return cReturn;
	ldab -1,x
	tfr b,d
L82:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
;          ?temp -> -4,x
;        cReturn -> -1,x
;        pxQueue -> 2,x
_prvIsQueueFull:
	pshd
	pshx
	tfr s,x
	leas -4,sp
; }
; /*-----------------------------------------------------------*/
; 
; static signed portCHAR prvIsQueueFull( const xQueueHandle pxQueue )
; {
; signed portCHAR cReturn;
; 
; 	taskENTER_CRITICAL();
	jsr _vPortEnterCritical
; 		cReturn = ( pxQueue->ucMessagesWaiting == pxQueue->ucLength );
	ldy 2,x
	ldab 44,y
	ldy 2,x
	cmpb 45,y
	bne L88
	ldd #1
	std -4,x
	bra L89
L88:
	ldd #0
	std -4,x
L89:
	ldab -3,x
	stab -1,x
; 	taskEXIT_CRITICAL();
	jsr _vPortExitCritical
; 
; 	return cReturn;
	ldab -1,x
	tfr b,d
L86:
	tfr x,s
	pulx
	leas 2,sp
	.dbline 0 ; func end
	rts
	.even
L15:
	.word 0,0
