/* This file is part of an "unsupported" FreeRTOS port distribution for
 * Freescale MC9S12DP256B CPU.
 */

#ifndef PORTMACRO_H
#define PORTMACRO_H

#include "projdefs.h"
#include "version.h"

/*-----------------------------------------------------------
 * Port specific definitions for the Motorola port.
 *----------------------------------------------------------*/

/* These are the only definitions that can be modified!. */

#define portUSE_PREEMPTION		1
#define portCPU_CLOCK_HZ		( ( unsigned portLONG ) 16000000 )
#define portTICK_RATE_HZ		( ( portTickType ) 1000 )
#define portMAX_PRIORITIES		( ( unsigned portCHAR ) 7 )
#define portMINIMAL_STACK_SIZE	( ( unsigned portSHORT ) 100 )
#define portTOTAL_HEAP_SIZE		( ( unsigned portSHORT ) ( 1500 ) )

/* Set the following definitions to 1 to include the component, or zero
to exclude the component. */

/* Include/exclude the stated API function. */
#define INCLUDE_vTaskPrioritySet			0
#define INCLUDE_ucTaskPriorityGet		0
#define INCLUDE_vTaskDelete				1
#define INCLUDE_vTaskCleanUpResources	0
#define INCLUDE_vTaskSuspend				0

/* Use/don't use the trace visualisation. */
#define USE_TRACE_FACILITY					0

/*
 * The tick count (and times defined in tick count units) can be either a 16bit
 * or a 32 bit value.  See documentation on http://www.FreeRTOS.org to decide
 * which to use.
 */
#define USE_16_BIT_TICKS					0


/*-----------------------------------------------------------
 * Do not modify anything below here.
 *----------------------------------------------------------*/

#define portCHAR								char
#define portFLOAT								float
#define portDOUBLE							double
#define portLONG								long
#define portSHORT								short
#define portSTACK_TYPE						unsigned portCHAR

#define portBYTE_ALIGNMENT					1

#if( USE_16_BIT_TICKS == 1 )
	typedef unsigned portSHORT portTickType;
	#define portMAX_DELAY ( portTickType ) 0xffff
#else
	typedef unsigned portLONG portTickType;
	#define portMAX_DELAY ( portTickType ) 0xffffffff
#endif

/*-----------------------------------------------------------*/
#define __asm__(x) asm(x)
/*-----------------------------------------------------------*/
#define RTIE   1<<7   /* Real Time Interrupt bit */
#define portDISABLE_RTI_INTERRUPT()       CRGINT &=~ RTIE
#define portENABLE_RTI_INTERRUPT()        CRGINT |= RTIE
/*-----------------------------------------------------------*/
void vPortEnterCritical(void);
void vPortExitCritical(void);
#define portENTER_CRITICAL()					vPortEnterCritical()
#define portEXIT_CRITICAL()					vPortExitCritical()

#define portDISABLE_INTERRUPTS()			__asm__("sei")
#define portENABLE_INTERRUPTS()			__asm__("cli")


/*-----------------------------------------------------------*/

#define portSTACK_GROWTH						( -1 )

/*-----------------------------------------------------------*/
#define portTICK_RATE_MS			( ( portTickType ) 1000 / portTICK_RATE_HZ )

/*-----------------------------------------------------------*/
void volatile vPortYield(void);


#define vPortIsrHead()                       \
   {                                         \
      /* perform context switch */           \
      portSAVE_CONTEXT();                    \
      vTaskIncrementTick();                  \
      vTaskSwitchContext();                  \
      portRESTORE_CONTEXT();                 \
   }

#define vPortIsrTail()                       \
   {                                         \
      /* reset pending RTI interrupt */      \
      CRGFLG |= 0x80;                        \
      __asm__("rti");                        \
   }

#define portYIELD()					         vPortYield()

/* hardware interrupt handler saves CCR, A, B, X, Y, so there's no need to save
 * them one more time */
#define portSAVE_CONTEXT()                \
{                                         \
	__asm__("ldaa 0x30");                  \
	__asm__("psha");                       \
	__asm__("ldx _pxCurrentTCB");          \
	__asm__("sts 0, x");                   \
}

#define portRESTORE_CONTEXT()             \
{                                         \
	__asm__("ldx _pxCurrentTCB");          \
	__asm__("lds 0, x");                   \
	__asm__("pulb");                       \
	__asm__("stab 0x30");                  \
}

#endif /* PORTMACRO_H */

