/******************************************************************************
*
*  NAME:       test.c
*
******************************************************************************/


/******************************************************************************
*  I N C L U D E    F I L E S
******************************************************************************/
#include <stddef.h>
#include <stdio.h>
#include <string.h>
#include "task.h"
#include "semphr.h"


/******************************************************************************
*  L O C A L   D E F I N I T I O N S
******************************************************************************/
#define SCI_TDRE  bit(7)
#define PLLSEL    bit(7)
#define LOCK      bit(3)
#define CME       bit(7)
#define PLLON     bit(6)
#define AUTO      bit(5)
#define ACQ       bit(4)
#define SCME      bit(0)


/*****************************************************************************
*  S T A T I C   D A T A
*****************************************************************************/
const char *message[] =   {
                           "task0 count= ",
                           "task2 count= ",
                           "task3 count= "
                          };

const char *tsk_name[] =  {
                           "test0",
                           "test1",
                           "test2"
                          };
xSemaphoreHandle xSemaphore;


/******************************************************************************
*  S T A T I C    F U N C T I O N    P R O T O T Y P E S
******************************************************************************/
void testTask0 (void *p);
void testTask1 (void *p);
void testTask2 (void *p);
void ltoda     (char *buf, long bin_val);
void hwInit    (void);


/******************************************************************************
*
*  FUNCTION:   main
*
******************************************************************************/
void main (void)
{
   xTaskHandle xHandle;

   hwInit ();

   vSemaphoreCreateBinary (xSemaphore);

   (void) sTaskCreate (testTask0, (signed portCHAR *)tsk_name[0], 200,
                       NULL, tskIDLE_PRIORITY, &xHandle);
   (void) sTaskCreate (testTask1, (signed portCHAR *)tsk_name[1], 200,
                       NULL, 1, &xHandle);
   (void) sTaskCreate (testTask2, (signed portCHAR *)tsk_name[2], 200,
                       NULL, 2, &xHandle);
   vTaskStartScheduler (portUSE_PREEMPTION);
}


/******************************************************************************
*
* Function:       testTask0
*                 testTask1
*                 testTask2
*
* Description:    OS test tasks (identical except in name)
*
******************************************************************************/
void testTask0 (void *p)
{
   char *strMsg = (char*)message[0];
   static unsigned int count = 0;
   char long_ascii[12 + 2];

   (void) p;

   /* Yield to scheduler immediately if semaphore unavailable */
   while (cSemaphoreTake (xSemaphore, 100) != pdTRUE)
   {
      portYIELD();
   }

   for (;;)
   {
      /*
      ** Send task identifier to UART
      */
      while (!(SCISR1 & SCI_TDRE))
         /*
         ** Yield to scheduler immediately if transmit buffer unavailable so
         ** other potentially useful work can be done
         */
         portYIELD();

      SCIDRL = *strMsg++;

      /*
      ** Send count if task identifer message finished
      */
      if (*strMsg == '\0')
      {
         /* This function uses less stack space than sprintf */
         ltoda (long_ascii, count);
         strcat (long_ascii, "\r\n");

         /*
         ** Send count to UART
         */
         for (strMsg = long_ascii; *strMsg; strMsg++)
         {
            while (!(SCISR1 & SCI_TDRE))
            {
               /*
               ** Yield to scheduler immediately if transmit buffer unavailable
               ** so other potentially useful work can be done
               */
               portYIELD();
            }
            SCIDRL = *strMsg;
         }

         /* Increment task count and restore task ident string pointer */
         count++;
         strMsg = (char*)message[0];

         /*
         ** Release the semaphore & wait for tick to allow the other tasks to
         ** take it
         */
         cSemaphoreGive (xSemaphore);
         vTaskDelay (1);

         /*
         ** Yield to scheduler immediately if semaphore unavailable so other
         ** potentially useful work can be done
         */
         while (cSemaphoreTake (xSemaphore, 100) != pdTRUE)
            portYIELD();
      }
   }
}

void testTask1 (void *p)
{
   char *strMsg = (char*)message[1];
   static unsigned int count = 0;
   char long_ascii[12 + 2];

   (void) p;

   while (cSemaphoreTake (xSemaphore, 100) != pdTRUE)
      portYIELD();
   for (;;)
   {
      while (!(SCISR1 & SCI_TDRE))
         portYIELD();
      SCIDRL = *strMsg++;
      if (*strMsg == '\0')
      {
         ltoda (long_ascii, count);
         strcat (long_ascii, "\r\n");
         for (strMsg = long_ascii; *strMsg; strMsg++)
         {
            while (!(SCISR1 & SCI_TDRE))
               portYIELD();
            SCIDRL = *strMsg;
         }
         count++;
         strMsg = (char*)message[1];
         cSemaphoreGive (xSemaphore);
         vTaskDelay (1);
         while (cSemaphoreTake (xSemaphore, 100) != pdTRUE)
            portYIELD();
      }
   }
}

void testTask2 (void *p)
{
   char *strMsg = (char*)message[2];
   static unsigned int count = 0;
   char long_ascii[12 + 2];

   (void) p;

   while (cSemaphoreTake (xSemaphore, 100) != pdTRUE)
      portYIELD();
   for (;;)
   {
      while (!(SCISR1 & SCI_TDRE))
         portYIELD();
      SCIDRL = *strMsg++;
      if (*strMsg == '\0')
      {
         ltoda (long_ascii, count);
         strcat (long_ascii, "\r\n");
         for (strMsg = long_ascii; *strMsg; strMsg++)
         {
            while (!(SCISR1 & SCI_TDRE))
               portYIELD();
            SCIDRL = *strMsg;
         }
         count++;
         strMsg = (char*)message[2];
         cSemaphoreGive (xSemaphore);
         vTaskDelay (1);
         while (cSemaphoreTake (xSemaphore, 100) != pdTRUE)
            portYIELD();
      }
   }
}


/******************************************************************************
*
* Function:       hwInit
*
* Description:    Start pll and init sci
*
* Parameters:       I/O    Description
* ----------------------------------------------------------------------------
* - none
*
* Returns:
* - none
*
******************************************************************************/
void hwInit (void)
{
   /*
   ** Setup PLL (if not active)
   */
   if (!(CLKSEL & PLLSEL))
   {
      /*
      ** Osc = 8MHz assumed
      ** Set PLL at 48MHz = 2 * 8MHz * ((SYNR + 1) / (REFDV + 1))
      ** Bus Clock = PLL/2 = 24MHz
      ** Poll LOCK bit of CRG Flags Register to determine when PLL stable
      ** ..before selecting PLL as clock source
      */
      SYNR   = 2;
      REFDV  = 0;
      PLLCTL = CME | PLLON | AUTO | ACQ | SCME ;
      while (!(CRGFLG & LOCK));
      CLKSEL |= PLLSEL;
   }

   /* initialize SCI: baud rate = 115200 with bus clock 16MHz */
   SCICR1  = 0x00;
   SCICR2  = 0x0c;
   SCIBD   = 13;
}


/******************************************************************************
*
* Function:       ltoda
*
* Description:    Convert signed long binary to decimal ascii
*
* Parameters:       I/O    Description
* ----------------------------------------------------------------------------
* char*              O     - pointer to dest. string buffer (min len = 12)
* long               I     - binary signed long
*
* Returns:
* - none
*
* Note:           Calling routine must allocate dest. buffer of length 12
*
******************************************************************************/
#define MAX_LEN 11
void ltoda (char *buf, long bin_val)
{
   /*
   ** -2147483647 <= bin_val <= 2147483648 ===> 10 (digits) + 1 (sign)
   */
   char        ascii_str[MAX_LEN + 1]; /* + 1 for zero terminator */
   const char *dec_digits = "0123456789";
   char       *s;
   int         sign;

   if (sign = bin_val < 0)
      bin_val = 0 - bin_val;
   s = &ascii_str[MAX_LEN];
   *s = 0;
   do
   {
      *--s = dec_digits[bin_val % 10];
      bin_val /= 10;
   } while (bin_val);

   if (sign)
      *--s = '-';
   strcpy (buf, s);
}