/******************************************************************************
*
* FILE NAME:   vectors.c
*
* FUNCTION:    interrupt jump table for s912c32
*
******************************************************************************/

/******************************************************************************
*  L O C A L   D E F I N I T I O N S
******************************************************************************/
#define DUMMY_ENTRY  (void (*)(void))0xFFFF


/******************************************************************************
*  E X T E R N A L    F U N C T I O N   P R O T O T Y P E S
******************************************************************************/
#pragma nonpaged_function _start
extern void _start      (void);     /* entry point in crt??.s */

extern void rtiHandler  (void);
//extern void sciHandler  (void);


/******************************************************************************
*  I N T E R R U P T   J U M P   T A B L E
******************************************************************************/
#pragma abs_address:0xFF80
void (*interrupt_vectors[])(void) =
   {
   /* to cast a constant, say 0xb600, use
      (void (*)())0xb600
    */
   DUMMY_ENTRY, /*Reserved $FF80*/
   DUMMY_ENTRY, /*Reserved $FF82*/
   DUMMY_ENTRY, /*Reserved $FF84*/
   DUMMY_ENTRY, /*Reserved $FF86*/
   DUMMY_ENTRY, /*PWM Emerg Shutdown*/
   DUMMY_ENTRY, /*VREG LVI*/
   DUMMY_ENTRY, /*PWM Emerg Shutdown*/
   DUMMY_ENTRY, /*Port P*/
   DUMMY_ENTRY, /*Reserved $FF90*/
   DUMMY_ENTRY, /*Reserved $FF92*/
   DUMMY_ENTRY, /*Reserved $FF94*/
   DUMMY_ENTRY, /*Reserved $FF96*/
   DUMMY_ENTRY, /*Reserved $FF98*/
   DUMMY_ENTRY, /*Reserved $FF9A*/
   DUMMY_ENTRY, /*Reserved $FF9C*/
   DUMMY_ENTRY, /*Reserved $FF9E*/
   DUMMY_ENTRY, /*Reserved $FFA0*/
   DUMMY_ENTRY, /*Reserved $FFA2*/
   DUMMY_ENTRY, /*Reserved $FFA4*/
   DUMMY_ENTRY, /*Reserved $FFA6*/
   DUMMY_ENTRY, /*Reserved $FFA8*/
   DUMMY_ENTRY, /*Reserved $FFAA*/
   DUMMY_ENTRY, /*Reserved $FFAC*/
   DUMMY_ENTRY, /*Reserved $FFAE*/
   DUMMY_ENTRY, /*CAN Transmit*/
   DUMMY_ENTRY, /*CAN Receive*/
   DUMMY_ENTRY, /*CAN Errors*/
   DUMMY_ENTRY, /*CAN Wake-up*/
   DUMMY_ENTRY, /*Flash*/
   DUMMY_ENTRY, /*Reserved $FFBA*/
   DUMMY_ENTRY, /*Reserved $FFBC*/
   DUMMY_ENTRY, /*Reserved $FFBE*/
   DUMMY_ENTRY, /*Reserved $FFC0*/
   DUMMY_ENTRY, /*Reserved $FFC2*/
   DUMMY_ENTRY, /*SCME*/
   DUMMY_ENTRY, /*CRG Lock*/
   DUMMY_ENTRY, /*Reserved $FFC8*/
   DUMMY_ENTRY, /*Reserved $FFCA*/
   DUMMY_ENTRY, /*Reserved $FFCC*/
   DUMMY_ENTRY, /*Port J*/
   DUMMY_ENTRY, /*Reserved $FFD0*/
   DUMMY_ENTRY, /*ATD */
   DUMMY_ENTRY, /*Reserved $FFD4*/
//   sciHandler,  /*SCI*/
   DUMMY_ENTRY,  /*SCI*/
   DUMMY_ENTRY,  /*SPI*/
   DUMMY_ENTRY, /*Pulse Accumulator A Input Edge*/
   DUMMY_ENTRY, /*Pulse Accumulator A Overflow*/
   DUMMY_ENTRY, /*Timer Overflow*/
   DUMMY_ENTRY, /*Timer Channel 7*/
   DUMMY_ENTRY, /*Timer Channel 6*/
   DUMMY_ENTRY, /*Timer Channel 5*/
   DUMMY_ENTRY, /*Timer Channel 4*/
   DUMMY_ENTRY, /*Timer Channel 3*/
   DUMMY_ENTRY, /*Timer Channel 2*/
   DUMMY_ENTRY, /*Timer Channel 1*/
   DUMMY_ENTRY, /*Timer Channel 0*/
   rtiHandler,  /*Real Time Interrupt*/
   DUMMY_ENTRY, /*IRQ*/
   DUMMY_ENTRY, /*XIRQ*/
   DUMMY_ENTRY, /*SWI*/
   DUMMY_ENTRY, /*Unimplement Intruction Trap*/
   DUMMY_ENTRY, /*COP failure reset*/
   DUMMY_ENTRY, /*Clock monitor fail reset*/
   _start, /*Reset*/
   };
