AUDIO.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*April 5, 2004		1.02		- Bug fixes
*
*Author: Exequiel Rarama for the NanoCore12DX
*******************************************************************************
;Compiled using MCUez
;
;Port P, bit 0 is use to drive the speaker.
;The port pin will toggle on compare.
;
; ---------------------------
; Demo - Audio Routine
; ---------------------------

	include "C32Regs.INC"

;Public Function
	XDEF check_audio
	XDEF audio_init
	XDEF set_audio
	XDEF AudioOn

;Public Variables
	XDEF audio_timer
	XDEF audio_period
	XDEF audio_status

	XDEF audio_delay
	XDEF audio_counter

	XDEF audio_state

;Public Tones
	XDEF pwr_on_tone
	XDEF Ftone

DataSec:SECTION

;Audio Variables
audio_timer	ds	1		;audio tone duration timer
audio_ptr	ds	2		;pointer to audio tone table
audio_period	ds	2		;audio tone period
;
rep_addr	ds	2		;repetition address
rep_count	ds	1		;repetition counter
audio_status	ds	1

audio_delay	ds	2
audio_counter	ds	1
audio_state	ds	2

;
OC4mask1        equ     %00010000       ;IOS4 = 1, Bit 4 as output compare
OC4mask2        equ     %00010000       ;C4I = 1, Enable Interrupt
OC4mask3        equ     %00000001       ;OM4 = 0, OL4 = 1, toggel OC output line
OC4flag         equ     %00010000       ;C4F = 1 to clear Interrupt flag

OM4		equ	%10
OL4		equ	%01

AudioControl	equ	%00000001	;Port P bit 0 to control Audio

;***********************************************************************************************
NON_BANKED:SECTION

;
; Initialization
; --------------
;
audio_init
        movw    #$1ff,audio_period
        movb    #$ff,audio_timer

	movw	#AudioOn,audio_state
	clr	audio_status

OutPutCompare_init
	bset	DDRT,%01		;Bit 0 output the rest inputs

	bset	TSCR1,%10000000	;
	bset	TIOS,OC4mask1		;TEN=1 - Enable timer
	bset	TIE,OC4mask2		;enable OC4 interrupt
	bset	TFLG1,OC4flag		;clear flag

	movb	#4,audio_counter	;flash 4 times
	movw	#00,audio_delay
	rts

audio_ready
	rts


AudioOn
	ldx	audio_delay
	bne	AudioEx

	ldx	#Ftone
	jsr	set_audio		;Blink/Sound LED/SPEAKER

	movw	#122/2,audio_delay		

	dec	audio_counter	
	bne	AudioEx

	movw	#audio_ready,audio_state

AudioEx
	rts

;
;-----------------------------------------------------------------------------------------------
;
set_audio
        sei
        stx     audio_ptr
        clr     audio_timer
        cli
        rts
;
;------------
; Check Audio
;------------
check_audio
        ldaa    audio_timer             ;decrement audio duration timer
        beq     aud05                   ;  unless already timed out (0)
        inca                            ;  OR infinite duration (FF)
        beq     audex

        dec     audio_timer
        bne     audex

aud05
        ldx     audio_ptr               ;get pointer to audio table
        ldaa    0,x                     ;get next tone duration time & skip
        staa    audio_timer             ;  if not a repetition indicator
        bne     aud20                   ;  (0 = repetition indicator)

        ldaa    1,x                     ;skip if end of repetition (2nd byte
        beq     aud10                   ;  = 0)
        staa    rep_count               ;else, start of repetition:  store
        inx                             ;  number of repetitions & starting
        inx                             ;  address
        stx     rep_addr
        stx     audio_ptr
        bra     audex
;
aud10
        ldaa    rep_count
        inca
        beq     aud15
        dec     rep_count               ;end of repetition: skip if repetition
        beq     aud50                   ;  counter has counted down
;
aud15
        ldx     rep_addr                ;else, restore 'start of repetition'
        stx     audio_ptr               ;  address
        bra     audex
;
aud20
        ldd     1,x                     ;set new audio tone period & duration
        std     audio_period            ;  audio is off (=0)
        beq     aud30

        sei				;disable interrupt a bit
        addd    TC4
        std     TC4
        cli				;reenable interrupt again

;	bclr    TCTL1,OM4		;OM4=0
;	nop
;	nop
;	bset    TCTL1,OL4		;OL4=1, enable audio control line

        bra     aud40

aud30
;	bclr    TCTL1,OL4		;OL4=0
;	nop
;	nop
;	bset    TCTL1,OM4		;OM7=1 disable audio control line

	bclr	PORTT,AudioControl

aud40
        inx                             ;increment and save audio table

aud50
        inx                             ;  pointer
        inx
        stx     audio_ptr

audex
        rts
;
;----------------------------------------------------------------------------
pwr_on_tone
	dc.b	20,20,20
	dc.b	20,40,$50
	dc.b	20,20,20

	dc.b	140,40,0
	dc.b	240,30,255

	dc.b	80,50,0
	dc.b	80,50,0
	dc.b	80,40,$64

	dc.b	140,40,0
	dc.b	240,30,255

	dc.b	$ff,0,0


Ftone
	dc.b	20,20,20
	dc.b	$ff,0,0


	END
