;MAIN.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*April 5, 2004		1.02		- Bug fixes
*
*Author: Exequiel Rarama for the NanoCore12DX
*******************************************************************************
;Compiled using MCUez
;
; ---------------------------
; Demo - Main Routine
; ---------------------------

;C32regs.INC CONTAINS ALL REGISTERS
	include "C32Regs.INC"

;Public Function
	XDEF ResetFunc
	XDEF delay

;Public Variables
	XDEF COMMAND
	XDEF COMMAND_PENDING
	XDEF CONTINUOUS

	XDEF state
	XDEF state_timer

;External Function
	XREF RealTimeInit
	XREF audio_init

	XREF ShowAnalog
	XREF ProcessCommand

	XREF ShowMenu
	XREF set_audio

	XREF go_power
	XREF HardwareTestInit

	XREF SerInputInt0
	XREF RealTimeInt
	XREF audio_int

	XREF goReady

;External Tones
	XREF pwr_on_tone
	XREF Ftone

;External Variables
	XREF audio_state
	XREF hardware_state


*  Operational Parameters
*  Operational Parameters

RAM		equ	$2000		;9S12E128 internal RAM
STACK		equ	$3F80		;Stack at below Ubug12
FLASH		equ	$4000		;Flash start address

OscFreq		equ	8000		;Enter Osc speed
initSYNR	equ	$02		; mult by synr + 1 = 3 (24MHz)
initREFDV	equ	$00		;
PLLSEL		equ	%10000000	;PLL select bit
LOCK		equ	%00001000	;lock status bit
PLLON		equ	%01000000	;phase lock loop on bit
LED		equ	%00000001	;Port P bit 0

DataSec:SECTION

* System Variables

state		ds	2
state_timer	ds	2

COMMAND		ds	1		;used by ProcessCommand
COMMAND_PENDING	ds	1		;used by ProcessCommand
CONTINUOUS	ds	1		;flag for real-time a/d screen update

***************************** Program *******************************

NON_BANKED:SECTION

ResetFunc				;This is where the RESET vector points to
	sei				;Disable Any interrupts

	movb	#$00,INITRG		;set registers at $0000 
	movb	#$39,INITRM		;move and set ram to end at $3fff 

;Initialize Stack
	lds	#STACK			;initialize stack pointer

; Initialize clock generator and PLL
	bclr	CLKSEL,PLLSEL      	;disengage PLL to system
	bset	PLLCTL,PLLON       	;turn on PLL

	movb	#initSYNR,SYNR     	;set PLL multiplier 
	movb	#initREFDV,REFDV   	;set PLL divider
	nop
	nop
	brclr	CRGFLG,LOCK,*+0    	;while (!(crg.crgflg.bit.lock==1))
	bset	CLKSEL,PLLSEL      	;engage PLL to system

	jsr	go_power		;
	jsr	RealTimeInit		;Initialize SCI and RTI

	jsr	audio_init		;Initialize bit 0 of PORTP as audio o/p
	jsr	HardwareTestInit	;Initialize for Hardware Checking

	clr	COMMAND_PENDING
	clr	CONTINUOUS

	cli				;unmask interrupts
	jsr	ShowMenu


;------------------------------------------------------------------------------
main					;Main Loop
	jsr	ProcessCommand		;this is the program loop
	ldaa	CONTINUOUS
	beq	NotCont
	jsr	ShowAnalog

NotCont
	ldx	state			;Process state command
	jsr	0,x

	ldx	hardware_state		;Go check hardware
	jsr	0,x

	ldx	audio_state		;Process audio command
	jsr	0,x

	bra	main


;------------------------------------------------------------------------------
;small delay
delay
	pshy
	ldy	#0

dly
	dbne	y,dly			;decrement y counter
	puly
	rts

;===============================================================================
VectorTable:SECTION			;Definition of Vector tables
	dc.w	ResetFunc		;Reserve
	dc.w	ResetFunc		;Reserve
	dc.w	ResetFunc		;Reserve
	dc.w	ResetFunc		;Reserve

	dc.w	ResetFunc		;PWM Emergency Shutdown
	dc.w	ResetFunc		;VREG LVI
	dc.w	ResetFunc		;Port P
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved

	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;CAN transmit
	dc.w	ResetFunc		;CAN receive
	dc.w	ResetFunc		;CAN errors
	dc.w	ResetFunc		;CAN wake-up
	dc.w	ResetFunc		;FLASH

	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserve
	dc.w	ResetFunc		;Reserve

	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved

	dc.w	ResetFunc		;CRG Self Clock Mode
	dc.w	ResetFunc		;CRG PLL lock
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved

	dc.w	ResetFunc		;Port J (PIEP)
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;ATD (ATDCTL2 - ASCIE)
	dc.w	ResetFunc		;Reserved
	dc.w	SerInputInt0		;SCI
	dc.w	ResetFunc		;SPI
	dc.w	ResetFunc		;Pulse Accumulator 0 input edge
	dc.w	ResetFunc		;Pulse Accumulator 0 overflow
	dc.w	ResetFunc		;Standard Timer 0 Overflow
	dc.w	ResetFunc		;Timer 0 Channel 7
	dc.w	ResetFunc		;Timer 0 Channel 6
	dc.w	ResetFunc		;Timer 0 Channel 5
	dc.w	audio_int		;Timer 0 Channel 4

	dc.w	ResetFunc		;Timer 0 Channel 3
	dc.w	ResetFunc		;Timer 0 Channel 2
	dc.w	ResetFunc		;Timer 0 Channel 1
	dc.w	ResetFunc		;Timer 0 Channel 0

	dc.w	RealTimeInt		;Real Time Interrupt
	dc.w	ResetFunc		;IRQ
	dc.w	ResetFunc		;XIRQ
	dc.w	ResetFunc		;SWI
	dc.w	ResetFunc		;Instruction Trap
	dc.w	ResetFunc		;COP failure
	dc.w	ResetFunc		;Clock Monitor
	dc.w	ResetFunc		;Power On Reset

	END