// filename ************** SPI.C *****************************
// Interrupting I/O routines to 9S12C32 SPI port 
// Jonathan W. Valvano 4/8/04

//  This example accompanies the books
//   "Embedded Microcomputer Systems: Real Time Interfacing",
//         Brooks-Cole, copyright (c) 2000,
//   "Introduction to Embedded Microcomputer Systems: 
//    Motorola 6811 and 6812 Simulation", Brooks-Cole, copyright (c) 2002

// Copyright 2004 by Jonathan W. Valvano, valvano@mail.utexas.edu 
//    You may use, edit, run or distribute this file 
//    as long as the above copyright notice remains 
#include <hidef.h>      /* common defines and macros */
#include <mc9s12c32.h>  /* derivative information */
#include "SPI.H"

unsigned short Timeout;

//---------- Initialize SPI-----------------
// Turn on SPI, 12 kHz or	85 usec period
// Input: none
// Output: none
void SPI_Init(void){  unsigned char dummy;
  DDRM |= 0x38;  
/* bit SPICR1
 7 SPIE = 0   no interrupts
 6 SPE  = 1   enable SPI
 5 SWOM = 0   regular outputs
 4 MSTR = 1   master
 3 CPOL = 0   output changes on fall, 
 2 CPHA = 0   clock normally low
 1 SSOE = 1   enable SS
 0 LSBF = 0   most sign bit first */
  SPICR1 = 0x52;
/* bit SPICR2
 4 MODFEN = 1  Mode Fault Enable Bit  
 3 BIDIROE= 0  Output enable in the Bidirectional mode of operation
 1 SPISWAI= 0  SPI Stop in Wait Mode Bit
 0 SPC0   = 0  normal mode */
  SPICR2 = 0x10;
  SPIBR = 0x77;		// baud rate 
  // bits 6,5,4 are SPPR, bits 2,1,0 are SPR
  // divisor is (1+SPPR)*2**(SPR+1) = 8*2**8 = 2048
  // frequency = 24MHz/divisor = 12 kHz or	85 usec period
  dummy = SPISR;
  dummy = SPIDR;  //clear SPIF
} 

// *************** SPI_Data ********************
// perform simultaneous Output and Input using SPI
// Input: data 8-bit data to be shifted out MOSI
// Output: 8-bit SPI data shifted in MISO
// result is 0xFF if there is a SPI timeout error
unsigned char SPI_Data(unsigned char data){ unsigned char result;
  SPIDR = data;
  Timeout = 50000;
  while(((SPISR&0x80)==0)&&Timeout){
    Timeout--;			 	// wait for SPIF=1 or timeout
  }
  result = SPIDR;
  if(Timeout == 0){
    result = 0xFF; // SPI broken or not initialized
  }
  return result;
} 
       
// *************** SPI_Stop ********************
// disable SPI
// Input: none
// Output: none
void SPI_Stop(void){ 
  SPICR1 = 0;
  DDRM = 0;  
}
