// filename ************** SPI.h *****************************
// Interrupting I/O routines to 9S12C32 SPI port 
// Jonathan W. Valvano 4/8/04

//  This example accompanies the books
//   "Embedded Microcomputer Systems: Real Time Interfacing",
//         Brooks-Cole, copyright (c) 2000,
//   "Introduction to Embedded Microcomputer Systems: 
//    Motorola 6811 and 6812 Simulation", Brooks-Cole, copyright (c) 2002

// Copyright 2004 by Jonathan W. Valvano, valvano@mail.utexas.edu 
//    You may use, edit, run or distribute this file 
//    as long as the above copyright notice remains 


//---------- Initialize SPI-----------------
// Turn on SPI, 12 kHz or	85 usec period
// Input: none
// Output: none
void SPI_Init(void);

// *************** SPI_Data ********************
// perform simultaneous Output and Input using SPI
// Input: data 8-bit data to be shifted out MOSI
// Output: 8-bit SPI data shifted in MISO
// result is 0xFF if there is a SPI timeout error
unsigned char SPI_Data(unsigned char data);
       
// *************** SPI_Stop ********************
// disable SPI
// Input: none
// Output: none
// result is 0xFFFF if there is a SPI timeout error
void SPI_Stop(void);
