;HardwareTest.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE                   REV. NO.        DESCRIPTION
*
*April 18, 2005		1.00		Initial release
*
*Author: Exequiel Rarama for M68MOD912C32
*******************************************************************************
;Compiled using Codewarrior Rev 3.1
;
; ---------------------------
; Demo - HardwareTest Routine
; ---------------------------

	include "C32Regs.INC"

;Public Function
	XDEF HardwareTestGo
	XDEF HardwareTestInit
	XDEF HardwareReady

;Public Variables
	XDEF hardware_state
	XDEF testFlag

;Public Tones

;External Function
	XREF SerOutput0
	XREF OutStr0	

	XREF SendDecByte		;Hex to Decimal conversion


;External Variables

	XREF adflag

DataSec:SECTION
Var		ds	3
hardware_state	ds	2
count		ds	1
Error		ds	1
testFlag	ds	1
PassFailFlag	ds	1

;

PUPAE		equ	%00000001		;Port A pullup
PUPBE		equ	%00000010
PUPEE		equ	%00010000
PUPKE		equ	%10000000

switch		equ	%01000000		;Port A bit 6

;***********************************************************************************************
NON_BANKED:SECTION
;
HardwareTestInit				;Testing the Hardware ports
	bset	PUCR,PUPAE+PUPBE+PUPEE+PUPKE	;Enable all pull up's

	movb	#$FF,PERT
	movb	#$FF,PERS
	movb	#$FF,PERM
	movb	#$FF,PERP
	movb	#$FF,PERJ
	movb	#$FF,PERAD

	movw	#HardwareReady,hardware_state
	clr	testFlag
	clr	PassFailFlag

goEx
	rts

HardwareReady
	rts


HardwareTestGo
	movw	#WaitForChar,hardware_state
;	ldx	#WarningMSG1
;	jsr	OutStr0

	ldx	#WarningMSG2
	jsr	OutStr0
	movb	#1,testFlag

	clr	PassFailFlag
	rts

WaitForChar
	ldaa	testFlag
	bne	WaitForCharEx

	movw	#HardwareTestADT,hardware_state
WaitForCharEx
	rts

;----------------------------------------------------------------------------------------------
;H2 header
;Port A <=> Port B

;H1 header
;Port U <=> Port S
;Port T <=> Port AD
;Port P <=> Port E special case where PP5 <-> PE7 and PE0,PE1 are i/p only

;Note: Port A,B,E do not have dedicated Input Port register

HardwareTestADT
;Initialize Analog To Digital
	movb	#$00,ATDCTL2	        ;enable ATD
	movb	#$00,ATDCTL3	        ;8 Channels ATD result
	movb	#$00,ATDCTL4		;Select Sample rate
	movb	#$00,ATDCTL5		;Select 8 channel mode, Continuous scan
	movb	#1,adflag

;Start checking on Port AD driving T
	ldx	#TestMSG5
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRAD	;make Port AD o/p
	movb	#$00,DDRT	;make Port T i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortT20

CheckPortT10
	lsl	Var

CheckPortT20
	dec	Var+1
	beq	CheckPortTDone

	movb	Var,PTAD
	movb	Var,PTAD

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PORTT
	ldab	PORTT
	cmpb	Var
	beq	CheckPortT10

	ldx	#Error2
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PORTT
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortT10	;Go continue the test

CheckPortTDone
	ldaa	Error
	beq	CheckPortTDoneEx10

	ldx	#Error7
	jsr	OutStr0
	bra	CheckPortTDoneEx

CheckPortTDoneEx10
	ldx	#TestMSG3
	jsr	OutStr0

CheckPortTDoneEx
	movw	#HardwareTestTAD,hardware_state
	rts

;----------------------------------------------------------------------------------------------
HardwareTestTAD
;Start checking on Port T driving AD
	movb	#$FF,ATDDIEN1		;Enable ATD channel as Digital input

	ldx	#TestMSG4
	jsr	OutStr0

	clr	Error

	movb	#$FF,DDRT	;make Port T o/p
	movb	#$00,DDRAD	;make Port ADL i/p

	movb	#1,Var		;Initialize to 1st bit
	movb	#9,Var+1	;Initialize counter	
	bra	CheckPortAD20

CheckPortAD10
	lsl	Var

CheckPortAD20
	dec	Var+1
	beq	CheckPortADDone

	movb	Var,PORTT
	movb	Var,PORTT

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldab	PTAD
	ldab	PTAD

	cmpb	Var
	beq	CheckPortAD10

	ldx	#Error2
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3
	jsr	OutStr0

	ldab	PTAD
	jsr	SendDecByte	;Convert Value

	movb	#1,Error	;Set error flag
	inc	PassFailFlag	;Error increment flag

	bra	CheckPortAD10	;Go continue the test

CheckPortADDone
	ldaa	Error
	beq	CheckPortADDoneEx10

	ldx	#Error6
	jsr	OutStr0
	bra	CheckPortADDoneEx

CheckPortADDoneEx10
	ldx	#TestMSG3
	jsr	OutStr0

CheckPortADDoneEx
	movb	#$80,ATDCTL2	        ;enable ATD
	movb	#$40,ATDCTL3	        ;8 Channels ATD result
	movb	#$60,ATDCTL4		;Select Sample rate
	movb	#$B0,ATDCTL5		;Select 8 channel mode, Continuous scan
	movb	#$00,ATDDIEN1		;Disable ATD channel as Digital input
	clr	adflag

	movw	#HardwareTestME,hardware_state
	rts

;---------------------------------------------------------------------------------------------
HardwareTestME
;Start checking on Port M driving Port E bit 0 and 1
	ldx	#TestMSG6
	jsr	OutStr0

	clr	Error

	movb	#$3,DDRM	;make Port Q o/p

CheckBit0
	movb	#$1,PORTM	;Make Port M bit 0 and Drive E bit 0

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldaa	PORTE
	anda	#$3		;Masked off bit 0 and 1

	cmpa	#1		;check if Zero
	beq	CheckBit1

	ldx	#Error4
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

CheckBit1
	movb	#$2,PORTM	;Make bit 1 high and Drive E

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldaa	PORTE
	anda	#3		;Masked off bit 0 and 1

	cmpa	#2		;check if Zero
	beq	TestPortM

	ldx	#Error5
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

TestPortM
	ldaa	Error
	bne	PortM3_5

	ldx	#TestMSG3
	jsr	OutStr0

PortM3_5
	ldx	#TestMSG7
	jsr	OutStr0

	clr	Error

	movb	#$8,DDRM	;make Port M bit 3 o/p to drive bit 5

	ldab	#0
	stab	PORTM
	stab	Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldaa	PORTM
	anda	#%00100000
	cmpa	#0
	beq	PortM3_5H

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTM
	jsr	SendDecByte	;Convert Value

	ldx	#Error8
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortM3_5H
	ldab	#8
	stab	PORTM
	stab	Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldaa	PORTM
	anda	#%00100000
	cmpa	#%00100000
	beq	PortM5_3

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTM
	jsr	SendDecByte	;Convert Value

	ldx	#Error8
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortM5_3
	movb	#%00100000,DDRM	;make Port M bit 5 o/p to drive bit 3

	ldab	#%00000000
	stab	PORTM
	stab	Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldaa	PORTM
	anda	#%00001000
	cmpa	#0
	beq	PortM2_4

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTM
	jsr	SendDecByte	;Convert Value

	ldx	#Error9
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortM2_4
	movb	#$4,DDRM	;make Port M bit 2 o/p to drive bit 4

	ldab	#0
	stab	PORTM
	stab	Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldaa	PORTM
	anda	#%00010000
	cmpa	#0
	beq	PortM2_4H

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTM
	jsr	SendDecByte	;Convert Value

	ldx	#Error10
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

PortM2_4H
	ldab	#%00000100
	stab	PORTM
	stab	Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldaa	PORTM
	anda	#%00010000
	cmpa	#%00010000
	beq	PortM4_2

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTM
	jsr	SendDecByte	;Convert Value

	ldx	#Error10
	jsr	OutStr0

PortM4_2
	movb	#%00010000,DDRM	;make Port M bit 2 o/p to drive bit 4

	ldab	#%00000000
	stab	PORTM
	stab	Var

	jsr	littleDelay	;delay to allow sw pin to pull up

	ldaa	PORTM
	anda	#%00000100
	cmpa	#%00000000
	beq	ExitM

	ldx	#Error2		;Sent message
	jsr	OutStr0

	ldab	Var
	jsr	SendDecByte	;Convert Value

	ldx	#Error3		;Receive message
	jsr	OutStr0

	ldab	PORTM
	jsr	SendDecByte	;Convert Value

	ldx	#Error11
	jsr	OutStr0

	movb	#1,Error
	inc	PassFailFlag	;Error increment flag

ExitM
	ldaa	Error
	bne	ExitTest

	ldx	#TestMSG3
	jsr	OutStr0

ExitTest
	ldaa	PassFailFlag	;Error increment flag
	beq	ExitTest10

	ldx	#HardwareFailed
	jsr	OutStr0
	bra	ExitTest20

ExitTest10
	ldx	#HardwarePass
	jsr	OutStr0

ExitTest20
	movw	#HardwareReady,hardware_state
	ldx	#WarningMSG3
	jsr	OutStr0
	rts


littleDelay
	pshb	
	clrb
	dbne	b,*           ;delay to allow sw pin to pull up
	pulb
	rts

;----------------------------------------------------------------------------------------------
WarningMSG2	dc.b	'Press Any Key when READY',$D,$A,0
WarningMSG3	dc.b	$D,$A,'Press RESET when DONE',$D,$A,0
HardwareFailed	dc.b	$D,$A,'Port TEST = FAILED',$D,$A,0
HardwarePass	dc.b	$D,$A,'Port TEST = PASS',$D,$A,0

TestMSG3	dc.b	'Pass',$D,$A,0

TestMSG4	dc.b	$D,$A,'Test ->Port T driving Port AD',$D,$A,0
TestMSG5	dc.b	$D,$A,'Test ->Port AD driving Port T',$D,$A,0
TestMSG6	dc.b	$D,$A,'Test ->Port M driving Port E bit 0 and 1',$D,$A,0
TestMSG7	dc.b	$D,$A,'Test ->Port M bit 2,3,4,5',$D,$A,0

Error1		dc.b	$D,$A,'Fail ->Port A driving Port B on H2',$D,$A,0
Error2		dc.b	$D,$A,'Sent    ',0
Error3		dc.b	$D,$A,'Receive ',0

Error4		dc.b	$D,$A,'Fail ->Port M bit 0 driving Port E bit 0 high',$D,$A,0
Error5		dc.b	$D,$A,'Fail ->Port M bit 1 driving Port E bit 1 high',$D,$A,0
Error5a		dc.b	$D,$A,'Fail ->Port M driving Port E ',$D,$A,0

Error6		dc.b	$D,$A,'Fail ->Port T driving Port AD on H1',$D,$A,0
Error7		dc.b	$D,$A,'Fail ->Port AD driving Port T on H1',$D,$A,0

Error8		dc.b	$D,$A,'Fail ->Port M bit 3 driving Port M bit 5',$D,$A,0
Error9		dc.b	$D,$A,'Fail ->Port M bit 5 driving Port M bit 3',$D,$A,0

Error10		dc.b	$D,$A,'Fail ->Port M bit 2 driving Port M bit 4',$D,$A,0
Error11		dc.b	$D,$A,'Fail ->Port M bit 4 driving Port M bit 2',$D,$A,0

	END
