;Author: Exequiel Rarama
;October 14, 2003
;
;MC68HC9S12C32 REGISTER MAP

REG:	EQU	$0000

PORTA:		EQU	$0000		;PORTA
PORTB:		EQU	$0001		;PORTB
DDRA:		EQU	$0002		;PORTA - DATA DIRECTION REGISTER
DDRB:		EQU	$0003		;PORTB - DATA DIRECTION REGISTER
PORTE:		EQU	$0008		;PORTE
DDRE:		EQU	$0009		;PORTE - DATA DIRECTION REGISTER
PEAR:		EQU	$000A		;PEAR - PORTE ASSIGNMENT REGISTER
MODE:		EQU	$000B		;MODE - MODE REGISTER
PUCR:		EQU	$000C		;PUCR - PULL UP CONTROL REGISTER
RDRIV:		EQU	$000D		;RDRIV - REDUCED DRIVE OF I/O LINES
EBICTL:		EQU	$000E		;EBITCTL - ESTR
INITRM:		EQU	$0010		;INITRM - INITIALIZATION OF INTERNAL RAM POSITION REGISTER
INITRG:		EQU	$0011		;INITRG - INITIALIZATION OF INTERNAL REGISTER POSITION REGISTER
INITEE:		EQU	$0012		;INITEE - INITIALIZATION OF INTERNAL EEPROM POSITION REGISTER
MISC:		EQU	$0013		;MISC - MISCELLANEOUS MAPPING CONTROL REGISTER

ITCR:		EQU	$0015
ITEST:		EQU	$0016

VREGCTRL:	EQU	$19

PARTIDH:		EQU	$001A
PARTIDL:	EQU	$001B
MEMSIZ0:		EQU	$001C
MEMSIZ1:		EQU	$001D

INTCR:		EQU	$001E           ;INTCR - INTERRUPT CONTROL REGISTER
HPRIO:		EQU	$001F           ;HPRIO - HIGHEST PRIORITY I INTERRRUPT

;Debug12
DBGC1:		EQU	$20
DBGSC:		EQU	$21
DBGTBH:		EQU	$22
DBGTBL:		EQU	$23
DBGCNT:		EQU	$24
DBGCCX:	EQU	$25
DBGCCH:		EQU	$26
DBGCCL:		EQU	$27
DBGC2:		EQU	$28
BKPCT0:		EQU	$28
DBGC3:		EQU	$29		
BKPCT1:		EQU	$29
DBGCAX:		EQU	$2A
BKP0X:		EQU	$2A
DBGCAH:		EQU	$2B
BKP0H:		EQU	$2B
DBGCAL:		EQU	$2C
BKP0L:		EQU	$2C
DBGCBX:		EQU	$2D
BKP1X:		EQU	$2D

DBGCBH:		EQU	$2E
BKP1H:		EQU	$2E
DBGCBL:		EQU	$2F
BKP1L:		EQU	$2F

PPAGE:		EQU	$0030

PORTK:		EQU	$0032
DDRK:		EQU	$0033

;CRG - Clock and Reset Generator
SYNR:		EQU	$0034           ;CRG synthesizer register
REFDV:		EQU	$0035           ;CRG reference divider register
CTFLG:		EQU	$0036		;TEST ONLY
CRGFLG:		EQU	$0037		;CRG flags register
CRGINT:		EQU	$0038
CLKSEL:		EQU	$0039		;CRG clock select register
PLLCTL:		EQU	$003A		;CRG PLL control register
RTICTL:		EQU	$003B
COPTCTL:		EQU	$003C
FORBYP:		EQU	$003D
CTCTL:		EQU	$003E
ARMCOP:		EQU	$003F

;TIM - Timer 16 Bit 8 Channels
TIOS:		EQU	$0040		;TIOS - TIMER INPUT CAPTURE/OUTPUT COMPARE SELECT
CFORC:		EQU	$0041		;CFORC - TIMER COMPARE FORCE REGISTER
OC7M:		EQU	$0042		;OC7M - OUTPUT COMPARE 7 MASK REGISTER
OC7D:		EQU	$0043		;OC7D - OUTPUT COMPARE 7 DATA REGISTER

TCNT:		EQU	$0044
TCNTH:		EQU	$0044
TCNTL:		EQU	$0045

TSCR1:		EQU	$0046		;TSCR - TIMER SYSTEM CONTROL REGISTER
TTOV:		EQU	$0047
TCTL1:		EQU	$0048		;TCTL1 - TIMER CONTROL REGISTER 1
TCTL2:		EQU	$0049		;TCTL2 - TIMER CONTROL REGISTER 3
TCTL3:		EQU	$004A		;TCTL3 - TIMER CONTROL REGISTER 3
TCTL4:		EQU	$004B		;TCTL4 - TIMER CONTROL REGISTER 3
TIE:		EQU	$004C
TSCR2:		EQU	$004D
TFLG1:		EQU	$004E		;TFLG1 - TIMER INTERRUPT FLAG 1
TFLG2:		EQU	$004F		;TFLG2 - TIMER INTERRUPT FLAG2

TC0:		EQU	$0050		;TC0 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC1:		EQU	$0052		;TC1 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC2:		EQU	$0054		;TC2 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC3:		EQU	$0056		;TC3 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC4:		EQU	$0058		;TC4 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC5:		EQU	$005A		;TC5 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC6:		EQU	$005C		;TC6 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0
TC7:		EQU	$005E		;TC7 - TIMER INPUT/CAPTURE COMPARE HIGH REGISTER0


PACTL:		EQU	$0060		;PATCL - PULSE ACCUMULATOR CONTROL REGISTER
PAFLG:		EQU	$0061		;PAFLG - PULSE ACCUMULATOR FLAG REGISTER
PACNT:		EQU	$0062		;PACN3 - HI BYTE
PACNTH:		EQU	$0062		;PACN3 - HI BYTE
PACNTL:		EQU	$0063		;PACN2 - LO BYTE

;ATD - Analog to Digital Converter 10 Bit 8 Channel
ATDCTL0:		EQU	$0080		;ATDCTL0 - RESERVED
ATDCTL1:		EQU	$0081		;ATDCTL1 - RESERVED
ATDCTL2:		EQU	$0082		;ATDCTL2 - ATD CONTROL REGISTER
ATDCTL3:		EQU	$0083		;ATDCTL3 - ATD CONTROL REGISTER
ATDCTL4:		EQU	$0084		;ATDCTL4 - ATD CONTROL REGISTER
ATDCTL5:		EQU	$0085		;ATDCTL5 - ATD CONTROL REGISTER
ATDSTAT0: 	EQU	$0086	

ATDTEST0:	EQU	$0088	;ATDTEST
ATDTEST1:	EQU	$0089	;ATDTEST

ATDSTAT1:	EQU	$8B
ATDDIEN1:	EQU	$8D

PORTAD0:		EQU	$008F		;PORTAD - PORT AD DATA INPUT REGISTER

ATDDR0H:		EQU	$0090
ATDDR0L:		EQU	$0091
ATDDR1H:		EQU	$0092
ATDDR1L:		EQU	$0093
ATDDR2H:		EQU	$0094
ATDDR2L:		EQU	$0095
ATDDR3H:		EQU	$0096
ATDDR3L:		EQU	$0097
ATDDR4H:		EQU	$0098
ATDDR4L:		EQU	$0099
ATDDR5H:		EQU	$009A
ATDDR5L:		EQU	$009B
ATDDR6H:		EQU	$009C
ATDDR6L:		EQU	$009D
ATDDR7H:		EQU	$009E
ATDDR7L:		EQU	$009F

;SCI - Asynchronous Serial Interface
SCIBDH:		EQU	$00C8		;SCI0BDH - SCI BAUD RATE CONTROL REGISTER
SCIBDL:		EQU	$00C9		;SCI0BDL - SCI BAUD RATE CONTROL REGISTER
SCICR1:		EQU	$00CA		;SCI0CR1 - SCI CONTROL REGISTER
SCICR2:		EQU	$00CB		;SCI0CR2 - SCI CONTROL REGISTER
SCISR1:		EQU	$00CC		;SCI0SR1 - SCI STATUS REGISTER
SCISR2:		EQU	$00CD		;SCI0SR2 - SCI STATUS REGISTER
SCIDRH:		EQU	$00CE		;SCI0DRH - SCI DATA REGISTER
SCIDRL:		EQU	$00CF		;SCI0DRL - SCI DATA REGISTER

;SPI - Serial Peripheral Interface
SPICR1:		EQU	$00D8		;SPI0CR1 - SPI CONTROL REGISTER
SPICR2:		EQU	$00D9		;SPI0CR2 - SPI CONTROL REGISTER
SPIBR:		EQU	$00DA		;SPI0BR - SPI BAUD RATE REGISTER
SPISR:		EQU	$00DB		;SPI0SR - SPI STATUS REGISTER
SPIDR:		EQU	$00DD		;SPI0DR - SPI DATA REGISTER

;PWM (Pulse width Modulator)
PWME:		EQU	$E0	
PWMPOL:		EQU	$E1
PWMCLK:		EQU	$E2
PWMPRCLK:	EQU	$E3
PWMCAE:		EQU	$E4
PWMCTL:		EQU	$E5
PWMTST:		EQU	$E6
PWMPRSC:		EQU	$E7
PWMSCLA:		EQU	$E8
PWMSCLB:		EQU	$E9
PWMSCNTA:	EQU	$EA
PWMSCNTB:	EQU	$EB

PWMCNT0:		EQU	$EC
PWMCNT1:		EQU	$ED
PWMCNT2:		EQU	$EE
PWMCNT3:		EQU	$EF
PWMCNT4:		EQU	$F0
PWMCNT5:		EQU	$F1

PWMPER0:		EQU	$F2
PWMPER1:		EQU	$F3
PWMPER2:		EQU	$F4
PWMPER3:		EQU	$F5
PWMPER4:		EQU	$F6
PWMPER5:		EQU	$F7

PWMDTY0:		EQU	$F8
PWMDTY1:		EQU	$F9
PWMDTY2:		EQU	$FA
PWMDTY3:		EQU	$FB
PWMDTY4:		EQU	$FC
PWMDTY5:		EQU	$FD
;reserve	EQU	$FE

;Flash Control Register
FCLKDIV:		EQU	$100
FSEC:		EQU	$101
FCNFG:		EQU	$103
FPROT:		EQU	$104
FSTAT:		EQU	$105
FCMD:		EQU	$106

;CAN (Motorola Scalable CAN - MSCAN)
CANCTL0:		EQU	$0140
CANCTL1:		EQU	$0141
CANBTR0:		EQU	$0142
CANBTR1:		EQU	$0143
CANRFLG:		EQU	$0144
CANRIER:		EQU	$0145
CANTFLG:		EQU	$0146
CANTIER:	EQU	$0147
CANTARQ:		EQU	$0148
CANTAAK:		EQU	$0149
CANTBSEL:	EQU	$014A
CANIDAC:		EQU	$014B
CANRXERR:	EQU	$014E
CANTXERR:	EQU	$014F
CANIDAR0:	EQU	$0150
CANIDAR1:	EQU	$0151
CANIDAR2:	EQU	$0152
CANIDAR3:	EQU	$0153
CANIDMR0:	EQU	$0154
CANIDMR1:	EQU	$0155
CANIDMR2:	EQU	$0156
CANIDMR3:	EQU	$0157
CANIDAR4:	EQU	$0158
CANIDAR5:	EQU	$0159
CANIDAR6:	EQU	$015A
CANIDAR7:	EQU	$015B
CANIDMR4:	EQU	$015C
CANIDMR5:	EQU	$015D
CANIDMR6:	EQU	$015E
CANIDMR7:	EQU	$015F
CANRXFG:		EQU	$0160		;RECEIVE BUFFER = $0160-$016F
CANTXFG:		EQU	$0170		;TRANSMIT BUFFER = $0170-$017F

;
PORTT:		equ	$0240	; Port T data register (alternate name).
PTT:		equ	$0240	; Port T data register.
PTIT:		equ	$0241	; Port T input pin register.
DDRT:		equ	$0242	; Port T data direction register.
RDRT:		equ	$0243	; Port T Reduced drive enable register.
PERT:		equ	$0244	; Port T pull up/down enable register.
PPST:		equ	$0245	; Port T pull up/down select (polarity) register.
;
MODRR:		equ	$247
;
PORTS:		equ	$0248	; Port S data register (alternate name).
PTS:		equ	$0248	; Port S data register.
PTIS:		equ	$0249	; Port S input pin register.
DDRS:		equ	$024a	; Port S data direction register.
RDRS:		equ	$024b	; Port S Reduced drive enable register.
PERS:		equ	$024c	; Port S pull up/down enable register.
PPSS:		equ	$024d	; Port S pull up/down select (polarity) register.
WOMS:		equ	$024E	; Port S Wired-Or (open drain) select register.
;
PORTM:		equ	$0250	; Port M data register (alternate name).
PTM:		equ	$0250	; Port M data register.
PTIM:		equ	$0251	; Port M input pin register.
DDRM:		equ	$0252	; Port M data direction register.
RDRM:		equ	$0253	; Port M Reduced drive enable register.
PERM:		equ	$0254	; Port M pull up/down enable register.
PPSM:		equ	$0255	; Port M pull up/down select (polarity) register.
WOMM:		equ	$0256	; Port M Wired-Or (open drain) select register.
;
PORTP:		equ	$0258	; Port P data register (alternate name).
PTP:		equ	$0258	; Port P data register.
PTIP:		equ	$0259	; Port P input pin register.
DDRP:		equ	$025a	; Port P data direction register.
RDRP:		equ	$025b	; Port P Reduced drive enable register.
PERP:		equ	$025c	; Port P pull up/down enable register.
PPSP:		equ	$025d	; Port P pull up/down select (polarity) register.
PIEP:		equ	$25e
PIFP:		equ	$25f
;
PORTJ:		equ	$0268	; Port J data register (alternate name).
PTJ:		equ	$0268	; Port J data register.
PTIJ:		equ	$0269	; Port J input pin register.
DDRJ:		equ	$026a	; Port J data direction register.
RDRJ:		equ	$026b	; Port J Reduced drive enable register.
PERJ:		equ	$026c	; Port J pull up/down enable register.
PPSJ:		equ	$026d	; Port J pull up/down select (polarity) register.
PEIJ:		equ	$026e	; Port J interrupt enable register.
PIFJ:		equ	$26f	; Port J
;
PORTAD:		EQU	$270
PTAD:		EQU	$270	
PTIAD:		equ	$271	; Port AD
DDRAD:		equ	$272	; Port AD
RDRAD:		equ	$273	; Port AD
PERAD:		equ	$274	; Port AD
PPSAD:		equ	$275	; Port AD


