;INT.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*March 22, 2004		1.00		Experimental MaggieBot 
*
*Author: Exequiel Rarama for the NanoCore12DX - 32 pin dip module
*******************************************************************************
;Compiled using MCUez

; ---------------------------
; Demo - ISR Routine
; ---------------------------


	include "C32Regs.INC"


;Public Function
	XDEF RealTimeInit
	XDEF RealTimeInt

	XDEF OutStr0
	XDEF SerOutput0
	XDEF SerInputInt0

	XDEF audio_int

;Public Variables
	XDEF ad0
	XDEF ad1
	XDEF ad2
	XDEF ad3
	XDEF ad4
	XDEF ad5
	XDEF ad6
	XDEF ad7

	XDEF TIMER
	XDEF TIMER1
	XDEF COUNTER

;External Function
	XREF check_audio
	
;External Variables
	XREF d_flag

	XREF COMMAND
	XREF COMMAND_PENDING
	XREF CONTINUOUS

	XREF roving_timer1
	XREF roving_timer2
	XREF backing_timer

	XREF audio_period
	XREF audio_status
	XREF audio_delay

	XREF RechargeTime
	XREF cap6Flag
	XREF EchoTime
	XREF EchoTimerMax

	XREF InterestTimer

DataSec:SECTION

;ATD ram variables
atd_var:

ad0:		ds	2
ad1:		ds	2
ad2:		ds	2
ad3:		ds	2
ad4:		ds	2
ad5:		ds	2
ad6:		ds	2
ad7:		ds	2

adflag:		ds	1

TIMER:		ds	2		;software timers using RTI
TIMER1:		ds	2
COUNTER:		ds	1

;------------------------------------------------------------------------------
;ATD Variables
admask2:         equ     %11000000       ;AFFC,ADPU=1 - Enable Analog to Digital
admask3:         equ     %00000000       ;FRZ1,FRZ0=0
admask4:         equ     %10000001       ;SMP1,SMP0 = 0; S10BM,PRS0=1 - Select Sample time adn Bit mode
admask5:         equ     %01110000       ;S8CM = 1, SCAN = 1, MULT = 1
SCFflag:         equ     %10000000       ;SCF - Sequence Complete flag

;RTI Variables
clrmask:         equ     %11000000       ;mask for clearing timer flags
RTIRate:		equ     %00110000       ;[6:4]=2^12 =>512 microsecond RTI rate
;RTIRate		equ     %01110000       ;

RTIF:		equ	%10000000
RTIE:		equ	%10000000

;SCI Variables
scimask:         equ     %00101100       ;RIE - SCI Interrupt enable
                                        ;RE - Receiver Enable
RDRFflag:        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag:        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
OscFreq:		equ	8000		;Enter Osc speed
initSYNR:	equ	$02		; mult by synr + 1 = 3 (24MHz)
initREFDV:	equ	$00		;

BusFreq:		equ	((OscFreq/(initREFDV+1))*(initSYNR+1))
baud115200:	equ	(BusFreq/16)*10/1152  			;sets baud rate to 115,200
baud9600:	equ	(BusFreq/16)*10/96  			;sets baud rate to 009,600
initSCI0CR2:	equ	$0C					;SCI0 Control Register 2

* Operational Constants

TRUE:            equ     $FF
FALSE:           equ     $00
CR:              equ     $D
LF:              equ     $A
SPACE:           equ     $20

;------------------------------------------------------------------------------
NON_BANKED:SECTION
;
RealTimeInit:				;Initialize Real Time Interrupt
	movb	#RTIRate,RTICTL		;and initialize RTI rate
	bset	CRGFLG,RTIF		;clear flag
	bset	CRGINT,RTIE		;Enable RTI

;Initialize Analog To Digital
	movb	#$80,ATDCTL2	        ;enable ATD
	movb	#$40,ATDCTL3	        ;8 Channels ATD result
	movb	#$60,ATDCTL4		;Select Sample rate
	movb	#$B0,ATDCTL5		;Select 8 channel mode, Continuous scan
	clr	adflag

;Initialize first Serial Communication Interface
	movw	#baud9600,SCIBDH	;Set baud rate to 9600
	movb	#scimask,SCICR2		;Rx and Tx on
	ldab	SCISR1  		;read register to clear flag RDRF
	ldab	SCIDRL			;read receive buffer

	bset	TSCR1,%10000000		;TEN=1 - Enable timer
	rts

;------------------------------------------------------------------------------
* Real-time Interrupt Routine

RealTimeInt:
	bset	CRGFLG,RTIF		;clear real-time interrupt flag
	cli				; so that other interrupts can be service

RTI_1:
	ldx	TIMER
	beq	RTI_2
	dex
	stx	TIMER

RTI_2:
	ldx	TIMER1
	beq	RTI_3
	dex
	stx	TIMER1

RTI_3:
	ldaa	d_flag
	bne	RTI_4

	brclr	ATDSTAT0,SCFflag,*	;Loop here until SCF of ATD is set save ATD
	bset	ATDSTAT0,SCFflag		;clear Flag for next conversion

	ldd	ATDDR0H
	std	ad0

	ldd	ATDDR1H
	std	ad1

	ldd	ATDDR2H
	std	ad2

	ldd	ATDDR3H
	std	ad3

	ldd	ATDDR4H
	std	ad4

	ldd	ATDDR5H
	std	ad5

	ldd	ATDDR6H
	std	ad6

	ldd	ATDDR7H
	std	ad7

RTI_4:
	ldx	roving_timer1
	beq	RTI_5
	dex
	stx	roving_timer1

RTI_5:
	ldx	roving_timer2
	beq	RTI_6
	dex
	stx	roving_timer2

RTI_6:
	ldx	backing_timer
	beq	RTI_7
	dex
	stx	backing_timer

RTI_7:
	ldx	RechargeTime
	beq	RTI_8
	dex
	stx	RechargeTime

RTI_8:
	ldaa	cap6Flag
	beq	RTI_9

	ldx	EchoTime
	inx	
	stx	EchoTime

RTI_9:
	ldx	EchoTimerMax
	beq	RTI_10
	dex
	stx	EchoTimerMax

RTI_10:
	ldx	InterestTimer
	beq	RTI_11
	dex
	stx	InterestTimer

RTI_11:
	ldx	audio_delay
	beq	RTI_12
	dex	
	stx	audio_delay

RTI_12:
	jsr	check_audio

RTI_13:
	rti

;------------------------------------------------------------------------------
*  SCI Input Interrupt Handler

*  Gets bytes from SCI.  Sets COMMAND_PENDING flag.


OutStr0:				; send a null terminated string to the display.
	ldaa	1,x+            ; get a character, advance pointer, null?
	beq	OutStrDone      ; yes. return.
	bsr	SerOutput0      ; no. send it out the SCI.
	bra	OutStr0          ; go get the next character.
;
OutStrDone:
	rts

;------------------------------------------------------------------------------
SerOutput0:
	brclr	SCISR1,TDREflag,SerOutput0     ;check if buffer is empty
	staa	SCIDRL
	rts

SerInputInt0:
	ldaa	SCISR1                  ;read register to clear flag RDRF
	movb	SCIDRL,COMMAND          ;read receive buffer
	movb	#TRUE,COMMAND_PENDING

SIIX:
	rti

;==============================================================================
* Output Compare Initialization routine
;
OC4mask1:	equ	%00010000	;IOS4 = 1, Bit 4 as output compare
OC4mask2:	equ	%00010000	;C4I = 1, Enable Interrupt
OC4mask3:	equ	%00000001	;OM4 = 0, OL4 = 1, toggel OC output line
OC4flag:		equ	%00010000	;C4F = 1 to clear Interrupt flag
AudioControl:	equ	%00010000	;Port M bit 4 to control Audio

;------------------------
; Audio Interrupt Routine
;------------------------
audio_int:
	ldd	audio_period		;audio time period for next
	addd	TC4			;  output compare interrupt
	std	TC4			

	ldx	audio_period
	beq	auiex

	ldaa	audio_status
	eora	#1
	staa	audio_status
	beq	aui10

	bclr	PORTM,AudioControl
	bra	auiex

aui10:
	bset	PORTM,AudioControl

auiex:
	bset	TFLG1,OC4flag		;clear flag
	rti

	END

