;Roving.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*March 22, 2004		1.00		Experimental MaggieBot 
*
*Author: Exequiel Rarama for the NanoCore12DX - 32 pin dip module
*******************************************************************************
;Compiled using MCUez
;
; ---------------------------
; Robotics - Roving Routine
; ---------------------------

	include "C32Regs.INC"

;Public Function
	XDEF PWMInit
	XDEF check_transition

;Public Variables
	XDEF RobotState
	XDEF roving_timer1
	XDEF roving_timer2

	XDEF backing_timer
	XDEF grey_area_flg1
	XDEF grey_area_flg2

	XDEF InterestTimer
	XDEF AvoidanceState

;External Function
	XREF SerOutput0
	XREF OutStr0	

	XREF set_audio

;External Variables
	XREF ad0
	XREF ad1
	XREF ad2
	XREF ad3
	XREF ad4
	XREF ad5
	XREF ad6
	XREF ad7

	XREF IC6Var2		;Delta T Captured time to object


DataSec:SECTION
PWMFlag:		ds	1
RobotState:	ds	2
check_eye_flag:	ds	1
roving_timer1:	ds	2
roving_timer2:	ds	2
backing_timer:	ds	2
grey_area_flg1:	ds	1
grey_area_flg2:	ds	1

InterestTimer:	ds	2
AvoidanceState:	ds	2
AvoidFlag:	ds	1

;SFR04
SeekFlag:	ds	1
BoredFlag:	ds	1
FollowFlag:	ds	1

;------------------------------------------------------------------------------
PWME0:	equ	$01
PWME1:	equ	$02
PWME2:	equ	$04
PWME3:	equ	$08
PWME4:	equ	$10

PWME5:	equ	$20
PWME6:	equ	$40
PWME7:	equ	$80

EF0:	equ	%001
EF1:	equ	%010

Second:	equ	1953

LeftTurn:	equ	%0110
RightTurn:	equ	%1001
Forward:		equ	%0101
Reverse:		equ	%1010

***************************** Program *******************************

NON_BANKED:SECTION

PWMInit:
	bset	MODRR,PWME0+PWME1+PWME2+PWME3+PWME4	;PP0-PP3 mux to PT0-PT1
	bset	DDRP,PWME0+PWME1+PWME2+PWME3+PWME4	;Bit 3,2,1,0 = o/p

	movb	#%00000000, PWME	;All channels disabled
	movb	#%00000000, PWMPOL	;Low during duty cycle
	movb	#%00000000, PWMCLK	;Clock SA & Clock SB
	movb	#%01110111, PWMPRCLK	;Clock A = Bus Clock / 128,	Clock B = Bus Clock / 128
	movb	#%00000000, PWMCAE	;All channels operate in Left Aligned Output Mode
	movb	#%00001100, PWMCTL	;No concatenation
	movb	#%00000000, PWMSCLA	;Clock SA = Clock A / ( 2 * 256)
	movb	#%00000000, PWMSCLB	;Clock SB = Clock B / ( 2 * 256)

	movb	#%11111111, PWMPER0
	movb	#%11111111, PWMPER1
	movb	#%11111111, PWMPER2
	movb	#%11111111, PWMPER3
	movb	#%11111111, PWMPER4

	clr	grey_area_flg1		;This flag is used in close proximity of Sharp sensors
	clr	grey_area_flg2		;This flag is used in close proximity of Sharp sensors

	clr	SeekFlag		;Rotate Flag to have Sonar check for closest Target

	clr	BoredFlag		;Initialize Boring Flag
	movw	#0,InterestTimer	;Initialize interest Timer
	clr	AvoidFlag		;Initialize Avoid Flag when in Bored state
	clr	FollowFlag

	clr	check_eye_flag

	movw	#wait_test,AvoidanceState	;Initialize avoidance function
	movw	#go_Robot_ready,RobotState
	rts

go_Robot_ready:
	movb	#%11000000, PWMDTY0		;PWM initialized
	movb	#%11000000, PWMDTY1
	movb	#%11000000, PWMDTY2
	movb	#%11000000, PWMDTY3
	movb	#%11000000, PWMDTY4

;	bset	PWME,PWME4			;enable PWM4
	movw	#SeekClosestObject,RobotState

;test
;	bset	PWME,PWME0+PWME1+PWME2+PWME3	;enable PWM0 and PWM2
;	movb	#%0101,PWME		;Make motor go at the same direction
;	movw	#wait_test,RobotState

	rts

wait_test:
	rts

;------------------------------------------------------------------------------
TooClose:	equ	300		;Short sonar distance measurement.
					; Any value < is considered too close
TooFar:		equ	3000	;8000		;Long sonar distance measurement.  
					;Any value > is considered too far
ValidRange:	equ	TooFar-TooClose

SeekClosestObject:
	ldd	IC6Var2

	cpd	#TooClose		;Yes a target is within Valid range
	bls	MoveCloser10		;Check if already close

	cpd	#ValidRange+TooClose
;	cpd	#TooFar
	bhi	SeekObject		;Check if a Target is already within range

	clr	SeekFlag		;Target is acquired, flag is re-initialized for next target

	movb	#Forward,PWME		;Make motor go at the same direction and move forward

	ldx	#TargetAckMsg		;Send msg
	jsr	OutStr0

	movw	#MoveCloser,RobotState	;Make Robot move closer to Target
	bra	SeekObjectEx

SeekObject:				;-->Make it rotate to act like RADAR ******************
	ldaa	SeekFlag
	bne	SeekObject10		;No Target detected within the valid range

	clr	FollowFlag
	movb	#1,SeekFlag		;Set flag to indicate seeking state
	movb	#LeftTurn,PWME		;Make motor go opposite to rotate clockwise

	ldx	#NoTargetDetected	;Send msg
	jsr	OutStr0

	movw	#Second*2,InterestTimer	;Seek new target for 2 seconds
	bra	SeekObjectEx

SeekObject10:
	ldx	InterestTimer
	bne	SeekObjectEx

;	clr	FollowFlag

	clr	SeekFlag		;Target is acquired, flag is re-initialized for next target
	movb	#Forward,PWME		;Make motor go at the same direction

	movw	#SeekNewTargetWait,RobotState
	movw	#Second*5,InterestTimer	;Initialize interest Timer to seek for target

SeekObjectEx:				;No Target detected within the valid range
	rts

;------------------------------------------------------------------------------
MoveCloser:
	clr	SeekFlag		;Target is acquired, flag is re-initialized for next target

	ldd	IC6Var2
	cpd	#TooClose
	bhi	MoveCloserCheck		;Check if higher than TooClose var or Target moved out of range

MoveCloser10:
	clr	SeekFlag		;Target is acquired, flag is re-initialized for next target
;	clr	PWME			;PWM are off, Stop moving

	ldx	#TargetNear		;Send msg
	jsr	OutStr0

	movw	#FollowTarget,RobotState

	clr	SeekFlag		;Target is acquired, flag is re-initialized for next target

	ldaa	FollowFlag
	bne	MoveCloserEx

	movw	#Second*5,InterestTimer	;Initialize interest Timer

	bra	MoveCloserEx

MoveCloserCheck:
	ldd	IC6Var2
	cpd	#TooFar
	blo	MoveCloserEx

	movw	#SeekClosestObject,RobotState

MoveCloserEx:
	rts

;-------------------------------------------------------------------------------------
FollowTarget:
	ldd	IC6Var2
	cpd	#TooClose+150		;Change 450
	bls	FollowTarget30		;Check if higher TooClose var or it moved out of range

	ldx	#Here
	jsr	OutStr0

	ldd	ad3
	cpd	#300
	bhs	TurnLeftNow

	ldd	ad4	
	cpd	#300
	bhs	TurnRightNow

	bra	FollowTarget10

TurnLeftNow:
	movb	#LeftTurn,PWME		;Make it turn left
	ldx	#TurningLeftMsg
	jsr	OutStr0

	bra	KeepTurning		;Make motor turn until sonar reacquires at the right distance

TurnRightNow:
	movb	#RightTurn,PWME		;Make it turn right
	ldx	#TurningRightMsg
	jsr	OutStr0

	bra	KeepTurning		;Make motor turn until sonar reacquires at the right distance

FollowTarget10:
	movb	#Forward,PWME

FollowTarget20:
	movw	#MoveCloser,RobotState

;	movw	#SeekClosestObject,RobotState
	bra	FollowTargetEx

FollowTarget30:
	ldx	InterestTimer
	bne	FollowTargetEx

	movw	#SeekNewTarget,RobotState

	ldx	#BoringMsg		;Send msg
	jsr	OutStr0

FollowTargetEx:
	rts


KeepTurning:
	movw	#ReLocateTarget,RobotState
	movb	#1,MoveCloserEx
	rts

ReacquireDist:	equ	600

ReLocateTarget:				;Here the sonar must acquire the target and move forward
	ldd	IC6Var2
	cpd	#ReacquireDist
	bls	FollowTarget30		;Check if higher TooClose var or it moved out of range

	movw	#FollowTarget,RobotState
	rts

;----------------------------------------------------------------------------------------
SeekNewTarget:				;Do an about turn and seek new Target
	movb	#Reverse,PWME		;enable PWM0 and PWM3 and reverse

	movw	#ReverseFromTarget,RobotState
	movw	#Second*3,InterestTimer	;Initialize interest Timer to ignore other object

	ldx	#ReversingMsg		;Send msg
	jsr	OutStr0

	movw	#AvoidObstacle,AvoidanceState
	bra	SeekNewTargetEx

ReverseDist:	equ	750

ReverseFromTarget:
	ldd	IC6Var2
	cpd	#ReverseDist
	bls	ReverseFromTarget10		;Check if higher TooClose var or it moved out of range

	bra	ReverseFromTarget20

ReverseFromTarget10:
	ldx	InterestTimer
	bne	ReverseFromTargetEx

ReverseFromTarget20:
	movb	#RightTurn,PWME			;Do a dance for a second

	movw	#SeekNewTargetWait,RobotState
	movw	#Second*1,InterestTimer		;Initialize interest Timer to ignore other object

ReverseFromTargetEx:
	rts


SeekNewTargetWait:
	ldx	InterestTimer
	bne	SeekNewTargetEx

	movw	#SeekClosestObject,RobotState

SeekNewTargetEx:
	ldd	IC6Var2

	cpd	#TooClose		;Yes a target is very close
	lbls	MoveCloser10		;Check if already close

	cpd	#ValidRange+TooClose
	lbhi	SeekObject		;Check if a Target is within Valid range

	rts




;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
go_check_Front:
	ldd	ad3
	cpd	#480
	bhs	decide_which_way_to_turn1

	ldd	ad4	
	cpd	#480
	bhs	decide_which_way_to_turn2
	rts

;-----------------------------------------------------------------------------------
go_Turn_on_a_dime:				;Enable Right Servo
;	movb	#%11100000, PWMDTY0		;Make the PWM values the same to move toward objective
;	movb	#%11100000, PWMDTY2
	bset	PWME,PWME0+PWME1		;enable PWM0 and PWM1
	rts

go_Forward:
;	movb	#%11111000, PWMDTY0
;	movb	#%10000000, PWMDTY1

	bset	PWME,PWME0+PWME1		;enable PWM0 and PWM1
	movw	#go_check_Front,RobotState

	rts

go_Backward:
;	movb	#%10000000, PWMDTY0
;	movb	#%11111000, PWMDTY1
	rts


;------------------------------------------------------------------------------
decide_which_way_to_turn:
	ldd	ad3
	cpd	ad4
	lbhi	TurnLeft
	blo	TurnRight
	bra	backup_a_bit

decide_which_way_to_turn1:
	ldd	ad3
	cpd	ad4
	lbhi	TurnLeft
	beq	backup_a_bit
	rts

decide_which_way_to_turn2:
	ldd	ad4	
	cpd	ad3
	bhi	TurnRight
	bra	backup_a_bit

backup_a_bit:
	movw	#122,backing_timer		;

;	movb	#%10000000, PWMDTY0
;	movb	#%11111000, PWMDTY1

	movw	#moving_back,RobotState
	rts

moving_back:
	ldx	backing_timer
	bne	move_ex

	movw	#decide_which_way_to_turn,RobotState

move_ex:
	rts

;------------------------------------------------------------------------------
TurnRight:
	brset	grey_area_flg2,%10000000,go_back1

;	movb	#%11111000, PWMDTY0
;	movb	#%11111000, PWMDTY1

	movw	#go_check_Right_eye,RobotState

	ldx	#Right_tone
	jsr	set_audio

	rts

go_back1:
	bra	go_back

Right_tone:
	dc.b	50,40,127
	dc.b	15,100,0
	dc.b	10,50,255
	dc.b	$ff,0,0

check_Right_eye:
	bset	check_eye_flag,%10
	brset	check_eye_flag,%01,move_Forward1
	movw	#go_check_Right_eye,RobotState
	rts

go_check_Right_eye:
	ldd	ad4	
	cpd	#400
	blo	check_Left_eye
	rts

check_Left_eye:
	bset	check_eye_flag,%01
	brset	check_eye_flag,%10,move_Forward1
	movw	#go_check_Left_eye,RobotState
	rts

move_Forward1:
	lbra	move_Forward

go_check_Left_eye:
	ldd	ad3	
	cpd	#400
	blo	check_Right_eye
	rts

TurnLeft:
	brset	grey_area_flg1,%10000000,go_back

;	movb	#%10000000, PWMDTY0
;	movb	#%10000000, PWMDTY1

	movw	#go_check_Left_eye,RobotState
	ldx	#Left_tone
	jsr	set_audio

	rts

Left_tone:
	dc.b	50,40,127
	dc.b	100,40,120
	dc.b	20,10,255
	dc.b	$ff,0,0

;------------------------------------------------------------------------------
go_back:
	movw	#122,backing_timer		;

;	movb	#%10000000, PWMDTY0
;	movb	#%11111000, PWMDTY1

	movw	#moving_back,RobotState

	clr	grey_area_flg1
	clr	grey_area_flg2

	ldx	#goBack_tone
	jsr	set_audio

	rts

goBack_tone:
	dc.b	20,40,$50
	dc.b	80,40,$64
	dc.b	200,30,255
	dc.b	$ff,0,0

;------------------------------------------------------------------------------
move_Forward:
;	movb	#%11111000, PWMDTY0
;	movb	#%10000000, PWMDTY1

	clr	check_eye_flag
	movw	#go_check_Front,RobotState

	ldx	#fwd_tone		;Move forward tone
	jsr	set_audio
	rts

fwd_tone:
	dc.b	80,50,0
	dc.b	80,40,$64
	dc.b	80,50,0
	dc.b	$ff,0,0

;------------------------------------------------------------------------------
EmergencyStop:
	ldaa	PWME
	anda	#%11111100
	staa	PWME			;disable PWM0 and PWM1
	movw	#go_Robot_wait,RobotState
	rts

go_Robot_wait:
	rts


;------------------------------------------------------------------------------
check_transition:
	bsr	check_right_transition
	bsr	check_left_transition
	rts

check_right_transition:
	ldd	ad3
	cpd	#500
	bhs	going_grey1
	rts

going_grey1:
	bset	grey_area_flg1,%10000000
	rts
	
check_left_transition:
	ldd	ad4
	cpd	#500
	bhs	going_grey2
	rts

going_grey2:
	bset	grey_area_flg2,%10000000
	rts


;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

;------------------------------------------------------------------------------
;Avoidance Algo Function
AvoidObstacle:
	rts


;------------------------------------------------------------------------------
go_check_Back:
	rts


;------------------------------------------------------------------------------
TargetAckMsg:		dc.b	'Target is acquired - Closing in',$D,$A,$0
NoTargetDetected:	dc.b	'No Target in Range - Acquiring Now!!',$D,$A,$0
TargetNear:		dc.b	'Target is Near',$D,$A,$0
BoringMsg:		dc.b	'I am bored - Seeking New Target',$D,$A,$0
ReversingMsg:		dc.b	'Object too close - Reversing',$D,$A,$0
TurningLeftMsg:		dc.b	'Turning Left',$D,$A,$0
TurningRightMsg:		dc.b	'Turning Right',$D,$A,$0
Here:			dc.b	'Here',$D,$A,$0
	END		;*******************************************
