;SFR04.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*March 22, 2004		1.00		Experimental MaggieBot 
*
*Author: Exequiel Rarama for the NanoCore12DX - 32 pin dip module
*******************************************************************************
;Compiled using MCUez
;

	include "C32Regs.INC"


;Public Function
	XDEF OC1Init
	XDEF SFR04IC6Int
	XDEF SFR04OC1Int
	XDEF SendPulse
	XDEF SendPulseReady

;Public Variables
	XDEF SFR04State
	XDEF cap6Flag
	XDEF RechargeTime
	XDEF EchoTime
	XDEF EchoTimerMax

	XDEF IC6Var2		;Delta T Captured time to object

;External Function
	XREF SerOutput0
	XREF OutStr0
	XREF HTOD	

;External Variables


DataSec:	SECTION

;SFR04 Variables
PulseTime:	ds	2		;10 microsecond delay
EchoTimerMax:	ds	2		;Echo drive timer
RechargeTime:	ds	2		;10 millisecond Recharge delay before next firing
MaxEchoTime:	ds	2		;36 millisecond for MAX no echo return
EchoTime:	ds	2

IC6Var1:		ds	2
IC6Var2:		ds	2
IC6Var3:		ds	2

cap6Flag:	ds	1
cap6Valid:	ds	1
Send6Flag:	ds	1

SFR04State:	ds	2

*  Operational Parameters

OC1mask1:	equ	%00000010	;IOS1 = 1, Bit 1 as output compare
OC1mask2:	equ	%00000010	;C1I = 1, Enable Interrupt
OC1flag:		equ	%00000010	;C1F = 1 to clear Interrupt flag

IC6mask1:	equ	%01000000	;IOS6 = 1

;SFR04 parameters
MaxTravelTime:	equ	300		;Maximum echo travel time
SonarPulse:	equ	%00000001	;Port M bit 0 as SFR04 sonar driver

TooClose:	equ	300		;Short sonar distance measurement.
					;Any value < is considered too close
TooFar:		equ	8000		;Long sonar distance measurement.  
					;Any value > is considered too far

ms100:		equ	$9C6
ms1:		equ	$1B
ms8:		equ	$CC

us100:		equ	300
us10:		equ	30
us5:		equ	15
us1:		equ	3

***************************** Program *******************************

NON_BANKED:SECTION

OC1Init:					;Initialize Output Compare 1
	bset	DDRM,SonarPulse		;Bit 0 output the rest inputs
	bclr	PORTM,SonarPulse	;Init Port M

	bset	TIOS,OC1mask1		;Set IOS1 for Output Compare
	bclr	TCTL2,%1100		;Make sure Port is not tied with OC

;	bset	TSCR2,%0011		;Bus clock/8 = 24MHz/8 = 3MHz
	bset	TSCR2,%0100		;Bus clock/8 = 24MHz/16 = 1.5MHz

	movb	#OC1flag+IC6mask1,TFLG1	;clear flag;
	bset	TIE,IC6mask1		;enable IC6 interrupt

;Change capture edge to capture from Low to high of IC6
	ldaa	TCTL3
	anda	#%11001111		;masked lower 2 bits
	adda	#%00010000
	staa	TCTL3

	clr	cap6Flag
	clr	cap6Valid
	clr	Send6Flag

	movw	#00,RechargeTime		;Initialize recharge time
	movw	#SendPulse,SFR04State		;Initialize SFR04State

	ldd	#us10				;get constant for 10us delay
	std	PulseTime			;PulseTime = 10*10^-3 * 3 * 10^6 = 30

	rts


SendPulseReady:
	rts


;------------------------------------------------------------------------------------
SendPulse:
	ldx	RechargeTime		;Check recharge time delay
	bne	SendPulseEx

	ldaa	Send6Flag		;Will not send another Impulse until flag is clear
	bne	SendPulseCheckTimer

;Change capture edge to capture from Low to high
	ldaa	TCTL3
	anda	#%11001111		;masked lower 2 bits
	adda	#%00010000
	staa	TCTL3

	clr	cap6Flag
	movb	#1,Send6Flag
	movw	#59,EchoTimerMax	;Initialize echo drive time limit

	movb	#OC1flag+IC6mask1,TFLG1		;clear flag;

	bset	PORTM,SonarPulse	;Port M bit 0 = 1 will drive Sonar
	ldd	PulseTime		;get constant for 10us delay
	addd	TCNT
	std	TC1

	bset	TIE,OC1mask2		;enable IC6, OC1 interrupt
	bra	SendPulseEx

SendPulseCheckTimer:			;Check to see if waited too long in firing
	ldx	EchoTimerMax
	bne	SendPulseEx

	clr	Send6Flag
	bclr	PORTM,SonarPulse	;Port M bit 0 = 0 Sonar driver off
	movw	#20,RechargeTime	;Initialize recharge time

SendPulseEx:
	rts

;------------------------------------------------------------------------------
; SFR04 OC1 Interrupt Routine
;----------------------------

SFR04OC1Int:
	bclr	PORTM,SonarPulse	;Port M bit 0 = 0 Sonar driver off
	movw	#20,RechargeTime	;Initialize recharge time

	movb	#OC1flag,TFLG1		;clear flag;

	ldaa	TIE
	anda	#%11111101
	staa	TIE			;disable OC1 interrupt
	rti

;------------------------------------------------------------------------------
; SFR04 IC6 Interrupt Routine
;----------------------------

SFR04IC6Int:
	ldd	TC6
	pshd				;Save momentarily

	ldaa	cap6Flag		;Check if 1st or 2nd capture
	bne	Second6Cap		;If flag is set then it is 2nd falling edge

	puld
	std	IC6Var1			;1st Capture
	movb	#1,cap6Flag		;Set flag for 2nd capture

;Change capture edge to capture from high to low
	ldaa	TCTL3
	anda	#%11001111		;masked lower 2 bits
	adda	#%00100000
	staa	TCTL3
	bra	IC6ex			;Wait until next capture

Second6Cap:
	puld
	std	IC6Var3
	subd	IC6Var1			;Subtract from 1st Capture
;	lsrd				;Divide 2
	std	IC6Var2			;Result in Var2

	clr	cap6Flag
	clr	Send6Flag		;A pulse is received, flag is initialized for a new pulse

	movw	#20,RechargeTime	;Initialize recharge time to 10 millisecond
	movb	#1,cap6Valid		;set flag for echo

;Change capture edge to capture from Low to high
	ldaa	TCTL3
	anda	#%11001111		;masked lower 2 bits
	adda	#%00010000
	staa	TCTL3

IC6ex:
	movb	#%01000000,TFLG1        ;clear input interrupt flag
        rti

	END

;----------------------------------------------------------------------------
test
	bclr	TIE,IC0mask1		;disable IC1 interrupt

	ldx	#IC6Var3
	jsr	HTOD

	ldaa	#'-'
	jsr	SerOutput0

	ldx	#IC6Var1
	jsr	HTOD

	ldaa	#'='
	jsr	SerOutput0

	ldx	#IC6Var2
	jsr	HTOD

	ldaa	#$D
	jsr	SerOutput0

	ldaa	#$A
	jsr	SerOutput0

