;MAIN.ASM
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*March 22, 2004		1.00		Experimental MaggieBot 
*
*Author: Exequiel Rarama for the NanoCore12DX - 32 pin dip module
*******************************************************************************
;Compiled using MCUez
;
; ---------------------------
; Robotics - Main Routine
; ---------------------------

	include "C32Regs.INC"

;Public Function
	XDEF ResetFunc
	XDEF delay

;Public Variables
	XDEF COMMAND
	XDEF COMMAND_PENDING
	XDEF CONTINUOUS

;External Function
	XREF RealTimeInit	;Initialize Real Time interrupts, Analog, SCI
	XREF RealTimeInt	;Real Time clock Interrupt service routine

	XREF audio_init		;Initialize Audio routine
	XREF audio_int		;Output compare to service Audio routine

	XREF SerInputInt0	;SCI interrupt service routine
	XREF ProcessCommand

	XREF ShowMenu

	XREF PWMInit		;Initialize PWM

	XREF ShowAnalog
	XREF check_transition

	XREF OC1Init		;Initialize Output compare 1
	XREF SFR04OC1Int	;OC1 Interrupt service routine
	XREF SFR04IC6Int	;IC6 Interrupt service routine

;External Variables

	XREF d_flag

	XREF RobotState
	XREF SFR04State
	XREF AvoidanceState
	
	XREF audio_state

DataSec:SECTION

* System Variables

COMMAND:		ds	1		;used by ProcessCommand
COMMAND_PENDING:	ds	1		;used by ProcessCommand
CONTINUOUS:	ds	1		;flag for real-time a/d screen update


*  Operational Parameters
RAM:		equ	$3800		;RAM
STACK:		equ	$3F80		;Stack at below Ubug12

OscFreq:		equ	8000		;Enter Osc speed
initSYNR:	equ	$02		; mult by synr + 1 = 3 (24MHz)
initREFDV:	equ	$00		;
PLLSEL:		equ	%10000000	;PLL select bit
LOCK:		equ	%00001000	;lock status bit
PLLON:		equ	%01000000	;phase lock loop on bit

***************************** Program *******************************

NON_BANKED:SECTION

ResetFunc:				;This is where the RESET vector points to
	sei				;Disable Any interrupts

	movb	#$00,INITRG		;set registers at $0000 
	movb	#$39,INITRM		;move and set ram to end at $3fff 

;Initialize Stack
	lds	#STACK			;initialize stack pointer

; Initialize clock generator and PLL
	bclr	CLKSEL,PLLSEL      	;disengage PLL to system
	bset	PLLCTL,PLLON       	;turn on PLL

	movb	#initSYNR,SYNR     	;set PLL multiplier 
	movb	#initREFDV,REFDV   	;set PLL divider
	nop
	nop
	brclr	CRGFLG,LOCK,*+0    	;while (!(crg.crgflg.bit.lock==1))
	bset	CLKSEL,PLLSEL      	;engage PLL to system

	jsr	RealTimeInit		;Initialize SCI and RTI
	jsr	PWMInit			;Initialize PWM 0 and 1
	jsr	audio_init		;Initialize bit 7 of PORTP as OC for audio o/p
	jsr	OC1Init

	clr	COMMAND_PENDING
	clr	CONTINUOUS
	clr	d_flag

	cli				;unmask interrupts

	jsr	ShowMenu

;------------------------------------------------------------------------------
main:					;Main Loop
	jsr	ProcessCommand		;this is the program loop

	ldaa	CONTINUOUS
	beq	NotCont
	jsr	ShowAnalog

NotCont:
	ldx	RobotState
	jsr	0,x

	jsr	check_transition

	ldx	SFR04State
	jsr	0,x

	ldx	AvoidanceState
	jsr	0,x

	ldx	audio_state		;Process audio command
	jsr	0,x

	bra	main


;------------------------------------------------------------------------------
;small delay
delay:
	pshy
	ldy	#0

dly:
	dbne	y,dly			;decrement y counter
	puly
	rts

;------------------------------------------------------------------------------

	END
