;gp2d120.asm
*******************************************************************************
*REVISION HISTORY:
*
*DATE			REV. NO.	DESCRIPTION
*
*August 13, 2004	1.00		Sharp gp2d120 Application
*
*Author: Exequiel Rarama for the 9S12C32
*******************************************************************************
;Compiled using MiniIDE
;

#include C32Regs.INC

	ORG RAM

;A/D variables
ad0		ds	2
ad1		ds	2
ad2		ds	2
ad3		ds	2
ad4		ds	2
ad5		ds	2
ad6		ds	2
ad7		ds	2

;------------------------------------------------------------------------------
FPACC1EX:	ds	1		;FLOATING POINT ACCUMULATOR #1..
FPACC1MN:	ds	3
MANTSGN1:	ds	1		;MANTISSA SIGN FOR FPACC1 (0=+, FF=-).

FPACC2EX:	ds	1		;FLOATING POINT ACCUMULATOR #2.
FPACC2MN:	ds	3
MANTSGN2:	ds	1		;MANTISSA SIGN FOR FPACC2 (0=+, FF=-).
;------------------------------------------------------------------------------
;
Float2Ascii	ds	15		;Conversion from Floating point to ASCII
;
;------------------------------------------------------------------------------
;General timers
dispDly		ds	2


*  Operational Parameters


;------------------------------------------------------------------------------
*  Operational Parameters
RAM		equ	$3800		;RAM
STACK		equ	$3F80		;Stack at below Ubug12
FLASH		equ	$4000		;Fixed FLASH or PPAGE = $3E
VectorTable	equ	$FF80		;Beginning of Vector Table interrupt

OscFreq		equ	8000		;Enter Osc speed
initSYNR	equ	$02		; mult by synr + 1 = 3 (24MHz)
initREFDV	equ	$00		;
PLLSEL		equ	%10000000	;PLL select bit
LOCK		equ	%00001000	;lock status bit
PLLON		equ	%01000000	;phase lock loop on bit

;------------------------------------------------------------------------------
;ATD Variables
admask2         equ     %11000000       ;AFFC,ADPU=1 - Enable Analog to Digital
admask3         equ     %00000000       ;FRZ1,FRZ0=0
admask4         equ     %10000001       ;SMP1,SMP0 = 0; S10BM,PRS0=1 - Select Sample time adn Bit mode
admask5         equ     %01110000       ;S8CM = 1, SCAN = 1, MULT = 1
SCFflag         equ     %10000000       ;SCF - Sequence Complete flag

;RTI Variables
clrmask         equ     %11000000       ;mask for clearing timer flags
;RTIRate		equ     %00110000       ;[6:4]=2^12 =>512 microsecond RTI rate
RTIRate		equ     %00110000       ;[6:4]=2^12 =>512 microsecond RTI rate

RTIF		equ	%10000000
RTIE		equ	%10000000

;SCI Variables
scimask         equ     %00101100       ;RIE - SCI Interrupt enable
                                        ;RE - Receiver Enable
RDRFflag        equ     %00100000       ;RDRF - Receive Data Register Full flag
TDREflag        equ     %10000000       ;TDRE - Transmit Data Register Empty flag

;Baud rate definitions
BusFreq		equ	((OscFreq/(initREFDV+1))*(initSYNR+1))
baud115200	equ	(BusFreq/16)*10/1152  			;sets baud rate to 115,200
baud9600	equ	(BusFreq/16)*10/96  			;sets baud rate to 009,600
initSCI0CR2	equ	$0C					;SCI0 Control Register 2


***************************** Program *******************************

	ORG FLASH

ResetFunc				;This is where the RESET vector points to
	sei				;Disable Any interrupts

	movb	#$00,INITRG		;set registers at $0000 
	movb	#$39,INITRM		;move and set ram to end at $3fff 

;Initialize Stack
	lds	#STACK			;initialize stack pointer

; Initialize clock generator and PLL
	bclr	CLKSEL,PLLSEL      	;disengage PLL to system
	bset	PLLCTL,PLLON       	;turn on PLL

	movb	#initSYNR,SYNR     	;set PLL multiplier 
	movb	#initREFDV,REFDV   	;set PLL divider

	nop
	nop
	nop

	nop
	nop
	nop
	nop

	brclr	CRGFLG,LOCK,*+0    	;while (!(crg.crgflg.bit.lock==1))
	bset	CLKSEL,PLLSEL      	;engage PLL to system
	cli

;------------------------------------------------------------------------------
RealTimeInit				;Initialize Real Time Interrupt
	movb	#RTIRate,RTICTL		;and initialize RTI rate
	bset	CRGFLG,RTIF		;clear flag
	bset	CRGINT,RTIE		;Enable RTI

;Initialize Analog To Digital
	movb	#$80,ATDCTL2	        ;enable ATD
	movb	#$40,ATDCTL3	        ;8 Channels ATD result
	movb	#$60,ATDCTL4		;Select Sample rate
	movb	#$B0,ATDCTL5		;Select 8 channel mode, Continuous scan

;Initialize first Serial Communication Interface
	movw	#baud9600,SCIBDH	;Set baud rate to 9600
	movb	#scimask,SCICR2		;Rx and Tx on
	ldab	SCISR1  		;read register to clear flag RDRF
	ldab	SCIDRL			;read receive buffer

	ldx	#MSG1
        jsr     OutStr0

	movw	#00,dispDly

;========START of MAIN==================================================================
main						
	ldx	dispDly			;check the display delay
	bne	main

	jsr	CalVoltage
	movw	#122,dispDly		;1 second delay refresh

	bra	main


;=======END of MAIN====================================================================


;------------------------------------------------------------------------------
* Real-time Interrupt Routine

RealTimeInt
	bset	CRGFLG,RTIF		;clear real-time interrupt flag
	cli				; so that other interrupts can be service

RTI_6	
	ldx	dispDly
	beq	RTI_7
	dex
	stx	dispDly

RTI_7
	brclr	ATDSTAT0,SCFflag,*	;Loop here until SCF of ATD is set save ATD
	bset	ATDSTAT0,SCFflag		;clear Flag for next conversion

	ldd	ATDDR0H
	std	ad0

	ldd	ATDDR1H
	std	ad1

	ldd	ATDDR2H
	std	ad2

	ldd	ATDDR3H
	std	ad3

	ldd	ATDDR4H
	std	ad4

	ldd	ATDDR5H
	std	ad5

	ldd	ATDDR6H
	std	ad6

	ldd	ATDDR7H
	std	ad7
	rti

;==============================================================================

;------------------------------------------------------------------------------
*  SCI Input Interrupt Handler

*  Gets bytes from SCI.  Sets COMMAND_PENDING flag.


OutStr0				; send a null terminated string to the display.
	ldaa	1,x+            ; get a character, advance pointer, null?
	beq	OutStrDone      ; yes. return.
	bsr	SerOutput0      ; no. send it out the SCI.
	bra	OutStr0          ; go get the next character.
;
OutStrDone
	rts

;------------------------------------------------------------------------------
SerOutput0
	brclr	SCISR1,TDREflag,SerOutput0     ;check if buffer is empty
	staa	SCIDRL
	rts

SerInputInt0
	ldaa	SCISR1                  ;read register to clear flag RDRF
	ldaa	SCIDRL			;read receive buffer
	rti

;------------------------------------------------------------------------------
* Messages

MSG1	dc.b	'9S12C32 gp2d120 Demo V1.00',$D,$A,0 


;--------------------------INCLUDE FILES START HERE----------------------------

#include Math.Asm

;--------------------------INCLUDE FILES END HERE------------------------------

CalVoltage
	movw	ad2,MANTSGN1-2		;16 bit integer to be converted
	jsr	UINT2FLT
	
	ldab	#5			;Copy VrefDiv1024 into FPACC2
	ldx	#Vref5V
	ldy	#FPACC2EX
	jsr	Datacopy

	jsr	FLTMUL			;Result is the distance

	ldab	#5			;Copy VrefDiv1024 into FPACC2
	ldx	#AD1024
	ldy	#FPACC2EX
	jsr	Datacopy

	jsr	FLTDIV

	ldx	#Float2Ascii		;Convert from Float to ASCII
	jsr	FLTASC			;

	ldx	#Float2Ascii		;Display result
	jsr	OutStr0

	ldx	#mVolt
	jsr	OutStr0

	rts


mVolt	dc.b	' volts    ', $D, $0

;------------------------------------------------------------------------------------------
Datacopy
	movb	1,x+,1,y+		;temporary save
	dbne	b,Datacopy
	rts

;---------------------------------------------------------------------------	
AD1024		dc.b	$8B, $80, $00, $00, $00	;10 bit A/D
Vref5V		dc.b	$83, $A0, $00, $00, $00	;Vref = 5.00000 volts
VrefDiv1024	dc.b	$79, $A0, $00, $00, $00	;Vref/1024 = 5/1024


;==============================================================================
	ORG	VectorTable		;Definition of Vector tables
	dc.w	ResetFunc		;Reserve
	dc.w	ResetFunc		;Reserve
	dc.w	ResetFunc		;Reserve
	dc.w	ResetFunc		;Reserve

	dc.w	ResetFunc		;PWM Emergency Shutdown
	dc.w	ResetFunc		;VREG LVI
	dc.w	ResetFunc		;Port P
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved

	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;CAN transmit
	dc.w	ResetFunc		;CAN receive
	dc.w	ResetFunc		;CAN errors
	dc.w	ResetFunc		;CAN wake-up
	dc.w	ResetFunc		;FLASH

	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserve
	dc.w	ResetFunc		;Reserve

	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved

	dc.w	ResetFunc		;CRG Self Clock Mode
	dc.w	ResetFunc		;CRG PLL lock
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;Reserved

	dc.w	ResetFunc		;Port J (PIEP)
	dc.w	ResetFunc		;Reserved
	dc.w	ResetFunc		;ATD (ATDCTL2 - ASCIE)
	dc.w	ResetFunc		;Reserved
	dc.w	SerInputInt0		;SCI
	dc.w	ResetFunc		;SPI
	dc.w	ResetFunc		;Pulse Accumulator 0 input edge
	dc.w	ResetFunc		;Pulse Accumulator 0 overflow
	dc.w	ResetFunc		;Standard Timer 0 Overflow
	dc.w	ResetFunc		;Timer 0 Channel 7
	dc.w	ResetFunc		;Timer 0 Channel 6
	dc.w	ResetFunc		;Timer 0 Channel 5
	dc.w	ResetFunc		;Timer 0 Channel 4

	dc.w	ResetFunc		;Timer 0 Channel 3
	dc.w	ResetFunc		;Timer 0 Channel 2
	dc.w	ResetFunc		;Timer 0 Channel 1
	dc.w	ResetFunc		;Timer 0 Channel 0

	dc.w	RealTimeInt		;Real Time Interrupt
	dc.w	ResetFunc		;IRQ
	dc.w	ResetFunc		;XIRQ
	dc.w	ResetFunc		;SWI
	dc.w	ResetFunc		;Instruction Trap
	dc.w	ResetFunc		;COP failure
	dc.w	ResetFunc		;Clock Monitor
	dc.w	ResetFunc		;Power On Reset

